/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.wst.css.core.internal.parser.CSSTokenizer;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSValidator;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.w3c.dom.css.CSSRuleList;

public class CSSSelectorValidator
extends CSSValidator
implements IInputValidator {
    private static Reference<CSSSelectorValidator> instanceCache;

    public static CSSSelectorValidator getInstance() {
        CSSSelectorValidator instance = null;
        if (instanceCache != null) {
            instance = instanceCache.get();
        }
        if (instance == null) {
            instance = new CSSSelectorValidator();
            instanceCache = new SoftReference<CSSSelectorValidator>(instance);
        }
        return instance;
    }

    private CSSSelectorValidator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidSelector(String selector) {
        this.cleanValidatingDocument();
        this.getValidatingDocument().set(String.valueOf(selector) + "{}");
        CSSRuleList cssRules = this.getValidatingCSS().getCssRules();
        if (cssRules.getLength() != 1) {
            return false;
        }
        CSSTokenizer cssTokenizer = new CSSTokenizer((Reader)new StringReader(String.valueOf(selector) + "{}"));
        try {
            while (!cssTokenizer.isEOF()) {
                String token = cssTokenizer.primGetNextToken();
                if (!"undefined".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        catch (IOException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        this.cleanValidatingDocument();
        return true;
    }

    public String isValid(String value) {
        return this.isValidSelector(value) ? null : JstUIMessages.CSS_CLASS_NAME_NOT_VALID;
    }
}

