/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.jboss.tools.jst.web.ui.internal.css.browser.CSSBrowser;
import org.jboss.tools.jst.web.ui.internal.css.common.CSSStyleListener;
import org.jboss.tools.jst.web.ui.internal.css.common.ICSSViewListner;
import org.jboss.tools.jst.web.ui.internal.css.common.StyleContainer;
import org.jboss.tools.jst.web.ui.internal.css.messages.CSSUIMessages;
import org.jboss.tools.jst.web.ui.internal.css.view.CSSPreviewPageCreator;

public class CSSPreview
extends ViewPart
implements ICSSViewListner {
    private CSSBrowser browser;
    private Text previewText;
    private String previewContent = CSSUIMessages.CSSPreview_DefaultBrowserText;
    private String currentStyle = new String();
    private Map<String, String> styleAttributes = new HashMap<String, String>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CSSStyleListener.getInstance().addSelectionListener(this);
    }

    public void dispose() {
        CSSStyleListener.getInstance().removeSelectionListener(this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        final SashForm previewComposite = new SashForm(parent, 0);
        previewComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        previewComposite.setLayoutData((Object)gridData);
        this.browser = CSSBrowser.createCSSBrowser((Composite)previewComposite, 2048);
        this.browser.setLayoutData(gridData);
        this.browser.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (CSSPreview.this.browser.isBrowserEvent((TypedEvent)e)) {
                    CSSPreview.this.browser.setEnabled(false);
                    previewComposite.setMaximizedControl((Control)CSSPreview.this.previewText);
                    CSSPreview.this.previewText.setFocus();
                }
            }
        });
        this.updateBrowser();
        this.previewText = new Text((Composite)previewComposite, 256);
        this.previewText.setLayoutData((Object)gridData);
        this.previewText.setText(this.getPreviewContent());
        this.previewText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.widget == CSSPreview.this.previewText) {
                    String text = CSSPreview.this.previewText.getText();
                    if (!CSSPreview.this.getPreviewContent().equals(text)) {
                        if (text.equals("")) {
                            CSSPreview.this.setPreviewContent(CSSUIMessages.CSSPreview_DefaultBrowserText);
                        } else {
                            CSSPreview.this.setPreviewContent(text);
                        }
                        CSSPreview.this.updateBrowser();
                    }
                    CSSPreview.this.browser.setEnabled(true);
                    previewComposite.setMaximizedControl((Control)CSSPreview.this.browser);
                }
            }
        });
        previewComposite.setMaximizedControl((Control)this.browser);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public String generateBrowserPage() {
        return CSSPreviewPageCreator.createPreviewHtml(this.getCurrentStyle(), this.getPreviewContent());
    }

    public String getPreviewContent() {
        return this.previewContent;
    }

    public void setPreviewContent(String previewContent) {
        this.previewContent = previewContent;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Map<String, String> newAttributes = structuredSelection.getFirstElement() instanceof StyleContainer ? ((StyleContainer)structuredSelection.getFirstElement()).getStyleAttributes() : Collections.emptyMap();
            this.updateView(newAttributes);
        }
    }

    public void updateBrowser() {
        this.browser.setText(this.generateBrowserPage());
    }

    protected String getStyle(Map<String, String> styleAttributes) {
        StringBuilder style = new StringBuilder();
        for (Map.Entry<String, String> styleItem : styleAttributes.entrySet()) {
            style.append(String.valueOf(styleItem.getKey()) + ":" + styleItem.getValue() + ";");
        }
        return style.toString();
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    @Override
    public void styleChanged(StyleContainer styleContainer) {
        this.updateView(styleContainer.getStyleAttributes());
    }

    protected void updateView(Map<String, String> attributes) {
        this.styleAttributes = attributes;
        this.currentStyle = this.getStyle(attributes);
        this.updateBrowser();
    }
}

