/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.i18n;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsUtils;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsWizardPage;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsWizardRegisterBundlePage;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExternalizeStringsWizard
extends Wizard {
    public static final String EXTERNALIZE_STRINGS_DIALOG_NEW_FILE_PAGE = "EXTERNALIZE_STRINGS_DIALOG_NEW_FILE_PAGE";
    private ITextEditor editor = null;
    private BundleMap bm = null;
    private ExternalizeStringsWizardPage page1 = null;
    private WizardNewFileCreationPage page2 = null;
    private ExternalizeStringsWizardRegisterBundlePage page3 = null;

    public ExternalizeStringsWizard(ITextEditor editor, BundleMap bm) {
        this.setHelpAvailable(false);
        this.setWindowTitle(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_TITLE);
        this.editor = editor;
        this.bm = bm;
        if (this.bm == null) {
            this.bm = ExternalizeStringsUtils.createBundleMap(editor);
        }
    }

    public void addPages() {
        String fileName;
        int pos;
        super.addPages();
        this.page1 = new ExternalizeStringsWizardPage("ExternalizeStringsWizardBasicPage", this.bm, this.getDocument(), this.getSelectionProvider());
        this.page2 = new WizardNewFileCreationPage(EXTERNALIZE_STRINGS_DIALOG_NEW_FILE_PAGE, (IStructuredSelection)this.getSelectionProvider().getSelection()){

            protected InputStream getInitialContents() {
                return new ByteArrayInputStream(ExternalizeStringsWizard.this.page1.getKeyValuePair().getBytes());
            }

            public boolean canFlipToNextPage() {
                return this.isPageComplete();
            }

            public IWizardPage getNextPage() {
                ExternalizeStringsWizard.this.page3.updateStatus();
                return super.getNextPage();
            }
        };
        this.page3 = new ExternalizeStringsWizardRegisterBundlePage("ExternalizeStringsWizardRegisterBundlePage");
        this.page2.setTitle(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_TITLE);
        this.page2.setDescription(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_DESCRIPTION);
        this.page2.setImageDescriptor(ModelUIImages.getImageDescriptor((String)ModelUIImages.WIZARD_DEFAULT));
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null) {
            this.page2.setContainerFullPath(containerFullPath);
        }
        if ((pos = (fileName = this.getFileName()).lastIndexOf(".")) != -1) {
            fileName = String.valueOf(fileName.substring(0, pos)) + ".properties";
        }
        this.page2.setFileName(fileName);
        this.page2.setFileExtension("properties");
        this.page2.setAllowExistingResources(false);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
    }

    public boolean canFinish() {
        return !this.page1.isNewFile() && this.page1.isPageComplete() || this.page1.isNewFile() && this.page2.isPageComplete() && this.page3.isPageComplete() && this.getContainer().getCurrentPage() == this.page3;
    }

    public boolean performFinish() {
        String bundlePrefix = this.page1.getBundlePrefix();
        String keyName = this.page1.getKey();
        if (!this.page1.isDuplicatedKeyAndValue()) {
            IFile bundleFile = null;
            bundleFile = this.page1.isNewFile() ? this.page2.createNewFile() : this.page1.getBundleFile();
            if (bundleFile == null) {
                return false;
            }
            if (bundleFile.exists() && !this.page1.isNewFile()) {
                String writeToFile = "\n" + this.page1.getKeyValuePair();
                ByteArrayInputStream is = new ByteArrayInputStream(writeToFile.getBytes());
                try {
                    bundleFile.appendContents((InputStream)is, false, true, null);
                    ((InputStream)is).close();
                    is = null;
                }
                catch (CoreException e) {
                    WebUiPlugin.getDefault().logError(e);
                }
                catch (IOException e) {
                    WebUiPlugin.getDefault().logError(e);
                }
            }
            if (this.page1.isNewFile() && !this.page3.isUserDefined()) {
                bundlePrefix = this.page3.getBundleName();
                IProject project = ExternalizeStringsUtils.getProject(this.editor);
                if (project != null) {
                    IStructuredSelection structuredSelection;
                    Object selectedElement;
                    ISelection sel;
                    String fileName;
                    int pos;
                    String userDefinedPath = this.getUserDefinedPath().toString();
                    IResource[] src = EclipseUtil.getJavaSourceRoots((IProject)project);
                    String srcPath = userDefinedPath;
                    String bundlePath = "";
                    if (src.length > 1) {
                        IResource[] iResourceArray = src;
                        int n = src.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource res = iResourceArray[n2];
                            srcPath = res.getFullPath().toString();
                            if (userDefinedPath.indexOf(srcPath) <= -1) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    } else if (src.length == 1) {
                        srcPath = src[0].getFullPath().toString();
                    }
                    bundlePath = userDefinedPath.indexOf(srcPath) > -1 ? userDefinedPath.replaceFirst(srcPath, "").replaceAll("/", "\\.") : userDefinedPath.replaceAll("/", "\\.");
                    if (bundlePath.startsWith(".")) {
                        bundlePath = bundlePath.substring(1);
                    }
                    if ((pos = (fileName = this.page2.getFileName()).indexOf(".properties")) > -1) {
                        fileName = fileName.substring(0, pos);
                    }
                    if (bundlePath.length() != 0) {
                        bundlePath = String.valueOf(bundlePath) + ".";
                    }
                    bundlePath = String.valueOf(bundlePath) + fileName;
                    if (this.page3.isInFacesConfig()) {
                        XModel model = EclipseResourceUtil.getModelNature((IProject)project).getModel();
                        XModelObject facesConfig = ExternalizeStringsUtils.findFacesConfig(model);
                        XModelObject application = facesConfig.getChildByPath("application");
                        XModelObject resourceBundle = facesConfig.getModel().createModelObject("JSFResourceBundle", null);
                        resourceBundle.setAttributeValue("base-name", bundlePath);
                        resourceBundle.setAttributeValue("var", bundlePrefix);
                        try {
                            DefaultCreateHandler.addCreatedObject((XModelObject)application, (XModelObject)resourceBundle, (int)0);
                        }
                        catch (XModelException e) {
                            WebUiPlugin.getDefault().logError("Could not add <resource-bundle> to the faces-config.xml", e);
                        }
                        XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)facesConfig, (Properties)new Properties());
                    } else if (this.page3.isViaLoadBundle() && ExternalizeStringsUtils.isSelectionCorrect(sel = this.getSelectionProvider().getSelection()) && (selectedElement = (structuredSelection = (IStructuredSelection)sel).getFirstElement()) instanceof Node) {
                        AttrImpl attr;
                        Node node = (Node)selectedElement;
                        String jsfCoreTaglibPrefix = ExternalizeStringsUtils.registerMessageTaglib(this.editor);
                        Element loadBundle = node.getOwnerDocument().createElement(String.valueOf(jsfCoreTaglibPrefix) + ":" + "loadBundle");
                        loadBundle.setAttribute("var", bundlePrefix);
                        loadBundle.setAttribute("basename", bundlePath);
                        Node elementToInsertBefore = null;
                        Node refChild = null;
                        if (node.getParentNode() != null) {
                            refChild = node;
                            elementToInsertBefore = node.getParentNode();
                        } else if (node instanceof AttrImpl && (attr = (AttrImpl)node).getOwnerElement().getParentNode() != null) {
                            refChild = attr.getOwnerElement();
                            elementToInsertBefore = attr.getOwnerElement().getParentNode();
                        }
                        ExternalizeStringsUtils.insertLoadBundleTag(elementToInsertBefore, refChild, loadBundle);
                    }
                }
            }
        }
        String replacement = null;
        replacement = keyName.indexOf(".") > -1 ? "#{" + bundlePrefix + "['" + keyName + "']}" : "#{" + bundlePrefix + "." + keyName + "}";
        this.page1.replaceText(replacement);
        return true;
    }

    private IDocument getDocument() {
        IDocumentProvider prov = this.editor.getDocumentProvider();
        return prov.getDocument((Object)this.editor.getEditorInput());
    }

    private ISelectionProvider getSelectionProvider() {
        return this.editor.getSelectionProvider();
    }

    private IPath getContainerFullPath() {
        IPath containerFullPath = null;
        IProject project = ExternalizeStringsUtils.getProject(this.editor);
        if (project != null) {
            IResource[] src = EclipseUtil.getJavaSourceRoots((IProject)project);
            if (src != null && src.length > 0) {
                containerFullPath = src[0].getFullPath();
            }
        } else if (this.editor.getEditorInput() instanceof IStorageEditorInput) {
            try {
                containerFullPath = ((IStorageEditorInput)this.editor.getEditorInput()).getStorage().getFullPath();
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        return containerFullPath;
    }

    protected IPath getUserDefinedPath() {
        return this.page2.getContainerFullPath();
    }

    protected String getFileName() {
        return this.editor.getEditorInput().getName();
    }

    protected IProject getProject() {
        return ExternalizeStringsUtils.getProject(this.editor);
    }
}

