/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.i18n;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsWizard;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class ExternalizeStringsWizardRegisterBundlePage
extends WizardPage
implements SelectionListener {
    public static final String PAGE_NAME = "ExternalizeStringsWizardRegisterBundlePage";
    public static final int FACES_CONFIG = 1;
    public static final int LOAD_BUNDLE = 2;
    public static final int USER_DEFINED = 3;
    private final int DIALOG_WIDTH = 450;
    private final int DIALOG_HEIGHT = 650;
    private Button facesConfig;
    private Button laodBundle;
    private Button userDefined;
    private Label bundleLabel;
    private Text bundleName;
    private Group group;

    public ExternalizeStringsWizardRegisterBundlePage(String pageName) {
        super(pageName, JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_TITLE, ModelUIImages.getImageDescriptor((String)ModelUIImages.WIZARD_DEFAULT));
        this.setDescription(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_DESCRIPTION);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        int pos;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 450;
        gd.heightHint = 650;
        composite.setLayoutData((Object)gd);
        this.bundleLabel = new Label(composite, 0);
        this.bundleLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        this.bundleLabel.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_BUNDLE_NAME);
        this.bundleName = new Text(composite, 2048);
        this.bundleName.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        String fileName = "";
        if (this.getWizard() instanceof ExternalizeStringsWizard && (pos = (fileName = ((ExternalizeStringsWizard)this.getWizard()).getFileName()).lastIndexOf(".")) != -1) {
            fileName = fileName.substring(0, pos);
        }
        this.bundleName.setText(fileName);
        this.group = new Group(composite, 16);
        this.group.setLayout((Layout)new GridLayout(1, true));
        this.group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.group.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_SAVE_RESOURCE_BUNDLE);
        this.facesConfig = new Button((Composite)this.group, 16);
        this.laodBundle = new Button((Composite)this.group, 16);
        this.userDefined = new Button((Composite)this.group, 16);
        this.facesConfig.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_FACES_CONFIG);
        this.laodBundle.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_LOAD_BUNDLE);
        this.userDefined.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_USER_DEFINED);
        this.userDefined.setSelection(true);
        this.facesConfig.addSelectionListener((SelectionListener)this);
        this.laodBundle.addSelectionListener((SelectionListener)this);
        this.userDefined.addSelectionListener((SelectionListener)this);
        this.updateBundleNameField();
        this.setControl((Control)composite);
    }

    public String getBundleName() {
        String name = "";
        if (this.bundleName != null) {
            name = this.bundleName.getText();
        }
        return name;
    }

    public boolean isInFacesConfig() {
        return this.facesConfig != null && this.facesConfig.getSelection();
    }

    public boolean isViaLoadBundle() {
        return this.laodBundle != null && this.laodBundle.getSelection();
    }

    public boolean isUserDefined() {
        return this.userDefined != null && this.userDefined.getSelection();
    }

    public void updateStatus() {
        if (this.isSourceFolderSelected()) {
            this.setMessage(null, 0);
        } else {
            this.setMessage(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_WRONG_BUNDLE_PLACEMENT, 2);
        }
    }

    private void updateBundleNameField() {
        if (this.getWizard() instanceof ExternalizeStringsWizard) {
            if (this.isUserDefined()) {
                this.bundleLabel.setEnabled(false);
                this.bundleName.setEnabled(false);
            } else {
                this.bundleLabel.setEnabled(true);
                this.bundleName.setEnabled(true);
            }
        }
    }

    private boolean isSourceFolderSelected() {
        ExternalizeStringsWizard wiz;
        boolean sourceFolderSelected = false;
        IProject project = null;
        String userDefinedPath = "";
        if (this.getWizard() instanceof ExternalizeStringsWizard && (project = (wiz = (ExternalizeStringsWizard)this.getWizard()).getProject()) != null) {
            userDefinedPath = wiz.getUserDefinedPath().toString();
        }
        if (project != null && !"".equalsIgnoreCase(userDefinedPath)) {
            IResource[] src = EclipseUtil.getJavaSourceRoots((IProject)project);
            String srcPath = "";
            IResource[] iResourceArray = src;
            int n = src.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                srcPath = res.getFullPath().toString();
                if (userDefinedPath.indexOf(srcPath) > -1) {
                    sourceFolderSelected = true;
                    break;
                }
                ++n2;
            }
        }
        return sourceFolderSelected;
    }

    public boolean isPageComplete() {
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateBundleNameField();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateBundleNameField();
    }

    public void setBundleName(String bn) {
        if (this.bundleName != null) {
            if (!"".equalsIgnoreCase(bn)) {
                this.bundleName.setText(bn);
                this.bundleName.setEditable(false);
                this.bundleLabel.setEnabled(false);
                this.group.setEnabled(false);
            } else {
                this.bundleName.setText("");
                this.bundleName.setEditable(true);
                this.bundleLabel.setEnabled(true);
                this.group.setEnabled(true);
            }
        }
    }
}

