/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditorPart;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageSelectionProvider;

public abstract class JSPMultiPageEditorSite
extends MultiPageEditorSite {
    private ISelectionChangedListener fSelChangeListener = null;

    public JSPMultiPageEditorSite(JSPMultiPageEditorPart multiPageEditor, IEditorPart editor) {
        super((MultiPageEditorPart)multiPageEditor, editor);
    }

    public void dispose() {
        super.dispose();
        if (this.fSelChangeListener != null) {
            this.getSelectionProvider().removeSelectionChangedListener(this.fSelChangeListener);
            this.fSelChangeListener = null;
        }
    }

    public String getId() {
        return String.valueOf(ContentTypeIdForJSP.ContentTypeID_JSP) + ".source";
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        if (this.fSelChangeListener == null) {
            this.fSelChangeListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    JSPMultiPageEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.fSelChangeListener;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.getMultiPageEditor().getSite() == null) {
            return null;
        }
        return this.getMultiPageEditor().getSite().getWorkbenchWindow();
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof JSPMultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((JSPMultiPageSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof JSPMultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((JSPMultiPageSelectionProvider)parentProvider).firePostSelectionChanged(newEvent);
        }
    }

    public void progressEnd(Job job) {
    }

    public void progressStart(Job job) {
    }
}

