/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.properties.ConfigurablePropertySheetPage;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ConfigurationPointCalculator;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.editors.dnd.DropCommandFactory;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.jboss.tools.common.model.ui.texteditors.TextMerge;
import org.jboss.tools.common.model.ui.texteditors.dnd.TextEditorDrop;
import org.jboss.tools.common.model.ui.texteditors.dnd.TextEditorDropProvider;
import org.jboss.tools.common.model.ui.views.palette.IIgnoreSelection;
import org.jboss.tools.common.model.ui.views.palette.XModelPaletteInsertHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.text.xml.IOccurrencePreferenceProvider;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.common.text.xml.ui.FreeCaretStyledText;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.jsp.text.xpl.IStructuredTextOccurrenceStructureProvider;
import org.jboss.tools.jst.jsp.text.xpl.StructuredTextOccurrenceStructureProviderRegistry;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.internal.JspContextImpl;
import org.jboss.tools.jst.web.kb.internal.taglib.HTMLTag;
import org.jboss.tools.jst.web.kb.internal.taglib.NameSpace;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDTag;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.HTMLTextViewerConfiguration;
import org.jboss.tools.jst.web.ui.internal.editor.JSPTextViewerConfiguration;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.JspELCompletionProposalComputer;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IJSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.editor.ITextFormatter;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualController;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.SourceEditorPageContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.FileTagProposalLoader;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPTagProposalFactory;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.MobilePaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteItemDropCommand;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteItemDropTargetListener;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.TagProposal;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.xpl.StyledTextDropTargetEffect;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormPropertySheetPage;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPContentOutlineConfiguration;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPPropertySheetConfiguration;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;
import org.jboss.tools.jst.web.ui.internal.editor.ui.action.ExtendedFormatAction;
import org.jboss.tools.jst.web.ui.internal.editor.ui.action.IExtendedAction;
import org.jboss.tools.jst.web.ui.palette.internal.CompoundDropTargetListener;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteItemTransfer;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;
import org.osgi.framework.Bundle;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JSPTextEditor
extends StructuredTextEditor
implements ITextListener,
IJSPTextEditor,
ITextFormatter,
IOccurrencePreferenceProvider {
    private static final String TEXT_EDITOR_KEYBINDING_SCOPE_ID = "org.eclipse.ui.textEditorScope";
    private IStructuredTextOccurrenceStructureProvider fOccurrenceModelUpdater;
    TextEditorDrop dnd = new TextEditorDrop();
    JSPMultiPageEditor parentEditor;
    long timeStamp = -1L;
    long savedTimeStamp = -1L;
    IVisualController vpeController;
    protected SourceEditorPageContext pageContext = null;
    private TextEditorDropProviderImpl textEditorDropProvider;
    private ConfigurableContentOutlinePage fOutlinePage = null;
    private OutlinePageListener fOutlinePageListener = null;
    private IPropertySheetPage fPropertySheetPage;
    static final String FORM_PROPERTY_SHEET_PAGE_CLASS = "org.jboss.tools.jst.web.ui.internal.properties.FormPropertySheetPage";
    boolean modified = false;
    boolean lock = false;
    StyledTextDropTargetEffect dropEffect;
    DropContext dropContext = new DropContext();
    Point storedSelection = new Point(0, 0);
    static int firingSelectionFailedCount = 0;
    BodyListenerImpl listener = null;

    public JSPTextEditor(JSPMultiPageEditor parentEditor) {
        WebUiPlugin.getDefault().initDefaultPluginPreferences();
        this.textEditorDropProvider = new TextEditorDropProviderImpl();
        this.dnd.setTextEditorDropProvider((TextEditorDropProvider)this.textEditorDropProvider);
        this.parentEditor = parentEditor;
        super.setSourceViewerConfiguration((SourceViewerConfiguration)new JSPTextViewerConfiguration());
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration config) {
        if (config instanceof StructuredTextViewerConfigurationJSP) {
            if (!(config instanceof JSPTextViewerConfiguration)) {
                config = new JSPTextViewerConfiguration();
            }
        } else if (config instanceof StructuredTextViewerConfigurationHTML) {
            if (!(config instanceof HTMLTextViewerConfiguration)) {
                config = new HTMLTextViewerConfiguration();
            }
        } else {
            config = new JSPTextViewerConfiguration();
        }
        super.setSourceViewerConfiguration(config);
    }

    public SourceViewerConfiguration getSourceViewerConfigurationForTest() {
        return this.getSourceViewerConfiguration();
    }

    public IVisualContext getPageContext() {
        if (this.pageContext == null) {
            this.pageContext = new SourceEditorPageContext(this.parentEditor);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IDocument document = JSPTextEditor.this.getTextViewer().getDocument();
                int offset = JSPTextEditor.this.getTextViewer().getTextWidget().getCaretOffset();
                IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)JSPTextEditor.this.getTextViewer(), (int)offset);
                Node node = (Node)treeNode;
                JSPTextEditor.this.pageContext.setDocument(document, node);
            }
        };
        Display display = Display.getCurrent();
        if (display != null && Thread.currentThread() == display.getThread()) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
        return this.pageContext;
    }

    protected void initializeDrop(ITextViewer textViewer) {
        StyledText c = textViewer.getTextWidget();
        Label l = new Label((Composite)c, 0);
        l.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (ISourceViewer.class.equals((Object)adapter)) {
            return this.getSourceViewer();
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) {
                IStructuredModel internalModel = this.getModel();
                JSPContentOutlineConfiguration cfg = new JSPContentOutlineConfiguration(this);
                if (cfg != null) {
                    ConfigurableContentOutlinePage outlinePage = new ConfigurableContentOutlinePage();
                    outlinePage.setConfiguration((ContentOutlineConfiguration)cfg);
                    if (internalModel != null) {
                        outlinePage.setInputContentTypeIdentifier(internalModel.getContentTypeIdentifier());
                        outlinePage.setInput((Object)internalModel);
                    }
                    if (this.fOutlinePageListener == null) {
                        this.fOutlinePageListener = new OutlinePageListener();
                    }
                    outlinePage.addSelectionChangedListener((ISelectionChangedListener)this.fOutlinePageListener);
                    outlinePage.addDoubleClickListener((IDoubleClickListener)this.fOutlinePageListener);
                    this.fOutlinePage = outlinePage;
                }
            }
            return this.fOutlinePage;
        }
        if (IPropertySheetPage.class == adapter) {
            JSPPropertySheetConfiguration cfg;
            if ((this.fPropertySheetPage == null || this.fPropertySheetPage.getControl() == null || this.fPropertySheetPage.getControl().isDisposed()) && (cfg = new JSPPropertySheetConfiguration()) != null) {
                Object propertySheetPage;
                boolean isHtml = false;
                if (this.getEditorInput() instanceof IFileEditorInput) {
                    IFileEditorInput f = (IFileEditorInput)this.getEditorInput();
                    isHtml = FileUtil.isHTMLFile((IFile)f.getFile());
                }
                if (isHtml && (propertySheetPage = this.createVisualPropertySheetPage()) != null) {
                    propertySheetPage.setConfiguration((PropertySheetConfiguration)cfg);
                    propertySheetPage.selectionChanged((IWorkbenchPart)this.parentEditor, null);
                    this.fPropertySheetPage = propertySheetPage;
                    return this.fPropertySheetPage;
                }
                propertySheetPage = new ConfigurablePropertySheetPage(){

                    public void setActionBars(IActionBars actionBars) {
                        super.setActionBars(actionBars);
                        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), JSPTextEditor.this.getAction(ITextEditorActionConstants.UNDO));
                        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), JSPTextEditor.this.getAction(ITextEditorActionConstants.REDO));
                    }
                };
                propertySheetPage.setConfiguration((PropertySheetConfiguration)cfg);
                this.fPropertySheetPage = propertySheetPage;
                this.setSorter(cfg.getSorter(), (ConfigurablePropertySheetPage)propertySheetPage);
            }
            return this.fPropertySheetPage;
        }
        return super.getAdapter(adapter);
    }

    private IFormPropertySheetPage createVisualPropertySheetPage() {
        Bundle b = Platform.getBundle((String)"org.jboss.tools.jst.web.ui");
        if (b != null) {
            try {
                return (IFormPropertySheetPage)b.loadClass(FORM_PROPERTY_SHEET_PAGE_CLASS).newInstance();
            }
            catch (ClassNotFoundException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            catch (InstantiationException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            catch (IllegalAccessException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    private void setSorter(PropertySheetSorter sorter, ConfigurablePropertySheetPage sheet) {
        try {
            Method method = PropertySheetPage.class.getDeclaredMethod("setSorter", PropertySheetSorter.class);
            method.setAccessible(true);
            method.invoke((Object)sheet, sorter);
        }
        catch (InvocationTargetException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (SecurityException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public String getEditorId() {
        return "org.eclipse.jst.jsp.ui";
    }

    public IStructuredTextOccurrenceStructureProvider getOccurrencePreferenceProvider() {
        return this.fOccurrenceModelUpdater;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        StructuredTextOccurrenceStructureProviderRegistry registry = XmlEditorPlugin.getDefault().getOccurrenceStructureProviderRegistry("org.jboss.tools.jst.web.ui");
        this.fOccurrenceModelUpdater = registry.getCurrentOccurrenceProvider("org.jboss.tools.jst.web.ui");
        if (this.fOccurrenceModelUpdater != null) {
            this.fOccurrenceModelUpdater.install((StructuredTextEditor)this, (ProjectionViewer)this.getTextViewer());
        }
        this.createDrop();
        this.setModified(false);
        this.getSourceViewer().removeTextListener((ITextListener)this);
        this.getSourceViewer().addTextListener((ITextListener)this);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer sv = super.createSourceViewer(parent, ruler, styles);
        sv.getTextWidget().addFocusListener((FocusListener)new TextFocusListener());
        IContentAssistant ca = this.getSourceViewerConfiguration().getContentAssistant(sv);
        if (ca instanceof ContentAssistant) {
            ((ContentAssistant)ca).enableColoredLabels(true);
        }
        return sv;
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new JSPStructuredTextViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.parentEditor, this);
    }

    public void save() {
        if (!this.lock && this.isModified()) {
            this.lock = true;
            try {
                try {
                    FileAnyImpl f = (FileAnyImpl)this.getModelObject();
                    if (f != null) {
                        f.edit(this.getSourceViewer().getDocument().get());
                    }
                }
                catch (XModelException e) {
                    WebUiPlugin.getPluginLog().logError((Throwable)e);
                    this.setModified(false);
                    this.lock = false;
                }
            }
            finally {
                this.setModified(false);
                this.lock = false;
            }
        }
    }

    public void setModified(boolean set) {
        if (this.modified != set) {
            XModelObject o;
            this.modified = set;
            if (set && (o = this.getModelObject()) != null) {
                o.setModified(true);
            }
            super.firePropertyChange(257);
        }
    }

    public void updateModification() {
        this.getPageContext().refreshBundleValues();
        XModelObject object = this.getModelObject();
        if (object != null && !object.isModified() && this.isModified()) {
            this.setModified(false);
        } else {
            this.firePropertyChange(257);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(XModelObjectEditorInput.checkInput((IEditorInput)input));
        if (this.getSourceViewer() != null && this.getSourceViewer().getDocument() != null) {
            this.getSourceViewer().removeTextListener((ITextListener)this);
            this.getSourceViewer().addTextListener((ITextListener)this);
        }
        if (this.listener != null) {
            this.listener.dispose();
        }
        this.listener = null;
        XModelObject o = this.getModelObject();
        if (o instanceof FileAnyImpl) {
            this.listener = new BodyListenerImpl((FileAnyImpl)o);
        }
    }

    public boolean isDirty() {
        if (this.getEditorInput() instanceof IModelObjectEditorInput) {
            XModelObject o = this.getModelObject();
            if (o != null && o.isModified()) {
                return true;
            }
            return this.isModified();
        }
        return super.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        XModelObject o = this.getModelObject();
        super.doSave(monitor);
        if (!(o == null || monitor != null && monitor.isCanceled())) {
            if (o != null) {
                this.save();
            }
            if (this.getEditorInput() instanceof ILocationProvider) {
                XModelObject p = o.getParent();
                if (p instanceof FolderImpl) {
                    try {
                        ((FolderImpl)p).saveChild(o);
                    }
                    catch (XModelException e) {
                        ModelPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            } else {
                o.setModified(false);
                XModelObjectLoaderUtil.updateModifiedOnSave((XModelObject)o);
            }
            super.firePropertyChange(257);
        }
    }

    public void firePropertyChangeDirty() {
        super.firePropertyChange(257);
    }

    public XModelObject getModelObject() {
        if (this.getEditorInput() instanceof IModelObjectEditorInput) {
            return ((IModelObjectEditorInput)this.getEditorInput()).getXModelObject();
        }
        return null;
    }

    public void textChanged(TextEvent event) {
        if (event.getDocumentEvent() != null) {
            this.setModified(true);
        }
    }

    public void doRevertToSaved() {
        this.save();
        XModelObject o = this.getModelObject();
        if (o == null) {
            super.doRevertToSaved();
            return;
        }
        Properties p = new Properties();
        XActionInvoker.invoke((String)"DiscardActions.Discard", (XModelObject)o, (Properties)p);
        if (!"true".equals(p.getProperty("done"))) {
            return;
        }
        super.doRevertToSaved();
        if (o.isModified()) {
            o.setModified(false);
        }
        this.modified = false;
        this.firePropertyChange(257);
        this.updatePartControl(this.getEditorInput());
    }

    public IAnnotationModel getAnnotationModel() {
        return this.getSourceViewer().getAnnotationModel();
    }

    private String getContentType() {
        String type = null;
        try {
            type = this.getModel().getContentTypeIdentifier();
        }
        finally {
            if (type == null) {
                type = "";
            }
        }
        return type;
    }

    public JSPMultiPageEditor getParentEditor() {
        return this.parentEditor;
    }

    @Override
    public void setVPEController(IVisualController c) {
        this.vpeController = c;
    }

    @Override
    public IVisualController getVPEController() {
        return this.vpeController;
    }

    @Override
    public void runDropCommand(final String flavor, final String data) {
        XModelBuffer b = XModelTransferBuffer.getInstance().getBuffer();
        final XModelObject o = b == null ? null : b.source();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (o != null && !XModelTransferBuffer.getInstance().isEnabled()) {
                    XModelTransferBuffer.getInstance().enable();
                    XModelTransferBuffer.getInstance().getBuffer().addSource(o);
                }
                try {
                    DropData dropData = new DropData(flavor, data, JSPTextEditor.this.getEditorInput(), JSPTextEditor.this.getSourceViewer(), JSPTextEditor.this.getSelectionProvider());
                    if (o == null || !o.getPath().startsWith(PaletteModel.MOBILE_PATH)) {
                        dropData.setValueProvider(JSPTextEditor.this.createAttributeDescriptorValueProvider());
                    }
                    dropData.setAttributeName(JSPTextEditor.this.dropContext.getAttributeName());
                    IDropCommand dropCommand = DropCommandFactory.getInstance().getDropCommand(flavor, (ITagProposalFactory)JSPTagProposalFactory.getInstance());
                    boolean promptAttributes = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Ask for tag attributes during tag insert");
                    dropCommand.getDefaultModel().setPromptForTagAttributesRequired(promptAttributes);
                    dropCommand.execute(dropData);
                }
                finally {
                    XModelTransferBuffer.getInstance().disable();
                }
            }
        };
        if ("true".equals(System.getProperty("org.jboss.tools.common.test"))) {
            runnable.run();
        } else if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public DropUtils.AttributeDescriptorValueProvider createAttributeDescriptorValueProvider() {
        return new AttributeDescriptorValueProviderImpl();
    }

    public StyledTextDropTargetEffect getDropEffect() {
        return this.dropEffect;
    }

    private void createDrop() {
        DropTarget target = new DropTarget((Control)this.getSourceViewer().getTextWidget(), 3);
        Transfer[] types = new Transfer[]{ModelTransfer.getInstance(), HTMLTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance(), PaletteItemTransfer.getInstance()};
        target.setTransfer(types);
        CompoundDropTargetListener dropTargetListener = new CompoundDropTargetListener();
        dropTargetListener.add(new DTL());
        dropTargetListener.add((DropTargetListener)new PaletteItemDropTargetListener(this));
        target.addDropListener((DropTargetListener)dropTargetListener);
        this.dropEffect = new StyledTextDropTargetEffect(this.getSourceViewer().getTextWidget());
        target.setDropTargetEffect((DropTargetEffect)this.dropEffect);
    }

    private int getPosition(int x, int y) {
        ISourceViewer v = this.getSourceViewer();
        int result = 0;
        if (v != null) {
            XModelObject o;
            ITextViewerExtension5 ext;
            int off;
            result = this.getPosition(v.getTextWidget(), x, y);
            if (v instanceof ITextViewerExtension5 && (off = (ext = (ITextViewerExtension5)v).widgetOffset2ModelOffset(result)) >= 0) {
                result = off;
            }
            String path = null;
            if (XModelTransferBuffer.getInstance().isEnabled() && (o = XModelTransferBuffer.getInstance().getBuffer().source()) != null) {
                path = o.getPath();
            }
            result = XModelPaletteInsertHelper.getInstance().correctOffset((IDocument)this.getModel().getStructuredDocument(), result, path);
        }
        return result;
    }

    public int getDropPosition(int x, int y, PaletteItemDropCommand command) {
        ISourceViewer v = this.getSourceViewer();
        int result = 0;
        if (v != null) {
            ITextViewerExtension5 ext;
            int off;
            result = this.getPosition(v.getTextWidget(), x, y);
            if (v instanceof ITextViewerExtension5 && (off = (ext = (ITextViewerExtension5)v).widgetOffset2ModelOffset(result)) >= 0) {
                result = off;
            }
            result = MobilePaletteInsertHelper.getInstance().correctOffset((IDocument)this.getModel().getStructuredDocument(), result, command);
        }
        return result;
    }

    private int getPosition(StyledText t, int x, int y) {
        if (t == null || t.isDisposed()) {
            return 0;
        }
        Point pp = t.toControl(x, y);
        x = pp.x;
        y = pp.y;
        int lineIndex = (t.getTopPixel() + y) / t.getLineHeight();
        if (lineIndex >= t.getLineCount()) {
            return t.getCharCount();
        }
        int c = 0;
        try {
            c = t.getOffsetAtLocation(new Point(x, y));
            if (c < 0) {
                c = 0;
            }
        }
        catch (IllegalArgumentException ex) {
            if (lineIndex + 1 >= t.getLineCount()) {
                return t.getCharCount();
            }
            c = t.getOffsetAtLine(lineIndex + 1) - (t.getLineDelimiter() == null ? 0 : t.getLineDelimiter().length());
        }
        return c;
    }

    @Override
    public String[] getConfigurationPoints() {
        String contentTypeIdentifierID = null;
        if (this.getModel() != null) {
            contentTypeIdentifierID = this.getModel().getContentTypeIdentifier();
        }
        return ConfigurationPointCalculator.getConfigurationPoints((IEditorPart)this, (String)contentTypeIdentifierID, (String)".source", StructuredTextEditor.class);
    }

    @Override
    public void formatTextRegion(IDocument document, IRegion region) {
        SourceViewerConfiguration conf = this.getSourceViewerConfiguration();
        if (conf instanceof StructuredTextViewerConfiguration) {
            StructuredTextViewerConfiguration stvc = (StructuredTextViewerConfiguration)conf;
            IContentFormatter f = stvc.getContentFormatter(this.getSourceViewer());
            f.format(document, region);
        }
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        ISelection selection = this.getSelectionProvider().getSelection();
        Point p = this.getTextViewer().getTextWidget().getSelection();
        if (this.storedSelection == null || !this.storedSelection.equals((Object)p)) {
            ITextSelection ts;
            this.storedSelection = p;
            if (selection instanceof ITextSelection && (ts = (ITextSelection)selection).getLength() == 0 && this.vpeController != null) {
                this.vpeController.selectionChanged(new SelectionChangedEvent(this.getSelectionProvider(), this.getSelectionProvider().getSelection()));
            }
        }
    }

    private void updateRangeIndication0(ISelection selection) {
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            if (objects.length > 0) {
                int start = ((IndexedRegion)objects[0]).getStartOffset();
                int end = ((IndexedRegion)objects[objects.length - 1]).getEndOffset();
                this.getSourceViewer().setRangeIndication(start, end - start, false);
            } else {
                this.getSourceViewer().removeRangeIndication();
            }
        } else if (selection instanceof ITextSelection) {
            this.getSourceViewer().setRangeIndication(((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength(), false);
        } else {
            this.getSourceViewer().removeRangeIndication();
        }
    }

    protected IExtendedAction createExtendedAction(String actionID) {
        if ("FormatDocument".equals(actionID) || ITextEditorActionConstants.UNDO.equals(actionID) || ITextEditorActionConstants.REDO.equals(actionID)) {
            return new ExtendedFormatAction(this, actionID);
        }
        return null;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.getPreferenceStore();
    }

    public void dispose() {
        if (this.dnd != null) {
            this.dnd.setTextEditorDropProvider(null);
            this.dnd = null;
        }
        this.textEditorDropProvider = null;
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().removeTextListener((ITextListener)this);
        }
        if (this.fOutlinePage != null) {
            if (this.fOutlinePage instanceof ConfigurableContentOutlinePage && this.fOutlinePageListener != null) {
                this.fOutlinePage.removeDoubleClickListener((IDoubleClickListener)this.fOutlinePageListener);
            }
            if (this.fOutlinePageListener != null) {
                this.fOutlinePage.removeSelectionChangedListener((ISelectionChangedListener)this.fOutlinePageListener);
            }
        }
        this.fOutlinePage = null;
        this.fOutlinePageListener = null;
        if (this.fOccurrenceModelUpdater != null) {
            this.fOccurrenceModelUpdater.uninstall();
            this.fOccurrenceModelUpdater = null;
        }
        this.fPropertySheetPage = null;
        if (this.pageContext != null) {
            this.pageContext.dispose();
            this.pageContext = null;
        }
        super.dispose();
        if (this.listener != null) {
            this.listener.dispose();
        }
        this.listener = null;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
    }

    public void setText(String text) {
        if (this.getSourceViewer() == null || this.getSourceViewer().getDocument() == null) {
            return;
        }
        String txt = this.getSourceViewer().getDocument().get();
        if (txt != null && txt.length() > 0) {
            if (!TextMerge.replace((IDocument)this.getSourceViewer().getDocument(), (String)text)) {
                this.getSourceViewer().getDocument().set(text);
            }
        } else {
            this.getSourceViewer().getDocument().set(text);
        }
    }

    public boolean isInsideResponseRedirect(Text textNode, int off) {
        if (off < 0) {
            return false;
        }
        String START = "response.sendRedirect(\"";
        String END = "\")";
        String text = textNode.getNodeValue();
        int i = 0;
        while (i < text.length() && i < off) {
            int i1 = text.indexOf(START, i);
            if (i1 < 0 || i1 + START.length() > off) {
                return false;
            }
            int i2 = text.indexOf(END, i1 + START.length());
            if (i2 < 0 || i2 >= off) {
                return true;
            }
            i = i2 + END.length();
        }
        return false;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors() {
        return this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
    }

    class AttributeDescriptorValueProviderImpl
    implements DropUtils.AttributeDescriptorValueProvider {
        TagProposal proposal;
        KbQuery query;
        JspELCompletionProposalComputer processor;
        IPageContext pageContext;

        AttributeDescriptorValueProviderImpl() {
        }

        public void setProposal(ITagProposal proposal) {
            this.setProposal(proposal, false);
        }

        public void setProposal(ITagProposal proposal, boolean useDeclaredLibsOnly) {
            if (this.proposal == proposal) {
                return;
            }
            this.proposal = (TagProposal)proposal;
            String prefix = proposal.getPrefix();
            int offset = JSPTextEditor.this.getTextViewer().getTextWidget().getCaretOffset();
            ValueHelper valueHelper = new ValueHelper();
            this.processor = valueHelper.createContentAssistProcessor();
            this.pageContext = valueHelper.createPageContext(this.processor, offset);
            Map ns = this.pageContext.getNameSpaces(offset);
            List n = (List)ns.get(this.proposal.getUri());
            if (n != null && !n.isEmpty()) {
                prefix = ((INameSpace)n.get(0)).getPrefix();
            }
            this.query = this.createQuery(this.proposal, prefix);
            if (n == null && this.pageContext instanceof JspContextImpl && !useDeclaredLibsOnly) {
                Region r = new Region(this.query.getOffset(), 0);
                ((JspContextImpl)this.pageContext).addNameSpace((IRegion)r, (INameSpace)new NameSpace(this.query.getUri(), this.query.getPrefix(), this.pageContext.getResource() == null ? new ITagLibrary[]{} : TagLibraryManager.getLibraries((IProject)this.pageContext.getResource().getProject(), (String)this.query.getUri())));
            }
        }

        public String getPrefix(String uri, String defaultPrefix) {
            int offset = JSPTextEditor.this.getTextViewer().getTextWidget().getCaretOffset();
            Map ns = this.pageContext.getNameSpaces(offset);
            List n = (List)ns.get(uri);
            if (n != null && !n.isEmpty()) {
                return ((INameSpace)n.get(0)).getPrefix();
            }
            return defaultPrefix;
        }

        public void initContext(Properties context) {
            if (context != null && this.processor != null) {
                context.put("processor", (Object)this.processor);
                context.put("pageContext", this.pageContext);
            }
        }

        public IPageContext getPageContext() {
            return this.pageContext;
        }

        public String getTag() {
            String result = null;
            IComponent c = this.findComponent(this.query);
            if (c != null) {
                result = "*".equals(c.getName()) ? this.proposal.getName() : c.getName();
                String prefix = this.getPrefix(this.query);
                if (prefix != null && prefix.length() > 0) {
                    result = String.valueOf(prefix) + ":" + ("*".equals(c.getName()) ? this.proposal.getName() : c.getName());
                }
            }
            return result;
        }

        public boolean canHaveBody() {
            IComponent c = this.findComponent(this.query);
            return c != null && c.canHaveBody();
        }

        public TagAttributesComposite.AttributeDescriptorValue[] getValues() {
            return this.createDescriptors(this.query);
        }

        KbQuery createQuery(TagProposal proposal, String prefix) {
            KbQuery kbQuery = new KbQuery();
            String name = prefix == null | prefix.length() == 0 ? proposal.getName() : String.valueOf(prefix) + ":" + proposal.getName();
            kbQuery.setPrefix(prefix);
            kbQuery.setUri(proposal.getUri());
            kbQuery.setParentTags(new String[]{name});
            kbQuery.setParent(name);
            kbQuery.setMask(false);
            kbQuery.setType(KbQuery.Type.ATTRIBUTE_NAME);
            kbQuery.setOffset(JSPTextEditor.this.getTextViewer().getTextWidget().getCaretOffset());
            kbQuery.setValue("");
            kbQuery.setStringQuery("");
            return kbQuery;
        }

        public IComponent findComponent(KbQuery query) {
            IComponent[] cs = PageProcessor.getInstance().getComponents(query, this.pageContext, true);
            if (cs == null || cs.length == 0) {
                return null;
            }
            if (cs.length == 1) {
                return cs[0];
            }
            IComponent s = null;
            IComponent[] iComponentArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IComponent c = iComponentArray[n2];
                if (c instanceof TLDTag) {
                    s = c;
                    break;
                }
                if (c instanceof HTMLTag) {
                    s = c;
                }
                ++n2;
            }
            if (s == null) {
                s = cs[0];
            }
            return s;
        }

        public String getPrefix(KbQuery query) {
            Map ns = this.pageContext.getNameSpaces(query.getOffset());
            List n = (List)ns.get(query.getUri());
            return n == null || n.isEmpty() ? null : ((INameSpace)n.get(0)).getPrefix();
        }

        public TagAttributesComposite.AttributeDescriptorValue[] createDescriptors(KbQuery query) {
            query.setMask(true);
            IAttribute[] as = PageProcessor.getInstance().getAttributes(query, this.pageContext);
            query.setMask(false);
            boolean excludeJSFC = FileTagProposalLoader.FACELETS_URI.equals(query.getUri()) && JSPTextEditor.this.getModelObject() != null && "jsp".equalsIgnoreCase(JSPTextEditor.this.getModelObject().getAttributeValue("extension"));
            ArrayList<TagAttributesComposite.AttributeDescriptorValue> attributesValues = new ArrayList<TagAttributesComposite.AttributeDescriptorValue>();
            HashSet<String> names = new HashSet<String>();
            IAttribute[] iAttributeArray = as;
            int n = as.length;
            int n2 = 0;
            while (n2 < n) {
                IAttribute a = iAttributeArray[n2];
                String name = a.getName();
                if (!(excludeJSFC && "jsfc".equals(name) || names.contains(name))) {
                    names.add(name);
                    TagAttributesComposite.AttributeDescriptorValue value = new TagAttributesComposite.AttributeDescriptorValue(name, a.isRequired(), a.isPreferable());
                    attributesValues.add(value);
                }
                ++n2;
            }
            return attributesValues.toArray(new TagAttributesComposite.AttributeDescriptorValue[attributesValues.size()]);
        }
    }

    class BodyListenerImpl
    implements FileAnyImpl.BodyListener {
        FileAnyImpl file;

        BodyListenerImpl(FileAnyImpl file) {
            this.file = file;
            file.addListener((FileAnyImpl.BodyListener)this);
        }

        public void bodyChanged(String body) {
            JSPTextEditor.this.setText(body);
        }

        public void dispose() {
            this.file.removeListener((FileAnyImpl.BodyListener)this);
        }
    }

    class DTL
    implements DropTargetListener {
        int lastpos = -1;
        int lastdetail = -1;
        private int operation;

        DTL() {
        }

        public void dragEnter(DropTargetEvent event) {
            this.lastpos = -1;
            this.operation = event.detail;
            if (!JSPTextEditor.this.isEditable() || JSPTextEditor.this.getModelObject() != null && !JSPTextEditor.this.getModelObject().isObjectEditable()) {
                event.detail = 0;
                return;
            }
            JSPTextEditor.this.dropContext.setDropTargetEvent((TypedEvent)event);
            if (!JSPTextEditor.this.dropContext.isDropAllowed()) {
                event.detail = 0;
                return;
            }
        }

        public void dragLeave(DropTargetEvent event) {
            this.lastpos = -1;
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.lastdetail = this.operation = event.detail;
        }

        public void dragOver(DropTargetEvent event) {
            ITextViewerExtension5 ext;
            int off;
            int position;
            if (!JSPTextEditor.this.isEditable() || JSPTextEditor.this.getModelObject() != null && !JSPTextEditor.this.getModelObject().isObjectEditable()) {
                this.lastdetail = 0;
                event.detail = 0;
                return;
            }
            JSPTagProposalFactory.getInstance();
            JSPTextEditor.this.dropContext.setDropTargetEvent((TypedEvent)event);
            if (JSPTextEditor.this.dropContext.getFlavor() == null) {
                this.lastdetail = 0;
                event.detail = 0;
                return;
            }
            event.feedback = 9;
            int effectPosition = position = JSPTextEditor.this.getPosition(event.x, event.y);
            if (JSPTextEditor.this.getSourceViewer() instanceof ITextViewerExtension5 && (off = (ext = (ITextViewerExtension5)JSPTextEditor.this.getSourceViewer()).modelOffset2WidgetOffset(position)) >= 0) {
                effectPosition = off;
            }
            JSPTextEditor.this.dropEffect.setNewOffset(effectPosition);
            if (this.lastpos == position && position >= 0) {
                position = this.lastpos;
                event.detail = this.lastdetail;
                return;
            }
            this.lastpos = position;
            JSPTextEditor.this.dropContext.clean();
            IndexedRegion region = JSPTextEditor.this.getModel().getIndexedRegion(position);
            if (region instanceof ElementImpl) {
                ElementImpl jspElement = (ElementImpl)region;
                NamedNodeMap attributes = jspElement.getAttributes();
                if (position == jspElement.getStartOffset() || position == jspElement.getEndStartOffset()) {
                    event.detail = this.lastdetail = this.operation;
                    return;
                }
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    if (attribute instanceof AttrImpl) {
                        AttrImpl jspAttr = (AttrImpl)attribute;
                        ITextRegion valueRegion = jspAttr.getValueRegion();
                        if (valueRegion == null) {
                            this.lastdetail = 0;
                            event.detail = 0;
                            return;
                        }
                        int startPos = jspElement.getStartOffset() + valueRegion.getStart();
                        int endPos = jspElement.getStartOffset() + valueRegion.getTextEnd();
                        if (position > startPos && position < endPos) {
                            JSPTextEditor.this.dropContext.setOverAttributeValue(true);
                            JSPTextEditor.this.dropContext.setAttributeName(jspAttr.getNodeName());
                            event.detail = this.lastdetail = this.operation;
                            return;
                        }
                    }
                    ++i;
                }
                this.lastdetail = 0;
                event.detail = 0;
            } else if (region instanceof Text && JSPTextEditor.this.isInsideResponseRedirect((Text)region, position - region.getStartOffset())) {
                JSPTextEditor.this.dropContext.setOverAttributeValue(true);
                event.detail = this.lastdetail = this.operation;
            } else if (region instanceof Text) {
                event.detail = this.lastdetail = this.operation;
            } else if (region instanceof DocumentType) {
                this.lastdetail = 0;
                event.detail = 0;
            } else if (region == null) {
                event.detail = this.lastdetail = this.operation;
            }
        }

        public void drop(DropTargetEvent event) {
            int offset = JSPTextEditor.this.getPosition(event.x, event.y);
            JSPTextEditor.this.selectAndReveal(offset, 0);
            if (event.detail == 1) {
                XModelTransferBuffer.getInstance().setCtrlPressed(true);
            } else {
                XModelTransferBuffer.getInstance().setCtrlPressed(false);
            }
            JSPTextEditor.this.dropContext.runDropCommand((IDNDTextEditor)JSPTextEditor.this, (TypedEvent)event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }

    public static class JSPStructuredTextViewer
    extends StructuredTextViewer
    implements VpeTaglibManagerProvider,
    IIgnoreSelection {
        boolean insertFromPallete = false;
        private VpeTaglibManagerProvider provider;
        private JSPTextEditor editor;
        private boolean ignore = false;

        public JSPStructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
            super(parent, verticalRuler, null, false, styles);
        }

        public JSPStructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, VpeTaglibManagerProvider provider, JSPTextEditor editor) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            this.provider = provider;
            this.editor = editor;
        }

        protected StyledText createTextWidget(Composite parent, int styles) {
            return new FreeCaretStyledText(parent, styles);
        }

        public VpeTaglibManager getTaglibManager() {
            if (this.getEditor() != null && this.getEditor().getPageContext() instanceof VpeTaglibManager) {
                return (VpeTaglibManager)this.getEditor().getPageContext();
            }
            return null;
        }

        public boolean doesIgnore() {
            return this.ignore;
        }

        public void setIgnore(boolean ignore) {
            this.ignore = ignore;
        }

        public void doOperation(int operation) {
            boolean isLongOperation;
            boolean bl = isLongOperation = operation == 1 || operation == 2 || operation == 23 || operation == 24;
            if (isLongOperation && this.editor.getVPEController() != null) {
                this.editor.getVPEController().preLongOperation();
            }
            try {
                super.doOperation(operation);
            }
            finally {
                if (isLongOperation && this.editor.getVPEController() != null) {
                    this.editor.getVPEController().postLongOperation();
                }
            }
        }

        protected void handleDispose() {
            if (this.editor != null && this.editor.getSourceViewer() != null && this.editor.getSourceViewer().getTextWidget() != null && this.editor.getVPEController() != null) {
                StyledText widget = this.editor.getSourceViewer().getTextWidget();
                widget.removeSelectionListener((SelectionListener)this.editor.getVPEController());
            }
            super.handleDispose();
            this.editor = null;
            this.provider = null;
        }

        public JSPTextEditor getEditor() {
            return this.editor;
        }

        public void setEditor(JSPTextEditor editor) {
            this.editor = editor;
        }
    }

    private class OutlinePageListener
    implements IDoubleClickListener,
    ISelectionChangedListener {
        Method m = null;

        private OutlinePageListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection().isEmpty()) {
                return;
            }
            int start = -1;
            int length = 0;
            if (event.getSelection() instanceof IStructuredSelection) {
                Object[] newSelection;
                Object[] current;
                ISelection currentSelection = JSPTextEditor.this.getSelectionProvider().getSelection();
                if (currentSelection instanceof IStructuredSelection && !(current = ((IStructuredSelection)currentSelection).toArray()).equals(newSelection = ((IStructuredSelection)event.getSelection()).toArray())) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object o = selection.getFirstElement();
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o).getEndOffset() - start;
                    } else if (o instanceof ITextRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o).getEnd() - start;
                    } else if (o instanceof IRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o).getLength();
                    }
                }
            } else if (event.getSelection() instanceof ITextSelection) {
                start = ((ITextSelection)event.getSelection()).getOffset();
                length = ((ITextSelection)event.getSelection()).getLength();
            }
            if (start > -1) {
                JSPTextEditor.this.getSourceViewer().setRangeIndication(start, length, false);
                JSPTextEditor.this.selectAndReveal(start, length);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection().isEmpty() || this.isFiringSelection()) {
                return;
            }
            boolean ignoreSelection = false;
            if (JSPTextEditor.this.getSourceViewer() != null && JSPTextEditor.this.getSourceViewer() instanceof IIgnoreSelection) {
                IIgnoreSelection is = (IIgnoreSelection)JSPTextEditor.this.getSourceViewer();
                ignoreSelection = is.doesIgnore();
            }
            if (!(JSPTextEditor.this.getSourceViewer() == null || JSPTextEditor.this.getSourceViewer().getTextWidget() == null || JSPTextEditor.this.getSourceViewer().getTextWidget().isDisposed() || JSPTextEditor.this.getSourceViewer().getTextWidget().isFocusControl() || ignoreSelection)) {
                int start = -1;
                int length = 0;
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object[] newSelection;
                    Object[] currentSelection;
                    ISelection current = JSPTextEditor.this.getSelectionProvider().getSelection();
                    if (current instanceof IStructuredSelection && !Arrays.equals(currentSelection = ((IStructuredSelection)current).toArray(), newSelection = ((IStructuredSelection)event.getSelection()).toArray()) && newSelection.length > 0) {
                        Object o = newSelection[0];
                        if (o instanceof IndexedRegion) {
                            start = ((IndexedRegion)o).getStartOffset();
                            int end = ((IndexedRegion)o).getEndOffset();
                            if (newSelection.length > 1) {
                                int i = 1;
                                while (i < newSelection.length) {
                                    start = Math.min(start, ((IndexedRegion)newSelection[i]).getStartOffset());
                                    end = Math.max(end, ((IndexedRegion)newSelection[i]).getEndOffset());
                                    ++i;
                                }
                                length = end - start;
                            }
                        } else if (o instanceof ITextRegion) {
                            start = ((ITextRegion)o).getStart();
                            int end = ((ITextRegion)o).getEnd();
                            if (newSelection.length > 1) {
                                int i = 1;
                                while (i < newSelection.length) {
                                    start = Math.min(start, ((ITextRegion)newSelection[i]).getStart());
                                    end = Math.max(end, ((ITextRegion)newSelection[i]).getEnd());
                                    ++i;
                                }
                                length = end - start;
                            }
                        } else if (o instanceof IRegion) {
                            start = ((IRegion)o).getOffset();
                            int end = start + ((IRegion)o).getLength();
                            if (newSelection.length > 1) {
                                int i = 1;
                                while (i < newSelection.length) {
                                    start = Math.min(start, ((IRegion)newSelection[i]).getOffset());
                                    end = Math.max(end, ((IRegion)newSelection[i]).getOffset() + ((IRegion)newSelection[i]).getLength());
                                    ++i;
                                }
                                length = end - start;
                            }
                        }
                    }
                } else if (event.getSelection() instanceof ITextSelection) {
                    start = ((ITextSelection)event.getSelection()).getOffset();
                }
                if (start > -1) {
                    JSPTextEditor.this.updateRangeIndication0(event.getSelection());
                    JSPTextEditor.this.selectAndReveal(start, length);
                }
            }
        }

        private boolean isFiringSelection() {
            if (JSPTextEditor.this.getSelectionProvider() == null) {
                return false;
            }
            if (firingSelectionFailedCount > 0) {
                return false;
            }
            try {
                if (this.m == null) {
                    Class<?> c = JSPTextEditor.this.getSelectionProvider().getClass();
                    this.m = c.getDeclaredMethod("isFiringSelection", new Class[0]);
                    this.m.setAccessible(true);
                }
                Boolean b = (Boolean)this.m.invoke((Object)JSPTextEditor.this.getSelectionProvider(), new Object[0]);
                return b;
            }
            catch (NoSuchMethodException e) {
                ++firingSelectionFailedCount;
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ++firingSelectionFailedCount;
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                ++firingSelectionFailedCount;
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                ++firingSelectionFailedCount;
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            return false;
        }
    }

    class TextEditorDropProviderImpl
    implements TextEditorDropProvider {
        TextEditorDropProviderImpl() {
        }

        public ISourceViewer getSourceViewer() {
            return JSPTextEditor.this.getSourceViewer();
        }

        public XModelObject getModelObject() {
            return JSPTextEditor.this.getModelObject();
        }

        public void insert(Properties p) {
            JSPPaletteInsertHelper.getInstance().insertIntoEditor(this.getSourceViewer(), p);
        }
    }

    class TextFocusListener
    extends FocusAdapter {
        TextFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (JSPTextEditor.super.isDirty()) {
                JSPTextEditor.this.save();
            }
        }
    }
}

