/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.common.ui.internal.dnd.ObjectTransfer;
import org.eclipse.wst.common.ui.internal.dnd.ViewerDropAdapter;
import org.eclipse.wst.html.ui.internal.contentoutline.HTMLNodeActionManager;
import org.eclipse.wst.html.ui.views.contentoutline.HTMLContentOutlineConfiguration;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.BaseNodeActionManager;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibComponent;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.JspELCompletionProposalComputer;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IJSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IViewerDropAdapterFactory;
import org.jboss.tools.jst.web.ui.internal.editor.outline.Action;
import org.jboss.tools.jst.web.ui.internal.editor.outline.HTMLAttrDeclImpl;
import org.jboss.tools.jst.web.ui.internal.editor.outline.HTMLCMDataTypeImpl;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPContentOutlineConfiguration
extends HTMLContentOutlineConfiguration {
    IJSPTextEditor editor;
    static IViewerDropAdapterFactory dropAdapterFactory;
    private TransferDropTargetListener[] fTransferDropTargetListeners;
    ValueHelper valueHelper;

    static {
        try {
            Bundle b = Platform.getBundle((String)"org.jboss.tools.vpe");
            if (b != null) {
                Class cls = b.loadClass("org.jboss.tools.vpe.editor.dnd.context.ViewerDropAdapterFactory");
                dropAdapterFactory = (IViewerDropAdapterFactory)cls.newInstance();
            }
        }
        catch (IllegalAccessException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InstantiationException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public JSPContentOutlineConfiguration(IJSPTextEditor editor) {
        this.editor = editor;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(TreeViewer treeViewer) {
        if (this.fTransferDropTargetListeners == null) {
            TransferDropTargetListener[] defaultListeners = super.getTransferDropTargetListeners(treeViewer);
            if (dropAdapterFactory != null) {
                Transfer[] transfers = new Transfer[]{ModelTransfer.getInstance(), HTMLTransfer.getInstance(), ObjectTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
                this.fTransferDropTargetListeners = new TransferDropTargetListener[transfers.length + defaultListeners.length];
                int i = 0;
                while (i < transfers.length) {
                    Transfer transfer = transfers[i];
                    DropContext dropContext = new DropContext();
                    ViewerDropAdapter dropAdapter = dropAdapterFactory.createDropAdapter(transfer, (Viewer)treeViewer, this.editor, transfer, dropContext);
                    this.fTransferDropTargetListeners[i] = new OutlineTransferDropTargetListener(transfer, dropAdapter);
                    ++i;
                }
                System.arraycopy(defaultListeners, 0, this.fTransferDropTargetListeners, transfers.length, defaultListeners.length);
            } else {
                this.fTransferDropTargetListeners = defaultListeners;
            }
        }
        return this.fTransferDropTargetListeners;
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fTransferDropTargetListeners = null;
    }

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        return new HTMLNodeActionManager((IStructuredModel)treeViewer.getInput(), (Viewer)treeViewer){

            protected void contributeAddChildActions(IMenuManager menu, Node node, int ic, int vc) {
                short nodeType = node.getNodeType();
                if (JSPContentOutlineConfiguration.this.valueHelper == null) {
                    JSPContentOutlineConfiguration.this.valueHelper = new ValueHelper();
                }
                if (nodeType == 1) {
                    Element element = (Element)node;
                    BaseNodeActionManager.MyMenuManager addAttributeMenu = new BaseNodeActionManager.MyMenuManager(XMLUIMessages._UI_MENU_ADD_ATTRIBUTE);
                    BaseNodeActionManager.MyMenuManager addChildMenu = new BaseNodeActionManager.MyMenuManager(XMLUIMessages._UI_MENU_ADD_CHILD);
                    menu.add((IContributionItem)addAttributeMenu);
                    menu.add((IContributionItem)addChildMenu);
                    CMElementDeclaration ed = this.modelQuery.getCMElementDeclaration(element);
                    if (ed != null) {
                        ArrayList modelQueryActionList = new ArrayList();
                        this.modelQuery.getInsertActions(element, ed, -1, 1, vc, modelQueryActionList);
                        this.addActionHelper((IMenuManager)addAttributeMenu, modelQueryActionList);
                        modelQueryActionList = new ArrayList();
                        this.modelQuery.getInsertActions(element, ed, -1, ic, vc, modelQueryActionList);
                        this.addActionHelper((IMenuManager)addChildMenu, modelQueryActionList);
                    } else {
                        ArrayList<Action> modelQueryActionList = new ArrayList<Action>();
                        JspELCompletionProposalComputer processor = JSPContentOutlineConfiguration.this.valueHelper.createContentAssistProcessor();
                        int offset = 0;
                        if (element instanceof IndexedRegion) {
                            offset = ((IndexedRegion)element).getStartOffset() + 1;
                        }
                        IPageContext pageContext = JSPContentOutlineConfiguration.this.valueHelper.createPageContext(processor, offset);
                        KbQuery kbQuery = JSPContentOutlineConfiguration.this.createKbQuery(processor, element, offset);
                        IComponent[] components = PageProcessor.getInstance().getComponents(kbQuery, pageContext, true);
                        IComponent d = null;
                        IComponent[] iComponentArray = components;
                        int n = components.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IComponent c = iComponentArray[n2];
                            if (c instanceof ICustomTagLibComponent) {
                                d = c;
                                break;
                            }
                            ++n2;
                        }
                        if (d == null && components.length > 0) {
                            d = components[0];
                        }
                        String query = "/" + element.getNodeName();
                        if (d != null) {
                            IAttribute[] as;
                            IAttribute[] iAttributeArray = as = d.getAttributes();
                            int n3 = as.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IAttribute a = iAttributeArray[n4];
                                String attribute = a.getName();
                                if (!element.hasAttribute(attribute)) {
                                    HTMLAttrDeclImpl ad = new HTMLAttrDeclImpl(attribute, new HTMLCMDataTypeImpl(attribute), 0);
                                    modelQueryActionList.add(new Action(1, element, ad));
                                }
                                ++n4;
                            }
                        }
                        this.addActionHelper((IMenuManager)addAttributeMenu, modelQueryActionList);
                    }
                    this.contributePIAndCommentActions((IMenuManager)addChildMenu, element, ed, -1);
                    this.contributeTextNodeActions((IMenuManager)addChildMenu, element, ed, -1);
                    this.contributeUnconstrainedAddElementAction((IMenuManager)addChildMenu, element, ed, -1);
                    this.contributeUnconstrainedAttributeActions((IMenuManager)addAttributeMenu, element, ed);
                }
            }
        };
    }

    protected KbQuery createKbQuery(JspELCompletionProposalComputer processor, Node fNode, int offset) {
        KbQuery kbQuery = new KbQuery();
        String[] parentTags = processor.getParentTags(false);
        parentTags = this.add(parentTags, fNode.getNodeName());
        String prefix = this.getPrefix(fNode);
        kbQuery.setPrefix(prefix);
        kbQuery.setUri(processor.getUri(prefix));
        kbQuery.setParentTags(parentTags);
        kbQuery.setParent(fNode.getNodeName());
        kbQuery.setMask(false);
        kbQuery.setType(KbQuery.Type.ATTRIBUTE_NAME);
        kbQuery.setOffset(offset);
        kbQuery.setValue("");
        kbQuery.setStringQuery("");
        return kbQuery;
    }

    private String[] add(String[] result, String v) {
        String[] result1 = new String[result.length + 1];
        System.arraycopy(result, 0, result1, 0, result.length);
        result1[result.length] = v;
        return result1;
    }

    private String getPrefix(Node fNode) {
        int i = fNode.getNodeName().indexOf(58);
        return i < 0 ? null : fNode.getNodeName().substring(0, i);
    }

    public static class OutlineTransferDropTargetListener
    implements TransferDropTargetListener {
        private final Transfer transfer;
        private final ViewerDropAdapter dropAdapter;

        public OutlineTransferDropTargetListener(Transfer transfer, ViewerDropAdapter dropAdapter) {
            this.transfer = transfer;
            this.dropAdapter = dropAdapter;
        }

        public void dragEnter(DropTargetEvent event) {
            this.dropAdapter.dragEnter(event);
        }

        public void dragLeave(DropTargetEvent event) {
            this.dropAdapter.dragLeave(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.dropAdapter.dragOperationChanged(event);
        }

        public void dragOver(DropTargetEvent event) {
            this.dropAdapter.dragOver(event);
        }

        public void drop(DropTargetEvent event) {
            this.dropAdapter.drop(event);
        }

        public void dropAccept(DropTargetEvent event) {
            this.dropAdapter.dropAccept(event);
        }

        public Transfer getTransfer() {
            return this.transfer;
        }

        public boolean isEnabled(DropTargetEvent event) {
            return this.getTransfer().isSupportedType(event.currentDataType);
        }
    }
}

