/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class NodesManagingUtil {
    public static int getNodeLength(Node node) {
        if (node instanceof IDOMAttr && ((IDOMAttr)node).getValueSource() != null) {
            return ((IDOMAttr)node).getValueSource().length();
        }
        if (node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getEndOffset() - ((IndexedRegion)node).getStartOffset();
        }
        return 0;
    }

    public static int getStartOffsetNode(Node node) {
        if (node instanceof IDOMAttr) {
            return ((IDOMAttr)node).getValueRegionStartOffset() + 1;
        }
        if (node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getStartOffset();
        }
        return 0;
    }

    public static int getEndOffsetNode(Node node) {
        if (node instanceof IDOMAttr) {
            return NodesManagingUtil.getStartOffsetNode(node) + NodesManagingUtil.getNodeLength(node);
        }
        if (node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getEndOffset();
        }
        return 0;
    }

    public static Point getNodeRange(Node node) {
        return new Point(NodesManagingUtil.getStartOffsetNode(node), NodesManagingUtil.getNodeLength(node));
    }

    public static boolean isNodeContainsPosition(Node node, int position) {
        return NodesManagingUtil.getStartOffsetNode(node) <= position && NodesManagingUtil.getEndOffsetNode(node) >= position;
    }

    public static String getSourceText(Node node) {
        return ((IDOMNode)node).getSource();
    }
}

