/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.jst.web.html.JQueryHTMLConstants;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.AbstractAdvancedPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.IFieldEditorProvider;
import org.jboss.tools.jst.web.ui.internal.properties.html.HTMLFieldEditorFactory;
import org.jboss.tools.jst.web.ui.internal.properties.html.HTMLLayouts;
import org.jboss.tools.jst.web.ui.internal.properties.html.HTMLPropertySetContext;
import org.jboss.tools.jst.web.ui.internal.properties.html.PreferredHTMLAttributes;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class HTMLPropertySetViewer
extends AbstractAdvancedPropertySetViewer
implements JQueryHTMLConstants {
    HTMLPropertySetContext context = new HTMLPropertySetContext(this);
    HTMLLayouts layouts = new HTMLLayouts(this);
    static Set<String> BOOLEAN_ATTRS;

    static {
        String[] attrs;
        BOOLEAN_ATTRS = new HashSet<String>();
        String[] stringArray = attrs = new String[]{"async", "autofocus", "autoplay", "challenge", "checked", "controls", "default", "defer", "disabled", "ismap", "loop", "multiple", "muted", "novalidate", "open", "readonly", "reversed", "scoped", "selected", "seamless"};
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            BOOLEAN_ATTRS.add(a);
            ++n2;
        }
    }

    @Override
    public String getCategoryDisplayName() {
        return "HTML";
    }

    @Override
    protected boolean isStructureChanged(List<IPropertyDescriptor> descriptors) {
        return this.context.update();
    }

    @Override
    protected List<IPropertyDescriptor> getFilteredDescriptors(List<IPropertyDescriptor> descriptors) {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        this.selectDescriptor("id", result);
        if (this.context.isTag("script")) {
            IPropertyDescriptor d = this.getModel().getDescriptor("src");
            if (d != null && !this.isPropertySet(d)) {
                this.selectDescriptor("src", result);
                this.selectDescriptor("type", result);
            } else {
                this.selectDescriptors(PreferredHTMLAttributes.getAttributesByTag(this.context.getElementName()), result);
            }
        } else if (PreferredHTMLAttributes.getAttributesByTag(this.context.getElementName()) != null) {
            String[] attrs = PreferredHTMLAttributes.getAttributesByTag(this.context.getElementName());
            this.selectDescriptors(attrs, result);
        } else if (this.context.isInput() && "hidden".equals(this.context.getTypeName())) {
            this.selectDescriptors(PreferredHTMLAttributes.HIDDEN_INPUT_ATTRS, result);
        } else if (this.context.isInput()) {
            this.selectDescriptors(PreferredHTMLAttributes.COMMON_INPUT_ATTRS, result);
            if (this.context.isNumberType()) {
                this.selectDescriptors(PreferredHTMLAttributes.NUMBER_INPUT_ATTRS, result);
            } else if (this.context.isRangeType()) {
                this.selectDescriptors(PreferredHTMLAttributes.RANGE_INPUT_ATTRS, result);
            } else if (this.context.isTextType()) {
                if (this.context.isPatternTextType()) {
                    this.selectDescriptor("pattern", result);
                }
                this.selectDescriptors(PreferredHTMLAttributes.TEXT_INPUT_ATTRS, result);
                if (this.context.isFileType()) {
                    this.selectDescriptor("multiple", result);
                }
            } else if (!this.context.isButtonType() && (this.context.isCheckbox() || this.context.isRadio())) {
                this.selectDescriptor("checked", result);
            }
        } else if (this.context.isTag("textarea")) {
            this.selectDescriptors(PreferredHTMLAttributes.COMMON_INPUT_ATTRS, result);
            this.selectDescriptors(PreferredHTMLAttributes.TEXT_INPUT_ATTRS, result);
            this.selectDescriptors(PreferredHTMLAttributes.TEXT_AREA_ATTRS, result);
        }
        return result;
    }

    @Override
    protected void layoutEditors(Composite fields, List<AbstractAdvancedPropertySetViewer.Entry> entries) {
        if (this.context.isTag("img")) {
            this.layouts.layoutImage(fields, entries);
        } else if (this.context.isTag("textarea")) {
            this.layouts.layoutTextArea(fields, entries);
        } else if (this.context.isTextType() || this.context.isNumberType() || this.context.isRangeType()) {
            this.layouts.layoutInputText(fields, entries);
        } else if (this.context.isCheckbox() || this.context.isRadio()) {
            this.layouts.layoutInputCheckbox(fields, entries);
        } else if (this.context.isTag("select")) {
            this.layouts.layoutSelect(fields, entries);
        }
        for (AbstractAdvancedPropertySetViewer.Entry e : entries) {
            if (e.isLayout()) continue;
            this.layoutEditor(e, fields, true);
        }
    }

    private boolean isBooleanAttribute(Object id) {
        return BOOLEAN_ATTRS.contains(id);
    }

    @Override
    protected String toVisualValue(String modelValue, IPropertyDescriptor d) {
        if (this.isBooleanAttribute(d.getId())) {
            return this.isPropertySet(d) ? "true" : "false";
        }
        if ("autocomplete".equals(d.getId())) {
            return "off".equals(modelValue) ? "false" : "true";
        }
        return modelValue;
    }

    @Override
    protected Object toModelValue(Object visualValue, IPropertyDescriptor d) {
        if (this.isBooleanAttribute(d.getId())) {
            return visualValue != null && "true".equals(visualValue.toString()) ? d.getId() : null;
        }
        if ("autocomplete".equals(d.getId())) {
            return visualValue != null && "false".equals(visualValue.toString()) ? "off" : "on";
        }
        return visualValue;
    }

    @Override
    protected void initEditorProviders() {
        this.editorProviders.put("action", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createFormActionEditor();
            }
        });
        this.editorProviders.put("alt", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createAltEditor();
            }
        });
        this.editorProviders.put("async", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createAsyncEditor();
            }
        });
        this.editorProviders.put("autofocus", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createAutofocusEditor();
            }
        });
        this.editorProviders.put("autoplay", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("audio") ? WizardDescriptions.audioAutoplay : WizardDescriptions.videoAutoplay;
                return JQueryFieldEditorFactory.createAutoplayEditor(description);
            }
        });
        this.editorProviders.put("autocomplete", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createAutocompleteEditor();
            }
        });
        this.editorProviders.put("border", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createBorderEditor();
            }
        });
        this.editorProviders.put("challenge", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createChallengeEditor();
            }
        });
        this.editorProviders.put("charset", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createCharsetEditor();
            }
        });
        this.editorProviders.put("checked", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = WizardDescriptions.checkboxIsSelected;
                return JQueryFieldEditorFactory.createCheckedEditor(description);
            }
        });
        this.editorProviders.put("cite", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("del") ? WizardDescriptions.delCite : (HTMLPropertySetViewer.this.context.isTag("ins") ? WizardDescriptions.insCite : WizardDescriptions.blockquoteCite);
                return HTMLFieldEditorFactory.createCiteEditor(description);
            }
        });
        this.editorProviders.put("cols", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createColsEditor();
            }
        });
        this.editorProviders.put("colspan", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createColspanEditor();
            }
        });
        this.editorProviders.put("content", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createContentEditor();
            }
        });
        this.editorProviders.put("controls", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("audio") ? WizardDescriptions.audioControls : WizardDescriptions.videoControls;
                return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("controls", WizardMessages.controlsLabel, false, description);
            }
        });
        this.editorProviders.put("coords", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createCoordsEditor();
            }
        });
        this.editorProviders.put("crossorigin", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createCrossoriginEditor();
            }
        });
        this.editorProviders.put("datetime", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("del") ? WizardDescriptions.delDatetime : WizardDescriptions.insDatetime;
                return HTMLFieldEditorFactory.createDatetimeEditor(description);
            }
        });
        this.editorProviders.put("default", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createDefaultEditor();
            }
        });
        this.editorProviders.put("defer", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createDeferEditor();
            }
        });
        this.editorProviders.put("dir", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createDirEditor();
            }
        });
        this.editorProviders.put("disabled", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createDisabledEditor();
            }
        });
        this.editorProviders.put("download", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createDownloadEditor();
            }
        });
        this.editorProviders.put("for", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createForEditor();
            }
        });
        this.editorProviders.put("form", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createFormEditor();
            }
        });
        this.editorProviders.put("headers", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createHeadersEditor();
            }
        });
        this.editorProviders.put("height", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createHeightEditor(WizardDescriptions.imageHeight);
            }
        });
        this.editorProviders.put("high", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createHighEditor();
            }
        });
        this.editorProviders.put("href", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createURLEditor();
            }
        });
        this.editorProviders.put("http-equiv", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createHttpEquiveEditor();
            }
        });
        this.editorProviders.put("icon", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createIconEditor(HTMLPropertySetViewer.this.getContextFile());
            }
        });
        this.editorProviders.put("id", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createIDEditor();
            }
        });
        this.editorProviders.put("ismap", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createIsmapEditor();
            }
        });
        this.editorProviders.put("keytype", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createKeytypeEditor();
            }
        });
        this.editorProviders.put("kind", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createKindEditor();
            }
        });
        this.editorProviders.put("label", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createLabelEditor("label");
            }
        });
        this.editorProviders.put("loop", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("audio") ? WizardDescriptions.audioLoop : WizardDescriptions.videoLoop;
                return JQueryFieldEditorFactory.createLoopEditor(description);
            }
        });
        this.editorProviders.put("low", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createLowEditor();
            }
        });
        this.editorProviders.put("manifest", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createManifestEditor();
            }
        });
        this.editorProviders.put("max", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("meter") ? WizardDescriptions.meterMax : (HTMLPropertySetViewer.this.context.isTag("progress") ? WizardDescriptions.progressMax : (HTMLPropertySetViewer.this.context.isNumberType() ? WizardDescriptions.textInputMax : WizardDescriptions.rangeSliderMax));
                return HTMLFieldEditorFactory.createMaxEditor(description);
            }
        });
        this.editorProviders.put("maxlength", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createMaxlengthEditor();
            }
        });
        this.editorProviders.put("method", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createFormMethodEditor();
            }
        });
        this.editorProviders.put("min", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("meter") ? WizardDescriptions.meterMin : (HTMLPropertySetViewer.this.context.isNumberType() ? WizardDescriptions.textInputMin : WizardDescriptions.rangeSliderMin);
                return HTMLFieldEditorFactory.createMinEditor(description);
            }
        });
        this.editorProviders.put("multiple", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createMultipleEditor();
            }
        });
        this.editorProviders.put("muted", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("audio") ? WizardDescriptions.audioMuted : WizardDescriptions.videoMuted;
                return JQueryFieldEditorFactory.createMutedEditor(description);
            }
        });
        this.editorProviders.put("name", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                if (HTMLPropertySetViewer.this.context.isTag("meta")) {
                    return HTMLFieldEditorFactory.createMetaNameEditor();
                }
                return JQueryFieldEditorFactory.createNameEditor();
            }
        });
        this.editorProviders.put("novalidate", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createNovalidateEditor();
            }
        });
        this.editorProviders.put("open", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isTag("details") ? WizardDescriptions.detailsOpen : WizardDescriptions.dialogOpen;
                return HTMLFieldEditorFactory.createOpenEditor(description);
            }
        });
        this.editorProviders.put("optimum", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createOptimumEditor();
            }
        });
        this.editorProviders.put("pattern", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createPatternEditor();
            }
        });
        this.editorProviders.put("placeholder", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createPlaceholderEditor();
            }
        });
        this.editorProviders.put("poster", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createPosterEditor(HTMLPropertySetViewer.this.getContextFile());
            }
        });
        this.editorProviders.put("preload", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLPropertySetViewer.this.context.isTag("audio") ? JQueryFieldEditorFactory.createPreloadAudioEditor() : JQueryFieldEditorFactory.createPreloadVideoEditor();
            }
        });
        this.editorProviders.put("radiogroup", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createRadiogroupEditor();
            }
        });
        this.editorProviders.put("readonly", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createReadonlyEditor();
            }
        });
        this.editorProviders.put("rel", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                if (HTMLPropertySetViewer.this.context.isTag("area")) {
                    return HTMLFieldEditorFactory.createAreaRelEditor();
                }
                return HTMLFieldEditorFactory.createLinkRelEditor();
            }
        });
        this.editorProviders.put("required", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createRequiredEditor();
            }
        });
        this.editorProviders.put("reversed", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createReversedEditor();
            }
        });
        this.editorProviders.put("rows", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createRowsEditor();
            }
        });
        this.editorProviders.put("rowspan", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createRowspanEditor();
            }
        });
        this.editorProviders.put("sandbox", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createSandboxEditor();
            }
        });
        this.editorProviders.put("scope", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createScopeEditor();
            }
        });
        this.editorProviders.put("scoped", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createScopedEditor();
            }
        });
        this.editorProviders.put("seamless", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createSeamlessEditor();
            }
        });
        this.editorProviders.put("selected", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createSelectedEditor();
            }
        });
        this.editorProviders.put("shape", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createShapeEditor();
            }
        });
        this.editorProviders.put("src", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                if (!HTMLPropertySetViewer.this.context.isTag("script")) {
                    if (HTMLPropertySetViewer.this.context.isTag("audio")) {
                        return HTMLFieldEditorFactory.createAudioSrcEditor(HTMLPropertySetViewer.this.getContextFile());
                    }
                    if (HTMLPropertySetViewer.this.context.isTag("source")) {
                        return HTMLFieldEditorFactory.createSourceSrcEditor(HTMLPropertySetViewer.this.getContextFile(), WizardDescriptions.sourceSrc);
                    }
                    if (HTMLPropertySetViewer.this.context.isTag("source") || HTMLPropertySetViewer.this.context.isTag("embed")) {
                        return HTMLFieldEditorFactory.createSourceSrcEditor(HTMLPropertySetViewer.this.getContextFile(), WizardDescriptions.embedSrc);
                    }
                    if (HTMLPropertySetViewer.this.context.isTag("img")) {
                        return HTMLFieldEditorFactory.createSrcEditor(HTMLPropertySetViewer.this.getContextFile());
                    }
                    if ("iframe".equals(HTMLPropertySetViewer.this.context.getElementName())) {
                        return HTMLFieldEditorFactory.createTextSrcEditor(WizardDescriptions.iframeSrc);
                    }
                }
                return HTMLFieldEditorFactory.createTextSrcEditor("");
            }
        });
        this.editorProviders.put("size", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createSizeEditor();
            }
        });
        this.editorProviders.put("start", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createStartEditor();
            }
        });
        this.editorProviders.put("step", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = HTMLPropertySetViewer.this.context.isNumberType() ? WizardDescriptions.textInputStep : WizardDescriptions.rangeSliderStep;
                return JQueryFieldEditorFactory.createStepEditor(description);
            }
        });
        this.editorProviders.put("type", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                if (HTMLPropertySetViewer.this.context.isTag("link")) {
                    return HTMLFieldEditorFactory.createLinkTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isTag("script")) {
                    return HTMLFieldEditorFactory.createScriptTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isTag("menu")) {
                    return HTMLFieldEditorFactory.createMenuTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isTag("button")) {
                    IFieldEditor f = JQueryFieldEditorFactory.createFormButtonTypeEditor();
                    f.setValue((Object)"");
                    return f;
                }
                if (HTMLPropertySetViewer.this.context.isTag("source")) {
                    return HTMLFieldEditorFactory.createSourceTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isInput()) {
                    return HTMLFieldEditorFactory.createInputTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isTag("ol")) {
                    return HTMLFieldEditorFactory.createOlTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isTag("command")) {
                    return HTMLFieldEditorFactory.createCommandTypeEditor();
                }
                if (HTMLPropertySetViewer.this.context.isTag("style")) {
                    return HTMLFieldEditorFactory.createStyleTypeEditor();
                }
                String description = "";
                if (HTMLPropertySetViewer.this.context.isTag("embed")) {
                    description = WizardDescriptions.embedType;
                }
                return HTMLFieldEditorFactory.createTextTypeEditor(description);
            }
        });
        this.editorProviders.put("value", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createValueEditor();
            }
        });
        this.editorProviders.put("usemap", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createUsemapEditor();
            }
        });
        this.editorProviders.put("width", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createWidthEditor(WizardDescriptions.imageWidth);
            }
        });
        this.editorProviders.put("wrap", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return HTMLFieldEditorFactory.createWrapEditor();
            }
        });
    }
}

