/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.operation;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ClassPathUpdate;
import org.jboss.tools.common.model.project.Watcher;
import org.jboss.tools.common.model.project.WatcherLoader;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.server.RegistrationHelper;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.operation.TemplatePreprocessor;
import org.osgi.framework.Bundle;

public abstract class WebNatureOperation
implements IRunnableWithProgress {
    public static final String DEFAULT_WEB_CONTENT = "WebContent";
    public static final String DEFAULT_WEB_INF = "WEB-INF";
    public static final String DEFAULT_JAVA_SOURCES = "JavaSource";
    public static final String DEFAULT_JAVA_CLASSES = "classes";
    public static final String DEFAULT_WEB_INF_LIBRARY = "lib";
    public static final String PROJECT_NAME_ID = "WebNatureOperation.PROJECT_NAME_ID";
    public static final String PROJECT_LOCATION_ID = "WebNatureOperation.PROJECT_LOCATION_ID";
    public static final String WEB_CONTENT_ID = "WebNatureOperation.WEB_CONTENT_ID";
    public static final String WEB_CONTENT_LOCATION_ID = "WebNatureOperation.WEB_CONTENT_LOCATION_ID";
    public static final String WEB_INF_ID = "WebNatureOperation.WEB_INF_ID";
    public static final String WEB_INF_LOCATION_ID = "WebNatureOperation.WEB_INF_LOCATION_ID";
    public static final String WEB_XML_ID = "WebNatureOperation.WEB_XML_ID";
    public static final String WEB_XML_LOCATION_ID = "WebNatureOperation.WEB_XML_ID";
    public static final String WEB_INF_LIBRARY_ID = "WebNatureOperation.WEB_INF_LIBRARY_ID";
    public static final String WEB_INF_LIBRARY_LOCATION_ID = "WebNatureOperation.WEB_INF_LIBRARY_LOCATION_ID";
    public static final String JAVA_SOURCES_ID = "WebNatureOperation.JAVA_SOURCES_ID";
    public static final String JAVA_SOURCES_LOCATION_ID = "WebNatureOperation.JAVA_SOURCES_LOCATION_ID";
    public static final String JAVA_CREATE_SOURCE_FOLDERS_ID = "WebNatureOperation.JAVA_CREATE_SOURCE_FOLDERS_ID";
    public static final String JAVA_CLASSES_ID = "WebNatureOperation.JAVA_CLASSES_ID";
    public static final String JAVA_CLASSES_LOCATION_ID = "WebNatureOperation.JAVA_CLASSES_LOCATION_ID";
    public static final String JAVA_CLASSPATH_ID = "WebNatureOperation.JAVA_CLASSPATH_ID";
    public static final String SERVLET_VERSION_ID = "WebNatureOperation.SERVLET_VERSION_ID";
    public static final String JSP_VERSION_ID = "WebNatureOperation.JSP_VERSION_ID";
    public static final String WEB_VERSION_ID = "WebNatureOperation.WEB_VERSION_ID";
    public static final String ANT_BUILD_XML_ID = "WebNatureOperation.ANT_BUILD_XML_ID";
    public static final String USE_DEFAULT_LOCATION_ID = "WebNatureOperation.USE_DEFAULT_LOCATION_ID";
    public static final String REGISTER_WEB_CONTEXT_ID = "WebNatureOperation.REGISTER_WEB_CONTEXT_ID";
    public static final String TEMPLATE_ID = "WebNatureOperation.TEMPLATE_ID";
    public static final String TEMPLATE_VERSION_ID = "WebNatureOperation.TEMPLATE_VERSION_ID";
    public static final String RUNTIME_NAME = "WebNatureOperation.RUNTIME_NAME";
    private static final String PROJECT_ID = "WebNatureOperation.PROJECT_ID";
    protected XModel model;
    private HashMap<String, Object> propertyValue = new HashMap();
    private HashMap<String, Object> wizardPropertiesForVelocity = new HashMap();
    private Properties wizardPropertiesAsIs;
    RegisterServerContext registry;
    boolean isCancelled = false;
    protected String[] dotFilesList = new String[]{".classpath", ".project", ".settings/org.jboss.tools.jst.web.xml", ".runtime", ".wtpmodules", ".settings"};
    boolean isProjectRootCleared = false;

    public WebNatureOperation(IProject project, IPath projectLocation, RegisterServerContext registry, Properties properties) {
        this.initDefaults();
        this.setProject(project);
        this.setProperty(PROJECT_NAME_ID, project.getName());
        this.setProperty(PROJECT_LOCATION_ID, projectLocation.toString());
        this.setProperty(WEB_CONTENT_LOCATION_ID, projectLocation.append(DEFAULT_WEB_CONTENT).toString());
        this.setProperty(WEB_INF_LOCATION_ID, projectLocation.append(project.getName()).append(DEFAULT_WEB_CONTENT).append(DEFAULT_WEB_INF).toString());
        this.setProperty(JAVA_CREATE_SOURCE_FOLDERS_ID, Boolean.TRUE);
        this.setProperty(JAVA_CLASSES_LOCATION_ID, projectLocation.append(project.getName()).append(DEFAULT_WEB_CONTENT).append(DEFAULT_WEB_INF).append(DEFAULT_JAVA_CLASSES).toString());
        this.setProperty(WEB_INF_LIBRARY_LOCATION_ID, projectLocation.append(project.getName()).append(DEFAULT_WEB_CONTENT).append(DEFAULT_WEB_INF).append(DEFAULT_WEB_INF_LIBRARY).toString());
        this.setProperty(SERVLET_VERSION_ID, properties.getProperty("servlet version"));
        this.registry = registry;
        this.initWizardPropertiesForVelocity(properties);
        this.wizardPropertiesAsIs = properties;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    protected void initWizardPropertiesForVelocity(Properties properties) {
        this.wizardPropertiesForVelocity.clear();
        Iterator<Object> it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object o = properties.get(key);
            if (o instanceof XModelObject) {
                XModelObject object = (XModelObject)o;
                XModelObject[] cs = object.getChildren();
                int i = 0;
                while (i < cs.length) {
                    String n = cs[i].getAttributeValue("name");
                    String v = cs[i].getAttributeValue("value");
                    if (n != null && v != null) {
                        this.wizardPropertiesForVelocity.put(n.replace(' ', '_'), v);
                    }
                    ++i;
                }
                continue;
            }
            this.wizardPropertiesForVelocity.put(key.replace(' ', '_'), properties.getProperty(key));
        }
    }

    protected void initDefaults() {
        this.setProperty(WEB_CONTENT_ID, DEFAULT_WEB_CONTENT);
        this.setProperty(WEB_INF_ID, DEFAULT_WEB_INF);
        this.setProperty(WEB_INF_LIBRARY_ID, DEFAULT_WEB_INF_LIBRARY);
        this.setProperty(JAVA_SOURCES_ID, DEFAULT_JAVA_SOURCES);
        this.setProperty(JAVA_CLASSES_ID, DEFAULT_JAVA_CLASSES);
    }

    public WebNatureOperation(NewWebProjectContext context) {
        this(context.getProject(), context.getLocationPath(), context.getRegisterServerContext(), context.getActionProperties());
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 25);
        try {
            this.clearProjectRoot(monitor);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                AbstractOperation wcco = this.createWTPNature(monitor);
                monitor.worked(5);
                this.createLockFile();
                monitor.worked(1);
                this.preCreateWebNature();
                JavaCore.create((IProject)this.getProject());
                monitor.worked(3);
                monitor.worked(1);
                this.createWebNature();
                monitor.worked(4);
                this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                monitor.worked(3);
                this.updateJavaNature();
                this.updateVersion();
                this.model.update();
                monitor.worked(2);
                this.model.save();
                monitor.worked(1);
                this.createWTPNature2(wcco, monitor);
                monitor.worked(1);
                this.registerServer2(monitor);
                this.postCreateWebNature();
            }
            catch (CoreException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        finally {
            if (!monitor.isCanceled()) {
                this.deleteLockFile();
            }
            monitor.done();
        }
    }

    private void clearProjectRoot(IProgressMonitor monitor) throws CoreException {
        if (!monitor.isCanceled() && !this.clearProjectRoot()) {
            monitor.setCanceled(true);
        }
    }

    public boolean clearProjectRoot() {
        if (!this.isProjectRootCleared) {
            this.isProjectRootCleared = true;
            IProject project = this.getProject();
            Path projectLocation = new Path(this.getProperty(PROJECT_LOCATION_ID));
            boolean bl = this.isCancelled = !this.checkOverwrite();
            if (!this.isCancelled && !project.exists()) {
                this.removeDotFiles((IPath)projectLocation);
            }
        }
        return !this.isCancelled;
    }

    protected void removeDotFiles(IPath projectLocation) {
        int i = 0;
        while (i < this.dotFilesList.length) {
            File file = projectLocation.append(this.dotFilesList[i]).toFile();
            if (file.exists()) {
                FileUtil.remove((File)file);
            }
            ++i;
        }
    }

    private void updateVersion() throws XModelException {
        Bundle bundle = ModelUIPlugin.getDefault().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        this.model.changeObjectAttribute(FileSystemsHelper.getFileSystems((XModel)this.model), XModelConstants.MODEL_VERSION, version);
    }

    private void registerServer2(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        XModelObject fs = FileSystemsHelper.getFileSystems((XModel)this.model);
        try {
            this.model.changeObjectAttribute(fs, "application name", this.registry.getApplicationName());
        }
        catch (XModelException e) {
            throw new InvocationTargetException(e);
        }
        fs.setModified(true);
        this.model.save();
        if (this.registry.isEnabled()) {
            RegistrationHelper.runRegisterInServerJob((IProject)this.getProject(), (IServer[])this.registry.getTargetServers(), null);
        }
    }

    protected boolean checkOverwrite() {
        return true;
    }

    protected abstract String getNatureID();

    protected abstract void preCreateWebNature() throws CoreException;

    protected abstract void createWebNature() throws CoreException;

    protected abstract void postCreateWebNature();

    private void createLockFile() {
        try {
            this.getProject().setSessionProperty(WatcherLoader.LOCK, (Object)"true");
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void deleteLockFile() {
        try {
            boolean lock = "true".equals(this.getProject().getSessionProperty(WatcherLoader.LOCK));
            if (lock) {
                this.getProject().setSessionProperty(WatcherLoader.LOCK, null);
                if (this.model != null) {
                    Watcher.getInstance((XModel)this.model).forceUpdate();
                }
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void updateJavaNature() throws CoreException {
        EclipseResourceUtil.addNatureToProject((IProject)this.getProject(), (String)"org.eclipse.jdt.core.javanature");
        SpecialWizard w = SpecialWizardFactory.createSpecialWizard((String)"org.jboss.tools.common.model.project.ClassPathUpdateWizard");
        Properties p = new Properties();
        p.put("model", this.model);
        p.put(DEFAULT_JAVA_CLASSES, new Path(this.getProperty(JAVA_CLASSES_LOCATION_ID)));
        w.setObject((Object)p);
        w.execute();
    }

    protected AbstractOperation createWTPNature(IProgressMonitor monitor) throws CoreException {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime o;
        boolean exists = this.getProject().exists();
        String projectName = this.getProperty(PROJECT_NAME_ID);
        String projectLocation = this.getProperty(PROJECT_LOCATION_ID);
        if (this.isLinkingToProjectOutsideWorkspace()) {
            projectLocation = this.createLinks(projectLocation);
        }
        boolean hasJSTWebFacet = false;
        if (exists) {
            Set vs;
            IFacetedProject fp0 = ProjectFacetsManager.create((IProject)this.getProject());
            boolean bl = exists = fp0 != null;
            if (exists && (vs = fp0.getProjectFacets()) != null) {
                for (IProjectFacetVersion v : vs) {
                    String id = v.getProjectFacet().getId();
                    if (!"jst.web".equals(id)) continue;
                    hasJSTWebFacet = true;
                }
            }
        }
        WebFacetProjectCreationDataModelProvider modelProvider = new WebFacetProjectCreationDataModelProvider();
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)modelProvider);
        modelProvider.setDataModel(dataModel);
        AbstractDataModelOperation wcco = (AbstractDataModelOperation)modelProvider.getDefaultOperation();
        wcco.setDataModel(dataModel);
        dataModel.setProperty("IProjectCreationPropertiesNew.PROJECT_NAME", (Object)projectName);
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
        String runtimeName = this.getProperty(RUNTIME_NAME);
        if (runtimeName != null && runtimeName.length() > 0 && (o = this.findFacetRuntime(null)) != null) {
            dataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)o);
        }
        if (!this.isDefaultLocation(projectLocation, true)) {
            dataModel.setProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", (Object)Boolean.FALSE);
            dataModel.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)projectLocation);
        }
        if (!this.getProject().exists()) {
            IProjectDescription pd = ModelPlugin.getWorkspace().newProjectDescription(this.getProject().getName());
            if (!this.isDefaultLocation(projectLocation, true)) {
                pd.setLocation((IPath)new Path(projectLocation));
            }
            this.getProject().create(pd, null);
            this.getProject().open(null);
            JavaCore.create((IProject)this.getProject());
            EclipseResourceUtil.addNatureToProject((IProject)this.getProject(), (String)"org.eclipse.jdt.core.javanature");
        }
        if (this.getProject().exists()) {
            ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)this.getProject(), (IProgressMonitor)monitor);
            String emfNature = "org.eclipse.jem.workbench.JavaEMFNature";
            if (!this.getProject().hasNature(emfNature)) {
                ProjectUtilities.addNatureToProject((IProject)this.getProject(), (String)emfNature);
            }
        }
        if (!exists || !hasJSTWebFacet) {
            this.configFacets(dataModel, projectLocation);
            return wcco;
        }
        return null;
    }

    protected void configFacets(IDataModel dataModel, String projectLocation) {
        String contextRoot;
        String webroot = this.getProperty(WEB_CONTENT_LOCATION_ID);
        String[] javaRoot = (String[])this.getPropertyObject(JAVA_SOURCES_LOCATION_ID);
        String sv = this.getProperty(SERVLET_VERSION_ID);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel configDM = (IDataModel)map.get((Object)"jst.web");
        IDataModel configJavaDM = (IDataModel)map.get((Object)"java");
        if (sv != null && (sv.indexOf("2.3") >= 0 || sv.indexOf("2.4") >= 0 || sv.indexOf("2.5") >= 0 || sv.indexOf("3.0") >= 0)) {
            configDM.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)sv);
        }
        if (configJavaDM != null && sv != null && sv.indexOf("3.0") >= 0) {
            configJavaDM.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.6");
        }
        if ((contextRoot = this.getProperty("WebNatureOperation.CONTEXT_ROOT")) != null && contextRoot.length() > 0 && !contextRoot.equals(this.getProject().getName())) {
            configDM.setProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", (Object)contextRoot);
        }
        if (webroot != null) {
            int i = webroot.lastIndexOf("/");
            String webRootName = webroot.substring(i + 1);
            if (webroot.startsWith(String.valueOf(projectLocation.replace('\\', '/')) + "/")) {
                webRootName = webroot.substring(projectLocation.length() + 1);
            }
            configDM.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)webRootName);
        }
        if (javaRoot != null && javaRoot.length > 0 && javaRoot[0].length() > 0) {
            String jr = javaRoot[0].replace('\\', '/');
            int i = jr.lastIndexOf("/");
            String javaRootName = javaRoot[0].substring(i + 1);
            if (jr.startsWith(String.valueOf(projectLocation.replace('\\', '/')) + "/")) {
                javaRootName = jr.substring(projectLocation.length() + 1);
            }
            configDM.setProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", (Object)javaRootName);
        }
    }

    private void createWTPNature2(AbstractOperation wcco, IProgressMonitor monitor) {
        try {
            if (wcco != null) {
                wcco.execute(monitor, null);
            }
        }
        catch (ExecutionException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected boolean isLinkingToProjectOutsideWorkspace() {
        return false;
    }

    protected boolean hasJavaSource() {
        return true;
    }

    protected boolean isDefaultLocation(String projectLocation, boolean exact) {
        String root = ModelPlugin.getWorkspace().getRoot().getLocation().toString().replace('\\', '/');
        try {
            File f1 = new File(projectLocation);
            if (f1.exists()) {
                String pLocation = String.valueOf(f1.getCanonicalPath().replace('\\', '/')) + '/';
                String rLocation = String.valueOf(ModelPlugin.getWorkspace().getRoot().getLocation().toFile().getCanonicalPath().replace('\\', '/')) + '/' + this.getProject().getName() + '/';
                return exact ? pLocation.equals(rLocation) : pLocation.startsWith(rLocation);
            }
        }
        catch (IOException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        return exact ? (String.valueOf(projectLocation.replace('\\', '/')) + '/').equals(String.valueOf(root) + '/' + this.getProject().getName() + '/') : (String.valueOf(projectLocation.replace('\\', '/')) + '/').startsWith(String.valueOf(root) + '/' + this.getProject().getName() + '/');
    }

    private String createLinks(String projectLocation) throws CoreException {
        IFolder f;
        if (this.isDefaultLocation(projectLocation, false)) {
            return projectLocation;
        }
        IProject project = this.getProject();
        String root = ModelPlugin.getWorkspace().getRoot().getLocation().toString().replace('\\', '/');
        String webroot = this.getProperty(WEB_CONTENT_LOCATION_ID);
        String[] javaRoot = (String[])this.getPropertyObject(JAVA_SOURCES_LOCATION_ID);
        String wsProjectLocation = String.valueOf(root) + "/" + project.getName();
        if (!project.exists()) {
            IProjectDescription pd = ModelPlugin.getWorkspace().newProjectDescription(project.getName());
            project.create(pd, null);
            project.open(null);
            JavaCore.create((IProject)this.getProject());
            EclipseResourceUtil.addNatureToProject((IProject)this.getProject(), (String)"org.eclipse.jdt.core.javanature");
            IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)project);
            IClasspathEntry entry = new ClassPathUpdate().createNewClasspathEntry(project.getFullPath().append("src"), 3);
            try {
                jp.setRawClasspath(new IClasspathEntry[]{entry}, project.getFullPath().append(DEFAULT_JAVA_CLASSES), null);
            }
            catch (CoreException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if (webroot != null) {
            f = project.getFolder("WEB-ROOT");
            if (f.exists()) {
                this.setProperty(WEB_CONTENT_LOCATION_ID, "/WEB-ROOT");
            } else if (project.exists() && webroot.startsWith(String.valueOf(project.getLocation().toString().replace('\\', '/')) + "/")) {
                f = project.getFolder(webroot.substring(project.getLocation().toString().replace('\\', '/').length() + 1));
            }
            if (!f.exists()) {
                f = project.getFolder("WEB-ROOT");
                f.createLink((IPath)new Path(webroot), 1, null);
                this.setProperty(WEB_CONTENT_LOCATION_ID, "/WEB-ROOT");
            }
        }
        if (javaRoot != null && javaRoot.length > 0 && javaRoot[0].length() > 0) {
            f = project.getFolder("src");
            if (!f.exists()) {
                f.createLink((IPath)new Path(javaRoot[0]), 1, null);
            }
            javaRoot[0] = "/src";
        }
        return wsProjectLocation;
    }

    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime findFacetRuntime(IRuntime runtime) {
        String runtimeName = this.getProperty(RUNTIME_NAME);
        if (runtimeName == null) {
            return null;
        }
        if (runtime != null) {
            runtimeName = runtime.getName();
        }
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime r : RuntimeManager.getRuntimes()) {
            if (!runtimeName.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    protected void preprocessTemplate(File sourceDir, File targetDir) throws Exception {
        TemplatePreprocessor preprocessor = new TemplatePreprocessor();
        preprocessor.setSourceDir(sourceDir);
        preprocessor.setTargetDir(targetDir);
        preprocessor.setParameters(this.wizardPropertiesForVelocity);
        preprocessor.execute();
    }

    public String getProperty(String key) {
        return (String)this.propertyValue.get(key);
    }

    public void setProperty(String key, Object value) {
        this.propertyValue.put(key, value);
    }

    public Object getPropertyObject(String key) {
        return this.propertyValue.get(key);
    }

    public void setPropertyObject(String key, Object value) {
        this.propertyValue.put(key, value);
    }

    public IProject getProject() {
        return (IProject)this.getPropertyObject(PROJECT_ID);
    }

    public void setProject(IProject project) {
        this.setPropertyObject(PROJECT_ID, project);
    }

    public Properties getWizardPropertiesAsIs() {
        return this.wizardPropertiesAsIs;
    }

    class RuntimeJob
    extends WorkspaceJob {
        public RuntimeJob() {
            super("Set runtime");
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)WebNatureOperation.this.getProject());
            fp.setRuntime(WebNatureOperation.this.findFacetRuntime(null), monitor);
            return Status.OK_STATUS;
        }
    }
}

