/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.jst.web.ui.palette.CustomDrawerFigure;
import org.jboss.tools.jst.web.ui.palette.MobileDrawerEditPart;
import org.jboss.tools.jst.web.ui.palette.internal.ListFigure;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteDrawerImpl;

class MobileDrawerFigure
extends CustomDrawerFigure {
    private PaletteDrawerImpl category;

    public MobileDrawerFigure(PaletteDrawerImpl category, Control control) {
        super(control);
        this.category = category;
        Figure collapseToggle = (Figure)this.getChildren().get(0);
        Figure title = (Figure)collapseToggle.getChildren().get(0);
        Figure pinFigure = (Figure)title.getChildren().get(0);
        Figure drawerFigure = (Figure)title.getChildren().get(1);
        if (category.getVersions().length > 0) {
            VersionFigure label = new VersionFigure(category.getVersion().toString(), control);
            GridLayout layout = new GridLayout(4, false);
            layout.horizontalSpacing = 4;
            title.setLayoutManager((LayoutManager)layout);
            layout.setConstraint((IFigure)drawerFigure, (Object)new GridData(4, 0, true, false));
            title.add((IFigure)drawerFigure);
            title.add((IFigure)label);
            title.add((IFigure)pinFigure);
        }
    }

    protected void handleExpandStateChanged() {
        super.handleExpandStateChanged();
        if (this.isCalledByButtonModel()) {
            this.category.getPaletteGroup().getPaletteModel().onCategoryExpandChange(this.category.getLabel(), this.isExpanded());
        }
    }

    private boolean isCalledByButtonModel() {
        boolean buttonModel = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            if (ButtonModel.class.getName().endsWith(s.getClassName())) {
                buttonModel = true;
            } else if (MobileDrawerEditPart.class.getName().equals(s.getClassName())) {
                return false;
            }
            ++n2;
        }
        return buttonModel;
    }

    public class VersionFigure
    extends ListFigure {
        public VersionFigure(String text, Control control) {
            super(text, control);
        }

        @Override
        public String[] getValues() {
            return MobileDrawerFigure.this.category.getVersions();
        }

        @Override
        public void setSelected(String value) {
            this.getLabel().setText(value);
            MobileDrawerFigure.this.category.setPreferredVersion(value);
            MobileDrawerFigure.this.category.loadVersion(value);
        }
    }
}

