/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewButtonWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class NewButtonWizard
extends NewJQueryWidgetWizard<NewButtonWizardPage>
implements JQueryConstants {
    public NewButtonWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.BUTTON_IMAGE));
    }

    @Override
    protected NewButtonWizardPage createPage() {
        return new NewButtonWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        IElementGenerator.ElementNode a = parent.addChild("a", ((NewButtonWizardPage)this.page).getEditorValue("label"));
        a.addAttribute("href", ((NewButtonWizardPage)this.page).getEditorValue("url"));
        this.addID("button-", a);
        NewButtonWizard.applyAction((NewButtonWizardPage)this.page, a);
        if (this.getVersion() == JQueryMobileVersion.JQM_1_3) {
            this.addContent13(a);
        } else {
            this.addContent14(a);
        }
    }

    private void addContent13(IElementGenerator.ElementNode a) {
        String themeValue;
        if (this.isTrue("disabled")) {
            a.addAttribute("class", "ui-disabled");
        }
        a.addAttribute("data-role", "button");
        String icon = ((NewButtonWizardPage)this.page).getEditorValue("data-icon");
        if (icon.length() > 0) {
            a.addAttribute("data-icon", icon);
        }
        if ("true".equals(((NewButtonWizardPage)this.page).getEditorValue("icon-only"))) {
            a.addAttribute("data-iconpos", "notext");
        } else {
            String iconpos = ((NewButtonWizardPage)this.page).getEditorValue("data-iconpos");
            if (iconpos.length() > 0) {
                a.addAttribute("data-iconpos", iconpos);
            }
        }
        if (this.isMini()) {
            a.addAttribute("data-mini", "true");
        }
        if (this.isTrue("data-inline")) {
            a.addAttribute("data-inline", "true");
        }
        if (!this.isTrue("data-corners")) {
            a.addAttribute("data-corners", "false");
        }
        if ((themeValue = ((NewButtonWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            a.addAttribute("data-theme", themeValue);
        }
    }

    private void addContent14(IElementGenerator.ElementNode a) {
        String themeValue;
        StringBuilder cls = new StringBuilder();
        cls.append("ui-btn");
        String icon = ((NewButtonWizardPage)this.page).getEditorValue("data-icon");
        if (icon.length() > 0) {
            NewButtonWizard.addClass(cls, "ui-icon-" + icon);
        }
        if (this.isTrue("icon-only")) {
            NewButtonWizard.addClass(cls, "ui-btn-icon-notext");
        } else if (icon.length() > 0) {
            String iconpos = ((NewButtonWizardPage)this.page).getEditorValue("data-iconpos");
            if (iconpos.length() == 0) {
                iconpos = "left";
            }
            NewButtonWizard.addClass(cls, "ui-btn-icon-" + iconpos);
        }
        if (this.isMini()) {
            NewButtonWizard.addClass(cls, "ui-mini");
        }
        if (this.isTrue("data-inline")) {
            NewButtonWizard.addClass(cls, "ui-btn-inline");
        }
        if (this.isTrue("data-corners")) {
            NewButtonWizard.addClass(cls, "ui-corner-all");
        }
        if ((themeValue = ((NewButtonWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            NewButtonWizard.addClass(cls, "ui-btn-" + themeValue);
        }
        if (this.isTrue("disabled")) {
            NewButtonWizard.addClass(cls, "ui-state-disabled");
        }
        a.addAttribute("class", cls.toString());
    }

    public static <P extends AbstractNewHTMLWidgetWizardPage> void applyAction(P page, IElementGenerator.ElementNode a) {
        String action = page.getEditorValue("action");
        if (WizardMessages.actionDialogLabel.equals(action)) {
            a.addAttribute("data-rel", "dialog");
        } else if (WizardMessages.actionPopupLabel.equals(action)) {
            a.addAttribute("data-rel", "popup");
        } else if (WizardMessages.actionBackLabel.equals(action)) {
            a.addAttribute("data-rel", "back");
        } else if (WizardMessages.actionCloseLabel.equals(action)) {
            a.addAttribute("data-rel", "close");
        } else if (WizardMessages.actionExternalLabel.equals(action)) {
            a.addAttribute("data-rel", "external");
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

