/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.web.WebUtils;

public class SRCUtil {
    static Set<String> IMAGE_EXTENSIONS;

    static {
        String[] exts;
        IMAGE_EXTENSIONS = new HashSet<String>();
        String[] stringArray = exts = new String[]{".gif", ".png", ".bmp", ".dib", ".jpg", ".jpeg", ".jpe", ".jif", ".jfif", ".jfi", ".jp2", ".j2k", ".jpf", ".jpx", ".jpm", ".mj2", ".tiff", ".tif", "wav", ".ppm", ".pgm", ".pbm", ".pnm", ".webp", ".3fr", ".ari", ".arw", ".bay", ".crw", ".cr2", ".cap", ".dcs", ".dcr", ".dng", ".drf", ".eip", ".erf", ".fff", ".iiq", ".k25", ".kdc", ".mdc", ".mef", ".mos", ".mrw", ".nef", ".nrw", ".obm", ".orf", ".pef", ".ptx", ".pxn", ".r3d", ".raf", ".raw", ".rwl", ".rw2", ".rwz", ".sr2", ".srf", ".srw", ".x3f"};
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            IMAGE_EXTENSIONS.add(ext);
            ++n2;
        }
    }

    public static String getAbsoluteSrc(IFile current, String src) {
        if (src.startsWith("file:") || src.startsWith("http:") || src.length() == 0) {
            return src;
        }
        if (src.startsWith("/")) {
            IContainer[] iContainerArray = WebUtils.getWebRootFolders((IProject)current.getProject(), (boolean)true);
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer root = iContainerArray[n2];
                IFile f = root.getFile((IPath)new Path(src.substring(1)));
                if (f.exists()) {
                    return f.getLocationURI().toString();
                }
                ++n2;
            }
        }
        IContainer container = current.getParent();
        while (src.startsWith("../") && container != null) {
            container = container.getParent();
            src = src.substring(3);
        }
        if (container != null) {
            return String.valueOf(container.getLocationURI().toString()) + "/" + src;
        }
        return src;
    }

    public static String getRelativePath(IResource selected, IContainer current) {
        if (current.getFullPath().isPrefixOf(selected.getFullPath())) {
            return selected.getFullPath().toString().substring(current.getFullPath().toString().length() + 1);
        }
        IPath[] iPathArray = WebUtils.getWebContentPaths((IProject)current.getProject());
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath root = iPathArray[n2];
            if (root.isPrefixOf(selected.getFullPath())) {
                if (root.isPrefixOf(current.getFullPath())) break;
                return selected.getFullPath().toString().substring(root.toString().length());
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        current = current.getParent();
        while (current != null && (current.getType() == 2 || current.getType() == 4)) {
            sb.append("../");
            if (current.getFullPath().isPrefixOf(selected.getFullPath())) {
                return String.valueOf(sb.toString()) + selected.getFullPath().toString().substring(current.getFullPath().toString().length() + 1);
            }
            current = current.getParent();
        }
        return selected.getLocation().toFile().toURI().toString();
    }

    public static boolean isImageFile(String fileName) {
        int i = fileName.lastIndexOf(46);
        return i >= 0 && IMAGE_EXTENSIONS.contains(fileName.substring(i).toLowerCase());
    }

    public static boolean isVideoFile(String fileName) {
        return true;
    }

    public static boolean isAudioFile(String fileName) {
        return true;
    }
}

