/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteItemTransfer;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteTool;

public class PaletteItemDragSourceListener
extends DragSourceAdapter
implements TransferDragSourceListener {
    EditPartViewer viewer;
    private boolean dragging = false;

    public PaletteItemDragSourceListener(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void dragStart(DragSourceEvent event) {
        IPaletteItem item = this.getPaletteItem();
        if (item == null) {
            event.doit = false;
        }
        this.dragging = true;
        PaletteItemTransfer.getInstance().setPaletteItem(item);
    }

    public void dragSetData(DragSourceEvent event) {
        if (PaletteItemTransfer.getInstance().isSupportedType(event.dataType)) {
            IPaletteItem item = this.getPaletteItem();
            event.data = item;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        PaletteItemTransfer.getInstance().setPaletteItem(null);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PaletteItemDragSourceListener.this.dragging = false;
            }
        });
    }

    private IPaletteItem getPaletteItem() {
        EditPart editpart;
        Object model;
        List selection = this.viewer.getSelectedEditParts();
        if (selection.size() == 1 && (model = (editpart = (EditPart)selection.get(0)).getModel()) instanceof PaletteTool) {
            return ((PaletteTool)((Object)model)).getPaletteItem();
        }
        return null;
    }

    public Transfer getTransfer() {
        return PaletteItemTransfer.getInstance();
    }
}

