/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.ui.palette.internal.RunnablePaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.ILibraryPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteCategory;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteVersionGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteModelImpl;

public class PaletteManager {
    private static PaletteManager instance = new PaletteManager();
    private PaletteModelImpl model = new PaletteModelImpl();

    public static PaletteManager getInstance() {
        return instance;
    }

    private PaletteManager() {
    }

    public String[] getCategories() {
        return this.model.getPaletteGroups();
    }

    public ImageDescriptor getImageDescriptor(String category) {
        return this.model.getPaletteGroup(category).getImageDescriptor();
    }

    public IHTMLLibraryVersion[] getVersions(String groupName) {
        return this.model.getPaletteGroup(groupName).getVersions();
    }

    public Collection<RunnablePaletteItem> getItems(String groupName, IHTMLLibraryVersion version) {
        ArrayList<RunnablePaletteItem> list = new ArrayList<RunnablePaletteItem>();
        IPaletteGroup group = this.model.getPaletteGroup(groupName);
        for (IPaletteVersionGroup versionGroup : group.getPaletteVersionGroups()) {
            if (!version.equals(versionGroup.getVersion())) continue;
            for (IPaletteCategory category : versionGroup.getCategories()) {
                for (IPaletteItem item : category.getItems()) {
                    if (item instanceof ILibraryPaletteItem) continue;
                    list.add(new RunnablePaletteItem(item));
                }
            }
        }
        return list;
    }
}

