/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.internal.editors.PaletteItemResult;
import org.jboss.tools.common.text.IExecutableTextProposal;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteItemDropCommand;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItemWizard;

public class RunnablePaletteItem
implements IExecutableTextProposal {
    private IPaletteItem paletteItem;

    public RunnablePaletteItem(IPaletteItem paletteItem) {
        this.paletteItem = paletteItem;
    }

    public String getCategory() {
        return this.paletteItem.getCategory().getVersionGroup().getGroup().getName();
    }

    public IHTMLLibraryVersion getVersion() {
        return this.paletteItem.getCategory().getVersionGroup().getVersion();
    }

    public String getName() {
        return this.paletteItem.getName();
    }

    public List<String> getAlternatives() {
        return this.paletteItem.getKeywords();
    }

    public PaletteItemResult getResult(JSPTextEditor textEditor) {
        IPaletteItemWizard wizard = this.paletteItem.createWizard();
        if (wizard instanceof AbstractNewHTMLWidgetWizard) {
            return ((AbstractNewHTMLWidgetWizard)wizard).runWithoutUi(textEditor);
        }
        return new PaletteItemResult(this.paletteItem.getStartText(), this.paletteItem.getEndText());
    }

    public void apply(ITextEditor textEditor, int startOffset, int endOffset) {
        IPaletteItemWizard wizard;
        JSPTextEditor jsp = null;
        if (textEditor instanceof JSPTextEditor) {
            jsp = (JSPTextEditor)textEditor;
        } else if (textEditor instanceof JSPMultiPageEditor) {
            jsp = ((JSPMultiPageEditor)textEditor).getJspEditor();
        } else {
            return;
        }
        IDocument document = jsp.getTextViewer().getDocument();
        try {
            if (endOffset > startOffset) {
                document.replace(startOffset, endOffset - startOffset, "");
            }
        }
        catch (BadLocationException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        catch (StringIndexOutOfBoundsException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        if ((wizard = this.paletteItem.createWizard()) instanceof AbstractNewHTMLWidgetWizard) {
            ((AbstractNewHTMLWidgetWizard)wizard).applyWithoutUi(jsp);
        } else {
            DropData dropData = new DropData("palette/item", "", textEditor.getEditorInput(), (ISourceViewer)((JSPMultiPageEditor)textEditor).getJspEditor().getTextViewer(), textEditor.getSelectionProvider());
            PaletteItemDropCommand command = new PaletteItemDropCommand(this.paletteItem, true);
            command.execute(dropData);
        }
    }
}

