/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewCanvasWizardPage;

public class NewCanvasWizard
extends NewHTMLWidgetWizard<NewCanvasWizardPage>
implements HTMLConstants {
    static String prefixId = "canvas-";

    public NewCanvasWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.CANVAS_IMAGE));
    }

    @Override
    protected NewCanvasWizardPage createPage() {
        return new NewCanvasWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        boolean addScriptTemplate = this.isTrue("add-script-template");
        this.addContentInternal(parent, false, addScriptTemplate);
    }

    private void addContentInternal(IElementGenerator.ElementNode parent, boolean browser, boolean addScriptTemplate) {
        IElementGenerator.ElementNode canvas = parent.addChild("canvas", "");
        this.addID(prefixId, canvas);
        this.addAttributeIfNotEmpty(canvas, "width", "width");
        this.addAttributeIfNotEmpty(canvas, "height", "height");
        if (browser || addScriptTemplate) {
            String id = this.getID(prefixId);
            String indent = "    ";
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(indent).append("var canvas = document.getElementById('" + id + "');\n");
            sb.append(indent).append("var ctx = canvas.getContext('2d');\n");
            sb.append(indent).append("//draw to ctx object\n");
            sb.append(indent).append("//Sample code fills canvas with grey color:\n");
            sb.append(indent).append("ctx.fillStyle = '#EEEEEE';\n");
            sb.append(indent).append("ctx.fillRect(0, 0, canvas.width, canvas.height);\n");
            parent.addChild("script", sb.toString());
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode div = body.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContentInternal(div, true, true);
    }
}

