/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.impl;

import java.util.ArrayList;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteCategory;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteVersionGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteTool;

public class PaletteDrawerImpl
extends PaletteDrawer {
    private IPaletteGroup group;

    public PaletteDrawerImpl(IPaletteGroup group) {
        super(group.getName(), group.getImageDescriptor());
        this.group = group;
        this.loadVersion(group.getSelectedVersionGroup().getVersion());
    }

    public void loadVersion(String name) {
        IHTMLLibraryVersion version = this.getVersion(name);
        this.loadVersion(version);
    }

    public void setPreferredVersion(String name) {
        IHTMLLibraryVersion version = this.getVersion(name);
        this.group.getPaletteModel().getPaletteContents().setPreferredVersion(this.getLabel(), version);
    }

    public void loadVersion(IHTMLLibraryVersion version) {
        this.group.setSelectedVersion(version);
        this.setChildren(new ArrayList());
        IPaletteVersionGroup versionGroup = this.group.getSelectedVersionGroup();
        for (IPaletteCategory category : versionGroup.getCategories()) {
            for (IPaletteItem item : category.getItems()) {
                PaletteTool tool = new PaletteTool(item);
                this.add((PaletteEntry)tool);
            }
            this.add((PaletteEntry)new PaletteSeparator());
        }
    }

    public String[] getVersions() {
        String[] strings = new String[this.group.getVersions().length];
        int i = 0;
        while (i < this.group.getVersions().length) {
            strings[i] = this.group.getVersions()[i].toString();
            ++i;
        }
        return strings;
    }

    private IHTMLLibraryVersion getVersion(String versionString) {
        IHTMLLibraryVersion[] iHTMLLibraryVersionArray = this.group.getVersions();
        int n = iHTMLLibraryVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHTMLLibraryVersion version = iHTMLLibraryVersionArray[n2];
            if (version.toString().equals(versionString)) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public IHTMLLibraryVersion getVersion() {
        return this.group.getSelectedVersionGroup().getVersion();
    }

    public IPaletteGroup getPaletteGroup() {
        return this.group;
    }

    public void refresh() {
        this.listeners.firePropertyChange("Default", "old", "new");
    }
}

