/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteCategory;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItemWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteModelImpl;

public class PaletteItemImpl
implements IPaletteItem {
    private String name;
    private String toolTip;
    private String keywords;
    private boolean reformat = true;
    private ImageDescriptor imageDescriptor;
    private Class<? extends IPaletteItemWizard> wizardClass;
    private Class<? extends IPositionCorrector> positionCorrectorClass;
    private String startText = "";
    private String endText = "";
    private IPaletteCategory category;
    private ArrayList<String> keywordList;

    public PaletteItemImpl(String name, String toolTip, String keywords, ImageDescriptor imageDescriptor, Class<? extends IPaletteItemWizard> wizardClass, Class<? extends IPositionCorrector> positionCorrectorClass) {
        this.name = name;
        this.toolTip = toolTip;
        this.keywords = keywords;
        this.imageDescriptor = imageDescriptor;
        this.wizardClass = wizardClass;
        this.positionCorrectorClass = positionCorrectorClass;
    }

    public PaletteItemImpl(String name, String toolTip, String keywords, ImageDescriptor imageDescriptor, Class<? extends IPaletteItemWizard> wizardClass, Class<? extends IPositionCorrector> positionCorrectorClass, String startText, String endText) {
        this(name, toolTip, keywords, imageDescriptor, wizardClass, positionCorrectorClass);
        this.startText = startText;
        this.endText = endText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTooltip() {
        return this.toolTip;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public boolean hasWizard() {
        return this.wizardClass != null;
    }

    @Override
    public IPaletteItemWizard createWizard() {
        IPaletteItemWizard wizard = null;
        if (this.wizardClass != null) {
            try {
                wizard = this.wizardClass.newInstance();
                wizard.setPaletteItem(this);
            }
            catch (InstantiationException e1) {
                WebUiPlugin.getDefault().logError(e1);
            }
            catch (IllegalAccessException e1) {
                WebUiPlugin.getDefault().logError(e1);
            }
        }
        return wizard;
    }

    @Override
    public IPositionCorrector createPositionCorrector() {
        IPositionCorrector positionCorrector = null;
        if (this.positionCorrectorClass != null) {
            try {
                positionCorrector = this.positionCorrectorClass.newInstance();
            }
            catch (InstantiationException e1) {
                WebUiPlugin.getDefault().logError(e1);
            }
            catch (IllegalAccessException e1) {
                WebUiPlugin.getDefault().logError(e1);
            }
        }
        return positionCorrector;
    }

    @Override
    public String getStartText() {
        return this.startText;
    }

    @Override
    public String getEndText() {
        return this.endText;
    }

    @Override
    public List<String> getKeywords() {
        if (this.keywordList == null) {
            this.keywordList = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(this.keywords, " ", false);
            while (tokenizer.hasMoreTokens()) {
                this.keywordList.add(tokenizer.nextToken());
            }
        }
        return this.keywordList;
    }

    @Override
    public String getKeywordsAsString() {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return this.name;
        }
        return this.keywords;
    }

    @Override
    public boolean isReformat() {
        return this.reformat;
    }

    public void setReformat(boolean reformat) {
        this.reformat = reformat;
    }

    @Override
    public IPaletteCategory getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(IPaletteCategory category) {
        this.category = category;
    }

    @Override
    public String getId() {
        return "/" + this.category.getVersionGroup().getGroup().getName() + "/" + this.category.getVersionGroup().getVersion().toString() + "/" + this.getName();
    }

    @Override
    public long getCountIndex() {
        return ((PaletteModelImpl)this.getCategory().getVersionGroup().getGroup().getPaletteModel()).getCountIndex(this.getId());
    }

    @Override
    public void setCountIndex(long countIndex) {
        ((PaletteModelImpl)this.getCategory().getVersionGroup().getGroup().getPaletteModel()).setCountIndex(this.getId(), countIndex);
    }

    public void setProjectCountIndex(long countIndex) {
        ((PaletteModelImpl)this.getCategory().getVersionGroup().getGroup().getPaletteModel()).setProjectCountIndex(countIndex);
    }

    @Override
    public long getNumberOfCalls() {
        return ((PaletteModelImpl)this.getCategory().getVersionGroup().getGroup().getPaletteModel()).getNumberOfCalls(this.getId());
    }

    @Override
    public void setNumberOfCalls(long numberOfCalls) {
        ((PaletteModelImpl)this.getCategory().getVersionGroup().getGroup().getPaletteModel()).setNumberOfCalls(this.getId(), numberOfCalls);
    }

    @Override
    public void called() {
        ((PaletteModelImpl)this.getCategory().getVersionGroup().getGroup().getPaletteModel()).itemCalled(this.getId());
    }
}

