/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.newfile;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.common.zip.UnzipOperation;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.newfile.IDSDataModelProperties;
import org.osgi.framework.Bundle;

class DSDataModelProvider
extends AbstractDataModelProvider
implements IDSDataModelProperties {
    private static final String EMPTY_STRING = "";
    public static File TEMPLATE_FOLDER = null;

    DSDataModelProvider() {
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("project.name");
        names.add("connection.profile");
        names.add("hibernate.connection.driver_class");
        names.add("hibernate.connection.url");
        names.add("hibernate.connection.username");
        names.add("hibernate.connection.password");
        names.add("driver.file");
        names.add("datasource.name");
        names.add("driver.jar.name");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        return super.getDefaultProperty(propertyName);
    }

    public static File getTemplatesFolder() throws IOException {
        if (TEMPLATE_FOLDER == null) {
            Bundle bundle = WebUiPlugin.getDefault().getBundle();
            String version = bundle.getVersion().toString();
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            File templatesDir = FileLocator.getBundleFile((Bundle)bundle);
            if (templatesDir.isFile()) {
                File toCopy = new File(stateLocation.toFile(), version);
                if (!toCopy.exists()) {
                    toCopy.mkdirs();
                    UnzipOperation unZip = new UnzipOperation(templatesDir.getAbsolutePath());
                    unZip.execute(toCopy, "templates.*");
                }
                templatesDir = toCopy;
            }
            TEMPLATE_FOLDER = new File(templatesDir, "templates");
        }
        return TEMPLATE_FOLDER;
    }

    public void init() {
        super.init();
    }

    public static void applyConnectionProfile(IProject project, IDataModel model) {
        IConnectionProfile connProfile;
        if (model.getProperty("connection.profile") != null && (connProfile = ProfileManager.getInstance().getProfileByName(model.getProperty("connection.profile").toString())) != null) {
            int q;
            String jarList;
            DriverInstance driverInstance;
            Properties props = connProfile.getBaseProperties();
            model.setProperty("hibernate.connection.username", (Object)(props.get("org.eclipse.datatools.connectivity.db.username") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.username").toString()));
            model.setProperty("hibernate.connection.driver_class", (Object)(props.get("org.eclipse.datatools.connectivity.db.driverClass") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.driverClass").toString()));
            model.setProperty("hibernate.connection.password", (Object)(props.get("org.eclipse.datatools.connectivity.db.password") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.password").toString()));
            model.setProperty("hibernate.connection.url", (Object)(props.get("org.eclipse.datatools.connectivity.db.URL") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.URL").toString()));
            if (props.get("org.eclipse.datatools.connectivity.driverDefinitionID") != null && (driverInstance = DriverManager.getInstance().getDriverInstanceByID(props.get("org.eclipse.datatools.connectivity.driverDefinitionID").toString())) != null) {
                model.setProperty("driver.file", (Object)driverInstance.getJarListAsArray());
            }
            if ((jarList = props.getProperty("jarList")) != null && (q = jarList.indexOf(".jar")) >= 0) {
                String jar = jarList.substring(0, q + 4);
                int b = jar.replace('\\', '/').lastIndexOf(47);
                String jarName = jar.substring(b + 1);
                model.setProperty("driver.jar.name", (Object)jarName);
            }
        }
    }
}

