/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.newfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.ui.NewConnectionProfileWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.ValidatorFactory;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ComboFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

class NewDSXMLWizardFactory {
    static String EMPTY_PROFILE = "                            ";
    static String AS_5_TEMPLATE = "AS 5      ";
    static String AS_7_TEMPLATE = "EAP 6/AS 7";
    public static String[] TEMPLATE_LIST = new String[]{AS_5_TEMPLATE, AS_7_TEMPLATE};

    NewDSXMLWizardFactory() {
    }

    public static IFieldEditor createTemplateFieldEditor(Object defaultValue) {
        ITaggedFieldEditor result = IFieldEditorFactory.INSTANCE.createRadioEditor("template", Messages.NewDSXMLWizard_TEMPLATE_FIELD, Arrays.asList(TEMPLATE_LIST), Arrays.asList(TEMPLATE_LIST), (Object)TEMPLATE_LIST[1]);
        return result;
    }

    public static IFieldEditor createConnectionProfileSelectionFieldEditor(Object defaultValue, IValidator validator, final boolean canBeEmpty) {
        EditConnectionProfileAction editAction = new EditConnectionProfileAction(validator);
        NewConnectionProfileAction newAction = new NewConnectionProfileAction(validator);
        List<String> profiles = NewDSXMLWizardFactory.getConnectionProfileNameList();
        if (canBeEmpty || profiles.isEmpty()) {
            profiles.add(0, EMPTY_PROFILE);
        }
        IFieldEditor connProfileSelEditor = IFieldEditorFactory.INSTANCE.createComboWithTwoButtons("connection.profile", Messages.NewDSXMLWizard_CONNECTION_PROFILE_FIELD, profiles, defaultValue, false, (ButtonFieldEditor.ButtonPressedAction)editAction, (ButtonFieldEditor.ButtonPressedAction)newAction, ValidatorFactory.NO_ERRORS_VALIDATOR);
        editAction.setEditor(connProfileSelEditor);
        newAction.setEditor(connProfileSelEditor);
        final ButtonFieldEditor editButton = (ButtonFieldEditor)((CompositeEditor)connProfileSelEditor).getEditors().get(2);
        editButton.setEnabled(!"".equals(defaultValue) && !EMPTY_PROFILE.equals(defaultValue));
        if (canBeEmpty || profiles.isEmpty()) {
            connProfileSelEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean ediatble = !"".equals(evt.getNewValue()) && !EMPTY_PROFILE.equals(evt.getNewValue());
                    editButton.setEnabled(ediatble);
                }
            });
        }
        final ComboFieldEditor comboEditor = (ComboFieldEditor)((CompositeEditor)connProfileSelEditor).getEditors().get(1);
        final IProfileListener profileListener = new IProfileListener(){

            private void update() {
                final List profiles = NewDSXMLWizardFactory.getConnectionProfileNameList();
                if (canBeEmpty || profiles.isEmpty()) {
                    profiles.add(0, EMPTY_PROFILE);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        comboEditor.setTags(profiles.toArray(new String[0]));
                    }
                });
            }

            public void profileAdded(IConnectionProfile profile) {
                this.update();
            }

            public void profileChanged(IConnectionProfile profile) {
                this.update();
            }

            public void profileDeleted(IConnectionProfile profile) {
                this.update();
            }
        };
        ProfileManager.getInstance().addProfileListener(profileListener);
        comboEditor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProfileManager.getInstance().removeProfileListener(profileListener);
            }
        });
        return connProfileSelEditor;
    }

    private static List<String> getConnectionProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    private static class ConnectionProfileChangeListener
    implements IProfileListener {
        private IFieldEditor connProfileSelEditor;
        private IValidator validator;

        public ConnectionProfileChangeListener(IValidator validator, IFieldEditor connProfileSelEditor) {
            this.validator = validator;
            this.connProfileSelEditor = connProfileSelEditor;
        }

        public void profileAdded(final IConnectionProfile profile) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionProfileChangeListener.this.connProfileSelEditor.setValue((Object)profile.getName());
                    ((ITaggedFieldEditor)((CompositeEditor)ConnectionProfileChangeListener.this.connProfileSelEditor).getEditors().get(1)).setTags(NewDSXMLWizardFactory.getConnectionProfileNameList().toArray(new String[0]));
                    Control c = (Control)ConnectionProfileChangeListener.this.connProfileSelEditor.getEditorControls()[0];
                    c.getParent().layout();
                    c.getParent().getParent().layout();
                    ConnectionProfileChangeListener.this.validator.validate((Object)profile.getName(), null);
                }
            });
        }

        public void profileChanged(IConnectionProfile profile) {
            this.profileAdded(profile);
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }

    private static class EditConnectionProfileAction
    extends ButtonFieldEditor.ButtonPressedAction {
        private IValidator validator;
        private IFieldEditor connProfileSelEditor;

        public EditConnectionProfileAction(IValidator validator) {
            super(Messages.NewDSXMLWizard_EDIT_BUTTON);
            this.validator = validator;
        }

        public void run() {
            IConnectionProfile selectedProfile = ProfileManager.getInstance().getProfileByName(this.getFieldEditor().getValue().toString());
            String oldName = this.getFieldEditor().getValue().toString();
            if (selectedProfile == null) {
                return;
            }
            PropertyDialog.createDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)"org.eclipse.datatools.connectivity.db.generic.profileProperties", (Object)selectedProfile).open();
            if (!oldName.equals(selectedProfile.getName())) {
                this.getFieldEditor().setValue((Object)selectedProfile.getName());
                ((ITaggedFieldEditor)((CompositeEditor)this.connProfileSelEditor).getEditors().get(1)).setTags(NewDSXMLWizardFactory.getConnectionProfileNameList().toArray(new String[0]));
                oldName = selectedProfile.getName();
            }
            this.validator.validate((Object)selectedProfile.getName(), null);
        }

        public void setEditor(IFieldEditor connProfileSelEditor) {
            this.connProfileSelEditor = connProfileSelEditor;
        }
    }

    private static class NewConnectionProfileAction
    extends ButtonFieldEditor.ButtonPressedAction {
        private IValidator validator;
        private IFieldEditor connProfileSelEditor;

        public NewConnectionProfileAction(IValidator validator) {
            super(Messages.NewDSXMLWizard_NEW_BUTTON);
            this.validator = validator;
        }

        public void run() {
            ConnectionProfileChangeListener listener = new ConnectionProfileChangeListener(this.validator, this.connProfileSelEditor);
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            NewCPWizardCategoryFilter filter = new NewCPWizardCategoryFilter("org.eclipse.datatools.connectivity.db.category");
            NewCPWizard wizard = new NewCPWizard((ViewerFilter)filter, null);
            new NewConnectionProfileWizard(){

                public boolean performFinish() {
                    try {
                        ProfileManager.getInstance().createProfile(this.getProfileName() == null ? "" : this.getProfileName(), this.getProfileDescription() == null ? "" : this.getProfileDescription(), this.mProviderID, this.getProfileProperties(), this.mProfilePage.getRepository() == null ? "" : this.mProfilePage.getRepository().getName(), false);
                    }
                    catch (ConnectionProfileException e) {
                        WebUiPlugin.getPluginLog().logError((Throwable)e);
                    }
                    return true;
                }
            };
            WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            wizardDialog.open();
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        }

        public void setEditor(IFieldEditor connProfileSelEditor) {
            this.connProfileSelEditor = connProfileSelEditor;
        }
    }
}

