/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.jst.web.context.ImportWebWarContext;
import org.jboss.tools.jst.web.ui.wizards.appregister.AppRegisterComponent;

public class ImportWebWarWizardPage
extends WizardPage {
    protected ImportWebWarContext context;
    private XAttributeSupport support;
    AppRegisterComponent appRegister = new AppRegisterComponent();
    private IModelPropertyEditorAdapter warLocationAdapter;
    private IModelPropertyEditorAdapter nameLocationAdapter;
    private IModelPropertyEditorAdapter useDefaultPathAdapter;
    private IModelPropertyEditorAdapter projectLocationAdapter;
    private IPropertyEditor projectLocationEditor;
    private Composite supportControl;
    Path defaultPath = (Path)ModelUIPlugin.getWorkspace().getRoot().getLocation();
    boolean lock = false;
    InputChangeListener inputListener = new InputChangeListener();

    public ImportWebWarWizardPage(ImportWebWarContext context) {
        super("Wizard Page");
        this.context = context;
        XEntityDataImpl entityData = XEntityDataImpl.create((String[][])new String[][]{{"WebPrjAdoptWarStep0", ""}, {"*.war location", "yes"}, {"name", "yes"}, {"use default path", "no"}, {"location", "yes"}});
        XAttributeData[] ad = entityData.getAttributeData();
        int i = 0;
        while (i < ad.length) {
            ad[i].setValue(ad[i].getAttribute().getDefaultValue());
            ++i;
        }
        this.support = new XAttributeSupport(ModelUtilities.getPreferenceModel().getRoot(), (XEntityData)entityData);
        this.support.setLayout(this.getLayoutForSupport());
        this.warLocationAdapter = this.support.getPropertyEditorAdapterByName("*.war location");
        this.nameLocationAdapter = this.support.getPropertyEditorAdapterByName("name");
        this.useDefaultPathAdapter = this.support.getPropertyEditorAdapterByName("use default path");
        this.projectLocationAdapter = this.support.getPropertyEditorAdapterByName("location");
        this.appRegister.setContext(context.getRegisterServerContext());
        this.appRegister.setEnabling(false);
        this.appRegister.init();
        this.initListeners();
    }

    private Layout getLayoutForSupport() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 4;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        return gridLayout;
    }

    private Layout getLayoutForAppRegister() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 4;
        gridLayout.horizontalSpacing = 16;
        gridLayout.verticalSpacing = 10;
        return gridLayout;
    }

    public void createControl(Composite parent) {
        Composite control;
        this.initializeDialogUnits((Control)parent);
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(768));
        c.setLayout((Layout)new GridLayout());
        this.supportControl = control = this.support.createControl(c);
        control.setLayoutData((Object)new GridData(768));
        this.projectLocationEditor = this.support.getPropertyEditorByName("location");
        this.updateLocationEditor();
        this.initListeners();
        this.createRegisterControl(c);
        this.setControl((Control)c);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.context.getErrorMessage() == null);
    }

    private boolean isDefaultPath() {
        return "true".equals(this.useDefaultPathAdapter.getStringValue(true));
    }

    private void updateLocationEditor() {
        if (this.projectLocationEditor == null) {
            return;
        }
        this.projectLocationEditor.getFieldEditor(this.supportControl).setEnabled(!this.isDefaultPath(), this.supportControl);
    }

    private void onWarLocationChanged() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            this.context.setWarLocation(this.warLocationAdapter.getStringValue(true));
            this.appRegister.loadApplicationName();
            this.nameLocationAdapter.setValue((Object)this.context.getProjectName());
            this.onUseDefaultChanged();
            this.setPageComplete(this.validatePage());
            this.getContainer().updateButtons();
        }
        finally {
            this.lock = false;
        }
    }

    private void onNameChanged() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            this.context.setProjectName(this.nameLocationAdapter.getStringValue(true));
            this.appRegister.loadApplicationName();
            if (!this.isDefaultPath()) {
                return;
            }
            this.context.setCustomerLocation(this.getDefaultLocation());
            this.projectLocationAdapter.setValue((Object)this.getDefaultLocation());
            this.setPageComplete(this.validatePage());
            this.getContainer().updateButtons();
        }
        finally {
            this.lock = false;
        }
    }

    private void onUseDefaultChanged() {
        this.updateLocationEditor();
        if (!this.isDefaultPath()) {
            return;
        }
        this.context.setCustomerLocation(this.getDefaultLocation());
        this.projectLocationAdapter.setValue((Object)this.getDefaultLocation());
    }

    private String getDefaultLocation() {
        IProject p = this.context.getProjectHandle();
        if (p == null) {
            return this.defaultPath.toOSString();
        }
        return String.valueOf(this.defaultPath.toOSString()) + "/" + p.getName();
    }

    public Control createRegisterControl(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.appRegister.setLayoutForSupport(this.getLayoutForAppRegister());
        Control ch = this.appRegister.createControl(parent);
        ch.setLayoutData((Object)new GridData(768));
        return ch;
    }

    private boolean validatePage() {
        String message = this.context.getErrorMessage();
        this.setErrorMessage(message);
        this.setMessage(null);
        return message == null;
    }

    private void initListeners() {
        this.warLocationAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImportWebWarWizardPage.this.onWarLocationChanged();
            }
        });
        this.nameLocationAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImportWebWarWizardPage.this.onNameChanged();
            }
        });
        this.useDefaultPathAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImportWebWarWizardPage.this.onUseDefaultChanged();
            }
        });
        this.appRegister.addPropertyChangeListener(this.inputListener);
    }

    public void commit() {
        boolean isC = true;
        this.context.setClassicEclipseProject(isC);
        this.context.setCustomerLocation(this.projectLocationAdapter.getStringValue(true));
        this.context.prepare();
    }

    class InputChangeListener
    implements PropertyChangeListener {
        InputChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!ImportWebWarWizardPage.this.lock) {
                ImportWebWarWizardPage.this.appRegister.commit();
            }
            ImportWebWarWizardPage.this.setPageComplete(ImportWebWarWizardPage.this.validatePage());
            ImportWebWarWizardPage.this.getContainer().updateButtons();
        }
    }
}

