/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld.model;

import org.jboss.tools.common.model.XModelObject;

public class TLDUtil {
    static String FILE_ENTITIES = ".FileTLD_PRO.FileTLD_1_2.FileTLD_2_0.FileTLD_2_1.";
    static String TAG_ENTITIES = ".TLDTag.TLDTag12.TLDTag20.TLDTag21.";
    static String ATTR_ENTITIES = ".TLDAttribute.TLDAttribute12.TLDAttribute20.TLDAttribute2F.";
    static String FACELET_TAGLIB_ENTITIES = ".FileFaceletTaglib.FileFaceletTaglib20.";
    static String FACELET_TAG_ENTITIES = ".FaceletTaglibTag.FaceletTaglibTag20.";

    public static boolean isTaglib(XModelObject o) {
        return TLDUtil.isOfEntity(o, FILE_ENTITIES);
    }

    public static boolean isTag(XModelObject o) {
        return TLDUtil.isOfEntity(o, TAG_ENTITIES);
    }

    public static boolean isAttribute(XModelObject o) {
        return TLDUtil.isOfEntity(o, ATTR_ENTITIES);
    }

    private static boolean isOfEntity(XModelObject o, String entities) {
        return entities.indexOf("." + o.getModelEntity().getName() + ".") >= 0;
    }

    public static String getTagDescription(XModelObject o) {
        String attr = o.getModelEntity().getAttribute("info") != null ? "info" : "description";
        String s = o.getAttributeValue(attr);
        s = s == null ? "" : s.trim();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isFaceletTaglib(XModelObject o) {
        return TLDUtil.isOfEntity(o, FACELET_TAGLIB_ENTITIES);
    }

    public static boolean isFaceletTag(XModelObject o) {
        return TLDUtil.isOfEntity(o, FACELET_TAG_ENTITIES);
    }
}

