/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.livereload.ui.JBossLiveReloadUIActivator;
import org.jboss.tools.livereload.ui.internal.util.Logger;

public class ImageRepository {
    private static final String ICONS_FOLDER = "/icons/";
    private ImageRegistry imageRegistry;
    private URL baseUrl;
    private Plugin plugin = JBossLiveReloadUIActivator.getDefault();
    private String imageFolder = "/icons/";
    private static final ImageRepository instance = new ImageRepository();

    public static ImageRepository getInstance() {
        return instance;
    }

    private ImageRepository() {
        this.imageRegistry = JBossLiveReloadUIActivator.getDefault().getImageRegistry();
    }

    protected URL getBaseUrl() {
        try {
            if (this.baseUrl == null) {
                this.baseUrl = new URL(this.plugin.getBundle().getEntry("/"), this.imageFolder);
            }
            return this.baseUrl;
        }
        catch (MalformedURLException e) {
            Logger.error("Failed to retrieve folder for icons", e);
            return null;
        }
    }

    public Image getImage(String name) {
        Image image = this.imageRegistry.get(name);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = this.create(name);
        return imageDescriptor.createImage();
    }

    public ImageDescriptor create(String name) {
        return this.create(this.imageRegistry, name);
    }

    private ImageDescriptor create(ImageRegistry registry, String name) {
        return this.create(registry, name, this.getBaseUrl());
    }

    private ImageDescriptor create(ImageRegistry registry, String name, URL baseUrl) {
        if (baseUrl == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)this.createFileURL(name, baseUrl));
        registry.put(name, imageDescriptor);
        return imageDescriptor;
    }

    private URL createFileURL(String name, URL baseUrl) {
        try {
            return new URL(baseUrl, name);
        }
        catch (MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), NLS.bind((String)"Could not create URL for image {0}", (Object)name), (Throwable)e));
            return null;
        }
    }
}

