/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.core.internal;

import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;

public class AppClientDependencyConversionParticipant
extends AbstractProjectConversionParticipant {
    public boolean accept(IProject project) throws CoreException {
        return true;
    }

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (this.hasAppClientDependency(model.getDependencies())) {
            this.setAcrPlugin(model);
        }
    }

    private boolean hasAppClientDependency(List<Dependency> deps) {
        if (deps == null || deps.isEmpty()) {
            return false;
        }
        for (Dependency d : deps) {
            if (!"app-client".equals(d.getType())) continue;
            return true;
        }
        return false;
    }

    private void setAcrPlugin(Model model) throws CoreException {
        Build build = this.getCloneOrCreateBuild(model);
        Plugin acrPlugin = this.setupPlugin(build, "org.apache.maven.plugins", "maven-acr-plugin", "1.0");
        acrPlugin.setExtensions(true);
        model.setBuild(build);
    }

    protected Build getCloneOrCreateBuild(Model model) {
        Build build = model.getBuild() == null ? new Build() : model.getBuild().clone();
        return build;
    }

    protected Plugin setupPlugin(Build build, String pluginGroupId, String pluginArtifactId, String pluginVersion) {
        build.flushPluginMap();
        Plugin plugin = (Plugin)build.getPluginsAsMap().get(String.valueOf(pluginGroupId) + ":" + pluginArtifactId);
        if (plugin == null) {
            plugin = (Plugin)build.getPluginsAsMap().get(pluginArtifactId);
        }
        if (plugin == null) {
            plugin = new Plugin();
            plugin.setGroupId(pluginGroupId);
            plugin.setArtifactId(pluginArtifactId);
            plugin.setVersion(pluginVersion);
            build.addPlugin(plugin);
        }
        return plugin;
    }
}

