/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.dialog.xpl;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class ConversionUtils {
    public static File getFile(IClasspathEntry cpe) throws CoreException {
        Assert.isNotNull((Object)cpe, (String)"ClasspathEntry can not be null");
        IPath path = cpe.getPath();
        return ConversionUtils.getFile(path);
    }

    public static File getFile(IPath path) throws CoreException {
        Assert.isNotNull((Object)path, (String)"path can not be null");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = root.findMember(path);
        File localFile = null;
        if (file != null) {
            URI location;
            if (file.getType() != 1 || (location = file.getLocationURI()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.conversion.ui", -1, Messages.bind((String)Messages.file_notFound, (Object)path.toString()), null));
            }
            localFile = Util.toLocalFile((URI)location, null);
            if (localFile == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.conversion.ui", -1, Messages.bind((String)Messages.file_notFound, (Object)path.toString()), null));
            }
        } else {
            localFile = path.toFile();
        }
        return localFile;
    }

    public static IFile getIFile(IClasspathEntry cpe) throws CoreException {
        IWorkspaceRoot root;
        IResource file;
        Assert.isNotNull((Object)cpe, (String)"ClasspathEntry can not be null");
        IPath path = cpe.getPath();
        if (path != null && (file = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) != null && file instanceof IFile) {
            return (IFile)file;
        }
        return null;
    }
}

