/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.offline;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.project.examples.preferences.OfflineSupportPreferencePage;

public class MavenOfflinePropertyChangeListener
implements IPropertyChangeListener {
    public void propertyChange(PropertyChangeEvent event) {
        if ("projectExamplesOfflineEnabled".equals(event.getProperty())) {
            boolean updateM2E;
            final boolean isOffline = Boolean.parseBoolean(event.getNewValue().toString());
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            final IPreferenceStore m2e = M2EUIPluginActivator.getDefault().getPreferenceStore();
            boolean m2eOfflineStatus = m2e.getBoolean("eclipse.m2.offline");
            if (isOffline == m2eOfflineStatus) {
                return;
            }
            boolean bl = updateM2E = !OfflineSupportPreferencePage.VISIBLE;
            if (OfflineSupportPreferencePage.VISIBLE) {
                updateM2E = MessageDialog.openQuestion((Shell)shell, (String)"Change m2e offline status", (String)("Do you want to put m2e " + (isOffline ? "offline?" : "back online?")));
            }
            if (updateM2E) {
                Job updateMavenPrefsJob = new Job("Update Maven preferences"){

                    protected IStatus run(IProgressMonitor monitor) {
                        m2e.setValue("eclipse.m2.offline", isOffline);
                        return Status.OK_STATUS;
                    }
                };
                updateMavenPrefsJob.schedule(1000L);
            }
        }
    }
}

