/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.libprov;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderOperationPanel;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.m2e.model.edit.pom.Exclusion;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.libprov.MavenLibraryProviderInstallOperationConfig;
import org.jboss.tools.maven.ui.Messages;
import org.jboss.tools.maven.ui.internal.libprov.DependencyEditingSupport;
import org.jboss.tools.maven.ui.internal.libprov.ExclusionEditingSupport;
import org.jboss.tools.maven.ui.preferences.AutoResizeTableLayout;

public class MavenUserLibraryProviderInstallPanel
extends LibraryProviderOperationPanel {
    private TableViewer dependencyViewer;
    protected ColumnLayoutData[] dependencyTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(80, 80), new ColumnWeightData(80, 80), new ColumnWeightData(60, 60), new ColumnWeightData(60, 60), new ColumnWeightData(60, 60)};
    protected ColumnLayoutData[] exclusionTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(80, 80), new ColumnWeightData(60, 60)};
    private List<Dependency> dependencies;
    private TableViewer exclusionViewer;
    private List exclusions;
    private PomResourceImpl resource;

    public Control createControl(final Composite parent) {
        this.resource = MavenCoreActivator.getResource();
        if (this.resource != null) {
            this.resource.unload();
            MavenCoreActivator.setResource(null);
        }
        MavenLibraryProviderInstallOperationConfig config = (MavenLibraryProviderInstallOperationConfig)this.getOperationConfig();
        ILibraryProvider provider = config.getLibraryProvider();
        File providerFile = MavenCoreActivator.getProviderFile((ILibraryProvider)provider);
        URL url = null;
        try {
            if (providerFile.exists()) {
                url = providerFile.toURL();
            } else {
                Map params = provider.getParams();
                String pomURLString = (String)params.get("template");
                URL platformURL = new URL(pomURLString);
                url = FileLocator.resolve((URL)platformURL);
            }
            this.resource = MavenCoreActivator.loadResource((URL)url);
            MavenCoreActivator.setResource((PomResourceImpl)this.resource);
            Model model = this.resource.getModel();
            this.dependencies = model.getDependencies();
            config.setModel(model);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    parent.removeDisposeListener((DisposeListener)this);
                    MavenUserLibraryProviderInstallPanel.this.resource.unload();
                    MavenCoreActivator.setResource(null);
                }
            });
        }
        catch (CoreException e) {
            MavenCoreActivator.log((Throwable)e);
        }
        catch (IOException e) {
            MavenCoreActivator.log((Throwable)e);
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label dependencyLabel = new Label(composite, 0);
        dependencyLabel.setText(Messages.MavenUserLibraryProviderInstallPanel_Dependencies);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        dependencyLabel.setLayoutData((Object)gd);
        this.createDependencyViewer(composite);
        this.dependencyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof Dependency) {
                    Dependency dependency = (Dependency)object;
                    MavenUserLibraryProviderInstallPanel.this.exclusions = (List)dependency.getExclusions();
                    MavenUserLibraryProviderInstallPanel.this.exclusionViewer.setInput((Object)MavenUserLibraryProviderInstallPanel.this.exclusions);
                }
            }
        });
        Label exclusionLabel = new Label(composite, 0);
        exclusionLabel.setText(Messages.MavenUserLibraryProviderInstallPanel_Exclusions);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        exclusionLabel.setLayoutData((Object)gd);
        this.createExclusionViewer(composite);
        if (this.dependencies.size() > 0) {
            this.dependencyViewer.getTable().select(0);
            this.exclusions = this.dependencies.get(0).getExclusions();
            this.exclusionViewer.setInput((Object)this.exclusions);
        }
        return composite;
    }

    private void createExclusionViewer(Composite parent) {
        this.exclusionViewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 60;
        this.exclusionViewer.getTable().setLayoutData((Object)gd);
        this.exclusionViewer.setContentProvider((IContentProvider)new TableContentProvider());
        Table table = this.exclusionViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        String[] columnHeaders = new String[]{Messages.MavenUserLibraryProviderInstallPanel_GroupId, Messages.MavenUserLibraryProviderInstallPanel_ArtifactId};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(this.exclusionViewer, 0);
            column.setLabelProvider((CellLabelProvider)new ExclusionColumnLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.setEditingSupport((EditingSupport)new ExclusionEditingSupport((ColumnViewer)this.exclusionViewer, i));
            ++i;
        }
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < this.exclusionTableColumnLayouts.length) {
            layout.addColumnData(this.exclusionTableColumnLayouts[i2]);
            ++i2;
        }
        this.exclusionViewer.getTable().setLayout((Layout)layout);
        this.createExclusionButtons(parent);
    }

    private void createDependencyViewer(Composite parent) {
        this.dependencyViewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 80;
        this.dependencyViewer.getTable().setLayoutData((Object)gd);
        this.dependencyViewer.setContentProvider((IContentProvider)new TableContentProvider());
        Table table = this.dependencyViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        String[] columnHeaders = new String[]{Messages.MavenUserLibraryProviderInstallPanel_GroupId, Messages.MavenUserLibraryProviderInstallPanel_ArtifactId, Messages.MavenUserLibraryProviderInstallPanel_Version, Messages.MavenUserLibraryProviderInstallPanel_Scope, Messages.MavenUserLibraryProviderInstallPanel_Type};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(this.dependencyViewer, 0);
            column.setLabelProvider((CellLabelProvider)new DependencyColumnLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.setEditingSupport((EditingSupport)new DependencyEditingSupport((ColumnViewer)this.dependencyViewer, i));
            ++i;
        }
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < this.dependencyTableColumnLayouts.length) {
            layout.addColumnData(this.dependencyTableColumnLayouts[i2]);
            ++i2;
        }
        this.dependencyViewer.getTable().setLayout((Layout)layout);
        this.dependencyViewer.setInput(this.dependencies);
        this.createDependencyButtons(parent);
    }

    private void createDependencyButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(Messages.MavenUserLibraryProviderInstallPanel_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Dependency dependency = PomFactory.eINSTANCE.createDependency();
                dependency.setGroupId("?");
                dependency.setArtifactId("?");
                MavenUserLibraryProviderInstallPanel.this.dependencies.add(dependency);
                MavenUserLibraryProviderInstallPanel.this.dependencyViewer.refresh();
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(Messages.MavenUserLibraryProviderInstallPanel_Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = MavenUserLibraryProviderInstallPanel.this.dependencyViewer.getSelection();
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof Dependency) {
                    Dependency dependency = (Dependency)object;
                    boolean ok = MessageDialog.openQuestion((Shell)MavenUserLibraryProviderInstallPanel.this.getShell(), (String)Messages.MavenUserLibraryProviderInstallPanel_Remove_dependency, (String)NLS.bind((String)Messages.MavenUserLibraryProviderInstallPanel_Are_you_sure_you_want_to_remove_the_artifact, (Object)dependency.getGroupId(), (Object)dependency.getArtifactId()));
                    if (ok) {
                        MavenUserLibraryProviderInstallPanel.this.dependencies.remove(object);
                        MavenUserLibraryProviderInstallPanel.this.dependencyViewer.refresh();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button restoreDefaults = new Button(buttonComposite, 8);
        restoreDefaults.setLayoutData((Object)new GridData(768));
        restoreDefaults.setText(Messages.MavenUserLibraryProviderInstallPanel_Restore_Defaults);
        restoreDefaults.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MavenUserLibraryProviderInstallPanel.this.resource.unload();
                MavenLibraryProviderInstallOperationConfig config = (MavenLibraryProviderInstallOperationConfig)MavenUserLibraryProviderInstallPanel.this.getOperationConfig();
                ILibraryProvider provider = config.getLibraryProvider();
                Map params = provider.getParams();
                String pomURLString = (String)params.get("template");
                try {
                    URL platformURL = new URL(pomURLString);
                    URL url = FileLocator.resolve((URL)platformURL);
                    MavenUserLibraryProviderInstallPanel.this.resource = MavenCoreActivator.loadResource((URL)url);
                    Model model = MavenUserLibraryProviderInstallPanel.this.resource.getModel();
                    MavenUserLibraryProviderInstallPanel.this.dependencies = (List)model.getDependencies();
                    MavenUserLibraryProviderInstallPanel.this.dependencyViewer.setInput((Object)MavenUserLibraryProviderInstallPanel.this.dependencies);
                    config.setModel(model);
                    MavenUserLibraryProviderInstallPanel.this.dependencyViewer.refresh();
                    if (MavenUserLibraryProviderInstallPanel.this.dependencies.size() > 0) {
                        MavenUserLibraryProviderInstallPanel.this.dependencyViewer.getTable().select(0);
                        MavenUserLibraryProviderInstallPanel.this.exclusions = (List)((Dependency)MavenUserLibraryProviderInstallPanel.this.dependencies.get(0)).getExclusions();
                    } else {
                        MavenUserLibraryProviderInstallPanel.this.exclusions = null;
                    }
                    MavenUserLibraryProviderInstallPanel.this.exclusionViewer.setInput((Object)MavenUserLibraryProviderInstallPanel.this.exclusions);
                    MavenUserLibraryProviderInstallPanel.this.exclusionViewer.refresh();
                }
                catch (MalformedURLException e1) {
                    MavenCoreActivator.log((Throwable)e1);
                }
                catch (IOException e1) {
                    MavenCoreActivator.log((Throwable)e1);
                }
                catch (CoreException e1) {
                    MavenCoreActivator.log((Throwable)e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dependencyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = MavenUserLibraryProviderInstallPanel.this.dependencyViewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object object = selection.getFirstElement();
                    removeButton.setEnabled(object instanceof Dependency);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
    }

    protected Shell getShell() {
        return null;
    }

    private void createExclusionButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(Messages.MavenUserLibraryProviderInstallPanel_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object object;
                ISelection sel;
                Exclusion exclusion = PomFactory.eINSTANCE.createExclusion();
                exclusion.setGroupId("?");
                exclusion.setArtifactId("?");
                if (MavenUserLibraryProviderInstallPanel.this.exclusions == null && (sel = MavenUserLibraryProviderInstallPanel.this.dependencyViewer.getSelection()) instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof Dependency) {
                    MavenUserLibraryProviderInstallPanel.this.exclusions = (List)((Dependency)object).getExclusions();
                    MavenUserLibraryProviderInstallPanel.this.exclusionViewer.setInput((Object)MavenUserLibraryProviderInstallPanel.this.exclusions);
                }
                if (MavenUserLibraryProviderInstallPanel.this.exclusions != null) {
                    MavenUserLibraryProviderInstallPanel.this.exclusions.add(exclusion);
                }
                MavenUserLibraryProviderInstallPanel.this.exclusionViewer.refresh();
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(Messages.MavenUserLibraryProviderInstallPanel_Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = MavenUserLibraryProviderInstallPanel.this.exclusionViewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object object = selection.getFirstElement();
                    if (object instanceof Exclusion) {
                        Exclusion exclusion = (Exclusion)object;
                        boolean ok = MessageDialog.openQuestion((Shell)MavenUserLibraryProviderInstallPanel.this.getShell(), (String)Messages.MavenUserLibraryProviderInstallPanel_Remove_exclusion, (String)NLS.bind((String)Messages.MavenUserLibraryProviderInstallPanel_Are_you_sure_you_want_to_remove_the_artifact, (Object)exclusion.getGroupId(), (Object)exclusion.getArtifactId()));
                        if (ok && MavenUserLibraryProviderInstallPanel.this.exclusions != null) {
                            MavenUserLibraryProviderInstallPanel.this.exclusions.remove(object);
                        }
                    }
                    MavenUserLibraryProviderInstallPanel.this.exclusionViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.exclusionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = MavenUserLibraryProviderInstallPanel.this.exclusionViewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object object = selection.getFirstElement();
                    removeButton.setEnabled(object instanceof Exclusion);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
    }

    private static class DependencyColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public DependencyColumnLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof Dependency) {
                Dependency dependency = (Dependency)element;
                switch (this.columnIndex) {
                    case 0: {
                        return dependency.getGroupId();
                    }
                    case 1: {
                        return dependency.getArtifactId();
                    }
                    case 2: {
                        return dependency.getVersion();
                    }
                    case 3: {
                        return dependency.getScope();
                    }
                    case 4: {
                        return dependency.getType();
                    }
                }
            }
            return null;
        }
    }

    private static class ExclusionColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public ExclusionColumnLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof Exclusion) {
                Exclusion exclusion = (Exclusion)element;
                switch (this.columnIndex) {
                    case 0: {
                        return exclusion.getGroupId();
                    }
                    case 1: {
                        return exclusion.getArtifactId();
                    }
                }
            }
            return null;
        }
    }

    private static class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

