/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;

public class MinishiftBinaryUtility {
    private static final String MINISHIFT_LOCATION_LINUX = "/usr/bin/minishift";
    private static final String MINISHIFT_LOCATION_WINDOWS = "C:\\minishift.exe";
    private static CommandLocationBinary binary;

    public static String getMinishiftLocation() {
        return MinishiftBinaryUtility.findMinishiftLocation();
    }

    public static String getMinishiftLocation(IServer server) {
        if (server != null) {
            String minishiftFile = server.getAttribute("minishift.file.location", null);
            if (minishiftFile != null) {
                return minishiftFile;
            }
            try {
                ILaunchConfiguration lc = server.getLaunchConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
                return MinishiftBinaryUtility.getMinishiftLocation(lc);
            }
            catch (CoreException coreException) {}
        }
        return MinishiftBinaryUtility.findMinishiftLocation();
    }

    public static String getMinishiftLocation(ILaunchConfiguration lc) throws CoreException {
        String ret;
        if (lc != null && (ret = lc.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null)) != null && new File(ret).exists()) {
            return ret;
        }
        return MinishiftBinaryUtility.findMinishiftLocation();
    }

    private static String findMinishiftLocation() {
        if (binary == null) {
            binary = new CommandLocationBinary("minishift");
            binary.addPlatformLocation("linux", MINISHIFT_LOCATION_LINUX);
            binary.addPlatformLocation("win32", MINISHIFT_LOCATION_WINDOWS);
            binary.setDefaultPlatform("linux");
        }
        return binary.findLocation();
    }
}

