/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;

public abstract class AbstractCDKPoller
implements IServerStatePoller2 {
    protected IServer server;
    protected boolean canceled;
    protected boolean done;
    protected boolean state;
    protected boolean expectedState;
    protected IServerStatePoller.PollingException aborted = null;

    public IServer getServer() {
        return this.server;
    }

    public void beginPolling(IServer server, boolean expectedState) throws IServerStatePoller.PollingException {
        this.server = server;
        this.done = false;
        this.canceled = false;
        this.expectedState = expectedState;
        this.state = !expectedState;
        this.launchThread();
    }

    protected abstract void launchThread();

    protected void launchThread(String name) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractCDKPoller.this.pollerRun();
            }
        }, "CDK Poller");
        t.start();
    }

    protected void pollerRun() {
        this.setStateInternal(false, this.state);
        Map<String, String> env = this.createEnvironment(this.server);
        while (this.aborted == null && !this.canceled && !this.done) {
            boolean completeDown;
            IStatus stat = this.onePingSafe(this.server, env);
            int status = stat.getSeverity();
            boolean completeUp = status == 0 && this.expectedState;
            boolean bl = completeDown = status == 4 && !this.expectedState;
            if (completeUp || completeDown) {
                this.setStateInternal(true, this.expectedState);
            }
            try {
                Thread.sleep(700L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract Map<String, String> createEnvironment(IServer var1);

    protected synchronized void setStateInternal(boolean done, boolean state) {
        this.done = done;
        this.state = state;
    }

    public IStatus getCurrentStateSynchronous(IServer server) {
        Map<String, String> env = this.createEnvironment(server);
        int severity = this.onePingSafe(server, env).getSeverity();
        if (severity == 0) {
            return new Status(0, "org.jboss.tools.openshift.cdk.server.core", "CDK Instance is Up");
        }
        if (severity == 4) {
            return new Status(4, "org.jboss.tools.openshift.cdk.server.core", "CDK Instance is shutoff");
        }
        return new Status(1, "org.jboss.tools.openshift.cdk.server.core", "CDK Instance is indeterminate");
    }

    protected IStatus onePingSafe(IServer server, Map<String, String> env) {
        try {
            IStatus ret = this.onePing(server, env);
            return ret;
        }
        catch (IServerStatePoller.PollingException pe) {
            this.aborted = pe;
        }
        catch (TimeoutException te) {
            this.aborted = new IServerStatePoller.PollingException(te.getMessage(), (Throwable)te);
        }
        catch (IOException ioe) {
            CDKCoreActivator.pluginLog().logError(ioe.getMessage(), (Throwable)ioe);
        }
        CDKCoreActivator.statusFactory();
        return StatusFactory.infoStatus((String)"org.jboss.tools.openshift.cdk.server.core", (String)"Response status indicates the CDK is starting.");
    }

    protected abstract IStatus onePing(IServer var1, Map<String, String> var2) throws IServerStatePoller.PollingException, IOException, TimeoutException;

    public synchronized boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.done;
    }

    public synchronized boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.state;
    }

    public void cleanup() {
    }

    public synchronized void cancel(int type) {
        this.canceled = true;
    }

    public IServerStatePoller.PollingException getPollingException() {
        return this.aborted;
    }

    public void provideCredentials(Properties credentials) {
    }

    public IServerStatePollerType getPollerType() {
        return null;
    }

    public void setPollerType(IServerStatePollerType type) {
    }

    public List<String> getRequiredProperties() {
        return null;
    }
}

