/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class CDK3Server
extends CDKServer {
    public static final String VIRTUALBOX = "virtualbox";
    public static final String VMWAREFUSION = "vmwarefusion";
    public static final String KVM = "kvm";
    public static final String XHYVE = "xhyve";
    public static final String HYPERV = "hyperv";
    public static final String PROP_HYPERVISOR = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor";
    public static final String MINISHIFT_FILE = "minishift.file.location";
    public static final String MINISHIFT_HOME = "minishift.home.location";

    public static final String[] getHypervisors() {
        return CDK3Server.getHypervisors(Platform.getOS());
    }

    public static final String[] getHypervisors(String platform) {
        if ("win32".equals(platform)) {
            return new String[]{HYPERV, VIRTUALBOX};
        }
        if ("linux".equals(platform)) {
            return new String[]{KVM, VIRTUALBOX};
        }
        if ("macosx".equals(platform)) {
            return new String[]{XHYVE, VIRTUALBOX, VMWAREFUSION};
        }
        return new String[]{VIRTUALBOX, VMWAREFUSION, KVM, XHYVE, HYPERV};
    }

    @Override
    protected String getBaseName() {
        return CDK3Server.getServerTypeBaseName();
    }

    public static String getServerTypeBaseName() {
        return "Container Development Environment 3";
    }

    @Override
    public String getUserEnvironmentKey() {
        return this.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "MINISHIFT_USERNAME");
    }

    @Override
    public String getPasswordEnvironmentKey() {
        return this.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "MINISHIFT_PASSWORD");
    }

    public String getMinishiftHome() {
        String home = System.getProperty("user.home");
        String defaultMinishiftHome = new File(home, ".minishift").getAbsolutePath();
        String msHome = this.getServer().getAttribute(MINISHIFT_HOME, defaultMinishiftHome);
        if (StringUtils.isEmpty((String)msHome)) {
            msHome = defaultMinishiftHome;
        }
        return msHome;
    }

    public static boolean matchesCDK3(String version) {
        return version.startsWith("3.0.") || version.startsWith("3.1.");
    }
}

