/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.VagrantBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.OpenShiftNotReadyPollingException;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.IExternalLaunchConstants;

public abstract class AbstractCDKLaunchController
extends AbstractSubsystemController
implements ILaunchServerController,
IExternalLaunchConstants {
    public static final String FLAG_INITIALIZED = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.launch.isInitialized";
    protected static final boolean MULTIPLE_START_FAIL = false;
    protected static final boolean MULTIPLE_START_SUCCESS = true;

    public IStatus canStart(String launchMode) {
        return Status.OK_STATUS;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        if (!this.isInitialized(workingCopy)) {
            this.initialize(workingCopy);
        }
        this.performOverrides(workingCopy);
    }

    protected boolean isInitialized(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        return wc.hasAttribute(FLAG_INITIALIZED) && wc.getAttribute(FLAG_INITIALIZED, Boolean.valueOf(false).booleanValue());
    }

    protected abstract void performOverrides(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    protected abstract void initialize(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    @Deprecated
    protected IProcess addProcessToLaunch(Process p, ILaunch launch, IServer s) {
        return this.addProcessToLaunch(p, launch, s, true);
    }

    protected IProcess addProcessToLaunch(Process p, ILaunch launch, IServer s, boolean terminal) {
        String cmdLoc = VagrantBinaryUtility.getVagrantLocation(s);
        return this.addProcessToLaunch(p, launch, s, terminal, cmdLoc);
    }

    protected IProcess addProcessToLaunch(Process p, ILaunch launch, IServer s, boolean terminal, String cmdLoc) {
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String progName = new Path(cmdLoc).lastSegment();
        if (terminal) {
            launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        }
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, progName);
        IProcess process = this.createProcess(terminal, launch, p, cmdLoc, processAttributes);
        launch.addProcess(process);
        if (terminal) {
            this.linkTerminal(p);
        }
        return process;
    }

    protected IProcess createProcess(boolean terminal, ILaunch launch, Process p, String cmd, Map<String, String> attr) {
        RuntimeProcess process = null;
        process = terminal ? new RuntimeProcess(launch, p, cmd, attr){

            protected IStreamsProxy createStreamsProxy() {
                return null;
            }
        } : new RuntimeProcess(launch, p, cmd, attr);
        return process;
    }

    protected void linkTerminal(Process p) {
        InputStream in = p.getInputStream();
        InputStream err = p.getErrorStream();
        OutputStream out = p.getOutputStream();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("delegateId", "org.eclipse.tm.terminal.connector.streams.launcher.streams");
        properties.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.streams.StreamsConnector");
        properties.put("title", this.getServer().getName());
        properties.put("localEcho", false);
        properties.put("terminal.forceNew", true);
        properties.put("streams.stdin", out);
        properties.put("streams.stdout", in);
        properties.put("streams.stderr", err);
        ITerminalService service = TerminalServiceFactory.getService();
        service.openConsole(properties, null);
    }

    protected LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    protected IDebugEventSetListener getDebugListener(final IProcess[] processes, final ILaunch launch) {
        return new DebugEventListener(this){

            public void handleDebugEvents(DebugEvent[] events) {
                this.handleDebugEvents(events, launch, processes);
            }
        };
    }

    protected IDebugEventSetListener getDebugListener(final ILaunch launch) {
        return new DebugEventListener(this){

            public void handleDebugEvents(DebugEvent[] events) {
                this.handleDebugEvents(events, launch, launch.getProcesses());
            }
        };
    }

    private void processTerminated(IServer server, final IProcess p, IDebugEventSetListener listener) {
        final ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        new Thread(){

            @Override
            public void run() {
                AbstractCDKLaunchController.this.handleProcessTerminated(p, beh);
            }
        }.start();
        if (listener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(listener);
        }
    }

    protected boolean getMultipleStartBehavior() {
        return true;
    }

    protected void handleProcessTerminated(IProcess p, ControllableServerBehavior beh) {
        this.processTerminatedDelay();
        AbstractCDKPoller vp = this.getCDKPoller(this.getServer());
        IStatus stat = vp.getCurrentStateSynchronous(this.getServer());
        if (stat.isOK()) {
            beh.setServerStarted();
            beh.setRunMode("run");
        } else if (vp.getPollingException() instanceof OpenShiftNotReadyPollingException) {
            this.handleOpenShiftUnavailable((IControllableServerBehavior)beh, (OpenShiftNotReadyPollingException)vp.getPollingException());
        } else {
            beh.setServerStopped();
        }
    }

    protected boolean handleStartCommandExitCodeFailure(IProcess p, ControllableServerBehavior beh) {
        try {
            int exit = p.getExitValue();
            if (exit != 0) {
                this.handleStartupCommandFailed(beh);
                return true;
            }
        }
        catch (DebugException e) {
            CDKCoreActivator.pluginLog().logError((Throwable)e);
            try {
                p.terminate();
            }
            catch (DebugException de) {
                CDKCoreActivator.pluginLog().logError((Throwable)de);
            }
            this.handleStartupCommandFailed(beh);
            return true;
        }
        return false;
    }

    protected abstract AbstractCDKPoller getCDKPoller(IServer var1);

    protected void processTerminatedDelay() {
    }

    protected void handleStartupCommandFailed(ControllableServerBehavior beh) {
        IStatus s = CDKCoreActivator.statusFactory().errorStatus("The command to launch the CDK has failed. Please inspect the terminal for more information.");
        CDKCoreActivator.pluginLog().logStatus(s);
        beh.setServerStopped();
    }

    private void handleOpenShiftUnavailable(IControllableServerBehavior beh, final OpenShiftNotReadyPollingException osnrpe) {
        ((ControllableServerBehavior)beh).setServerStarted();
        ((Server)beh.getServer()).setMode("run");
        new Job(osnrpe.getMessage()){

            protected IStatus run(IProgressMonitor monitor) {
                return CDKCoreActivator.statusFactory().errorStatus("Error contacting OpenShift", (Throwable)((Object)osnrpe));
            }
        }.schedule();
    }

    protected String getStartupLaunchName(IServer s) {
        return "Start " + s.getName();
    }

    protected abstract class DebugEventListener
    implements IDebugEventSetListener {
        protected DebugEventListener() {
        }

        public void handleDebugEvents(DebugEvent[] events, ILaunch launch, IProcess[] processes) {
            if (events != null) {
                int size = events.length;
                int i = 0;
                while (i < size) {
                    if (processes != null && processes.length > 0 && processes[0] != null && processes[0].equals(events[i].getSource()) && events[i].getKind() == 8) {
                        AbstractCDKLaunchController.this.getLaunchManager().fireUpdate(new ILaunch[]{launch}, 3);
                        AbstractCDKLaunchController.this.processTerminated(AbstractCDKLaunchController.this.getServer(), processes[0], this);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    ++i;
                }
            }
        }
    }
}

