/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.IExternalLaunchConstants;
import org.jboss.tools.openshift.internal.common.core.util.ThreadUtils;

public abstract class AbstractCDKShutdownController
extends AbstractSubsystemController
implements IServerShutdownController,
IExternalLaunchConstants {
    protected abstract AbstractCDKPoller getCDKPoller(IServer var1);

    protected abstract String getShutdownArgs();

    protected abstract Process call(IServer var1, String var2, String var3) throws CoreException, IOException;

    public IStatus canStop() {
        return Status.OK_STATUS;
    }

    public ControllableServerBehavior getBehavior() {
        return (ControllableServerBehavior)this.getServer().loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
    }

    private void cancelPoller() {
        Object pt = this.getBehavior().getSharedData("DeployableServerBehavior.PollThread");
        if (pt instanceof PollThread) {
            ((PollThread)pt).cancel();
        }
    }

    protected boolean getRequiresForce() {
        Object o = this.getControllableBehavior().getSharedData("DeployableServerBehavior.RequiresForceStop");
        return o == null ? false : (Boolean)o;
    }

    protected void setNextStopRequiresForce(boolean val) {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)val);
    }

    protected void pollState() {
        IStatus state = PollThreadUtils.isServerStarted((IServer)this.getServer(), (IServerStatePoller)this.getCDKPoller(this.getServer()));
        boolean started = state.isOK();
        if (!started && state.getSeverity() == 4) {
            this.cancelPoller();
            this.getBehavior().setServerStopped();
            return;
        }
    }

    public void stop(boolean force) {
        this.getBehavior().setServerStopping();
        this.pollState();
        if (this.getServer().getServerState() == 4) {
            return;
        }
        this.issueShutdownCommand();
    }

    protected void issueShutdownCommand() {
        try {
            if (this.useTerminal()) {
                this.shutdownViaTerminal();
            } else {
                this.shutdownViaLaunch();
            }
        }
        catch (CoreException ce) {
            CDKCoreActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Error shutting down server", (Throwable)ce));
            this.getBehavior().setServerStarted();
        }
    }

    protected abstract boolean useTerminal();

    protected abstract String getCommandLocation();

    private void shutdownViaTerminal() throws CoreException {
        String args = this.getShutdownArgs();
        Process p = null;
        try {
            p = this.call(this.getServer(), args, this.getServer().getName());
        }
        catch (IOException ioe) {
            CDKCoreActivator.pluginLog().logError((Throwable)ioe);
            this.getBehavior().setServerStarted();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", ioe.getMessage(), (Throwable)ioe));
        }
        if (p == null) {
            this.getBehavior().setServerStopped();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Call to shutdown command has failed."));
        }
        this.linkTerminal(p);
        final Process p2 = p;
        Integer exitCode = (Integer)ThreadUtils.runWithTimeout((long)600000L, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return p2.waitFor();
            }
        });
        if (exitCode == null) {
            p.destroyForcibly();
        }
        this.processTerminated(this.getServer(), null);
    }

    private void shutdownViaLaunch() throws CoreException {
        String args = this.getShutdownArgs();
        String cmd = this.getCommandLocation();
        ILaunchConfiguration lc = this.getServer().getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
        ILaunchConfigurationWorkingCopy lc2 = new CDKLaunchUtility().createExternalToolsLaunch(this.getServer(), args, new Path(cmd).lastSegment(), lc, cmd);
        IProcess p = null;
        ILaunch launch = null;
        try {
            launch = lc2.launch("run", (IProgressMonitor)new NullProgressMonitor());
            IProcess[] all = launch.getProcesses();
            if (all.length > 0) {
                p = all[0];
            }
        }
        catch (CoreException ce) {
            CDKCoreActivator.pluginLog().logError((Throwable)ce);
            this.getBehavior().setServerStarted();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", ce.getMessage(), (Throwable)ce));
        }
        if (p == null) {
            this.getBehavior().setServerStopped();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Call to shutdown command has failed."));
        }
        final IProcess myProcess = p;
        IDebugEventSetListener listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (myProcess != null && myProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            AbstractCDKShutdownController.this.processTerminated(AbstractCDKShutdownController.this.getServer(), null);
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(listener);
    }

    private void linkTerminal(Process p) {
        InputStream in = p.getInputStream();
        InputStream err = p.getErrorStream();
        OutputStream out = p.getOutputStream();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("delegateId", "org.eclipse.tm.terminal.connector.streams.launcher.streams");
        properties.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.streams.StreamsConnector");
        properties.put("title", this.getServer().getName());
        properties.put("localEcho", false);
        properties.put("terminal.forceNew", true);
        properties.put("streams.stdin", out);
        properties.put("streams.stdout", in);
        properties.put("streams.stderr", err);
        ITerminalService service = TerminalServiceFactory.getService();
        service.openConsole(properties, null);
    }

    private void processTerminated(final IServer server, IDebugEventSetListener listener) {
        final ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                IStatus stat = AbstractCDKShutdownController.this.getCDKPoller(server).getCurrentStateSynchronous(AbstractCDKShutdownController.this.getServer());
                if (stat.getSeverity() == 4) {
                    beh.setServerStopped();
                    beh.setRunMode("run");
                    beh.putSharedData("CDKServerBehaviour.CACHED_PASSWORD", null);
                    beh.putSharedData("CDKServerBehaviour.CACHED_USER", null);
                } else {
                    beh.setServerStarted();
                    AbstractCDKShutdownController.this.setNextStopRequiresForce(true);
                }
            }
        }.start();
        if (listener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(listener);
        }
    }
}

