/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.detection;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CommandTimeoutException;

public class MinishiftVersionLoader {
    public static String ERROR_KEY = "properties.load.error";
    public static String VERSION_KEY = "Minishift version";
    public static String VERSION_KEY2 = "minishift";
    public static String CDK_VERSION_KEY = "CDK";
    public static String CDK_VERSION_KEY_OLD = "CDK Version";

    public static MinishiftVersions getVersionProperties(String homeDir) {
        Properties ret = new Properties();
        try {
            String[] lines = CDKLaunchUtility.call(homeDir, new String[]{"version"}, new File(homeDir).getParentFile(), new HashMap<String, String>(), 5000, false);
            int i = 0;
            while (i < lines.length) {
                if (!lines[i].trim().isEmpty()) {
                    String[] split;
                    if (lines[i].contains(":")) {
                        split = lines[i].split(":");
                        if (split.length == 2) {
                            ret.put(split[0], split[1]);
                        }
                    } else if (lines[i].contains(" ") && (split = lines[i].split(" ")).length == 2) {
                        ret.put(split[0], split[1]);
                    }
                }
                ++i;
            }
        }
        catch (IOException | CommandTimeoutException e) {
            ret.put(ERROR_KEY, e.getMessage());
        }
        return new MinishiftVersions(ret);
    }

    public static class MinishiftVersions {
        private Properties p;

        public MinishiftVersions(Properties p) {
            this.p = p;
        }

        public String getError() {
            return this.p.getProperty(ERROR_KEY);
        }

        @Deprecated
        public String getVersion() {
            return this.getMinishiftVersion();
        }

        public String getMinishiftVersion() {
            String v = this.p.getProperty(VERSION_KEY);
            if (v == null) {
                v = this.p.getProperty(VERSION_KEY2);
            }
            return this.cleanVersion(v);
        }

        private String cleanVersion(String v) {
            if (v == null) {
                return null;
            }
            if (v.trim().startsWith("v")) {
                return v.trim().substring(1);
            }
            return v.trim();
        }

        public String getCDKVersion() {
            String v = this.p.getProperty(CDK_VERSION_KEY);
            if (v == null) {
                v = this.p.getProperty(CDK_VERSION_KEY_OLD);
            }
            return this.cleanVersion(v);
        }

        public boolean isValid() {
            return this.getMinishiftVersion() != null;
        }
    }
}

