/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;

public class CDKDockerUtility {
    private DockerConnectionManager mgr;

    public CDKDockerUtility(DockerConnectionManager mgr) {
        this.mgr = mgr;
    }

    public CDKDockerUtility() {
        this(DockerConnectionManager.getInstance());
    }

    public String getName(IServer server) {
        return server.getName();
    }

    public IDockerConnection findDockerConnection(String name) {
        IDockerConnection[] cons = this.mgr.getConnections();
        int i = 0;
        while (i < cons.length) {
            if (cons[i] != null && cons[i].getName() != null && cons[i].getName().equals(name)) {
                return cons[i];
            }
            ++i;
        }
        return null;
    }

    public boolean dockerConnectionExists(String name) {
        return this.findDockerConnection(name) != null;
    }

    public IDockerConnection buildDockerConnection(String name, ServiceManagerEnvironment adb) throws DockerException {
        return new DockerConnection.Builder().name(name).tcpConnection(this.getSettings(adb));
    }

    private TCPConnectionSettings getSettings(ServiceManagerEnvironment adb) throws DockerException {
        String dockerHost = this.getDockerHost(adb);
        String tlsCertPath = this.getTlsCertPath(adb);
        TCPConnectionSettings set = new TCPConnectionSettings(dockerHost, tlsCertPath);
        return set;
    }

    private String getDockerHost(ServiceManagerEnvironment env) {
        return env.getDockerHost();
    }

    private String getTlsCertPath(ServiceManagerEnvironment env) {
        boolean tlsVerify;
        String tlsVerifyString = env.getDockerTLSVerify();
        boolean bl = tlsVerifyString == null ? false : (tlsVerify = Integer.parseInt(tlsVerifyString) != 0);
        if (tlsVerify) {
            String tlsCertPath = env.getDockerCertPath();
            if (tlsCertPath != null && (tlsCertPath = tlsCertPath.trim()).startsWith("'") && tlsCertPath.endsWith("'") && tlsCertPath.length() > 1) {
                tlsCertPath = tlsCertPath.substring(1, tlsCertPath.length() - 1);
            }
            return tlsCertPath;
        }
        return null;
    }

    public void updateConnection(IDockerConnection dc, String name, ServiceManagerEnvironment adb) throws DockerException {
        this.mgr.updateConnection(dc, name, (IDockerConnectionSettings)this.getSettings(adb));
    }

    public IDockerConnection createDockerConnection(IServer server, ServiceManagerEnvironment adb) throws DockerException {
        IDockerConnection con = this.buildDockerConnection(server.getName(), adb);
        this.mgr.addConnection(con);
        return con;
    }
}

