/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKDockerUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKOpenshiftUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironmentLoader;
import org.jboss.tools.openshift.common.core.connection.IConnection;

public class ConfigureDependentFrameworksListener
extends UnitedServerListener {
    private boolean enabled = true;

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void serverChanged(ServerEvent event) {
        if (this.enabled && this.canHandleServer(event.getServer())) {
            if (ConfigureDependentFrameworksListener.serverSwitchesToState((ServerEvent)event, (int)2)) {
                this.scheduleConfigureFrameworksJob(event);
            } else if (ConfigureDependentFrameworksListener.serverSwitchesToState((ServerEvent)event, (int)4)) {
                IServer s = event.getServer();
                ServiceManagerEnvironmentLoader.type(s).clearServiceManagerEnvironment(event.getServer());
            }
        }
    }

    private void scheduleConfigureFrameworksJob(final ServerEvent event) {
        new Job("Inspecting CDK environment..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (ConfigureDependentFrameworksListener.this.canHandleServer(event.getServer())) {
                        ConfigureDependentFrameworksListener.this.configureFrameworks(event.getServer());
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
            }
        }.schedule(1000L);
    }

    protected void configureFrameworks(IServer server) throws CoreException {
        ServiceManagerEnvironment adb = ServiceManagerEnvironmentLoader.type(server).getOrLoadServiceManagerEnvironment(server, true);
        if (adb == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Unable to configure docker and openshift. Calls to vagrant service-manager are returning empty environments."));
        }
        this.configureOpenshift(server, adb);
        this.configureDocker(server, adb);
    }

    public boolean canHandleServer(IServer server) {
        if (server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type")) {
            return true;
        }
        if (server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type.v3")) {
            return true;
        }
        return server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type.v32");
    }

    private void configureDocker(IServer server, ServiceManagerEnvironment adb) {
        try {
            CDKDockerUtility util = new CDKDockerUtility();
            IDockerConnection dc = util.findDockerConnection(server.getName());
            if (dc != null) {
                util.updateConnection(dc, server.getName(), adb);
            } else {
                util.createDockerConnection(server, adb);
            }
        }
        catch (DockerException de) {
            CDKCoreActivator.pluginLog().logError("Error while creating docker connection for server " + server.getName(), (Throwable)de);
        }
    }

    private void configureOpenshift(IServer server, ServiceManagerEnvironment adb) {
        CDKOpenshiftUtility util = new CDKOpenshiftUtility();
        IConnection con = util.findExistingOpenshiftConnection(server, adb);
        if (con == null) {
            con = util.createOpenshiftConnection(adb);
        } else {
            util.updateOpenshiftConnection(adb, con);
        }
        if (con != null) {
            con.connect();
        }
    }
}

