/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Server;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKLaunchEnvironmentUtil;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKServerUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironmentLoader;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class MinishiftServiceManagerEnvironmentLoader
extends ServiceManagerEnvironmentLoader {
    public MinishiftServiceManagerEnvironmentLoader() {
        super(2);
    }

    @Override
    public ServiceManagerEnvironment loadServiceManagerEnvironment(IServer server, boolean suppressErrors) {
        String minishiftLoc = MinishiftBinaryUtility.getMinishiftLocation(server);
        if (minishiftLoc == null || minishiftLoc.isEmpty() || !new File(minishiftLoc).exists()) {
            if (!suppressErrors) {
                String msg = "Server " + server.getName() + " does not have a minishift location defined.";
                CDKCoreActivator.pluginLog().logError(msg);
            }
            return null;
        }
        Map<String, String> adbEnv = this.loadDockerEnv(server);
        Properties props = this.loadOpenshiftConsoleDetails(server, suppressErrors);
        String registry = this.getOpenshiftRegistry(server, suppressErrors);
        if (registry != null) {
            props.put("DOCKER_REGISTRY", registry);
        }
        Map<String, String> merged = this.merge(adbEnv, props);
        Properties dotCDK = this.getCDKProperties(server);
        merged = this.merge(merged, dotCDK);
        File ocLocation = this.findOCLocation(server);
        if (ocLocation != null) {
            merged.put("cdk.oc.location.jbt.prop", ocLocation.getAbsolutePath());
        }
        try {
            return new ServiceManagerEnvironment(merged);
        }
        catch (URISyntaxException urise) {
            if (!suppressErrors) {
                String msg = "Environment variable DOCKER_HOST is not a valid uri:  " + merged.get("DOCKER_HOST");
                CDKCoreActivator.pluginLog().logError(msg, (Throwable)urise);
            }
            return null;
        }
    }

    private String getMinishiftHome(IServer server) {
        String minishiftHomeDefault = String.valueOf(System.getProperty("user.home")) + File.separator + ".minishift";
        String minishiftHome = server.getAttribute("minishift.home.location", minishiftHomeDefault);
        return minishiftHome;
    }

    private String getMinishiftProfileHome(IServer server) {
        String profile = server.getAttribute("minishift.profile", null);
        String msHome = this.getMinishiftHome(server);
        if (StringUtils.isEmpty((String)profile) || profile.equals("minishift")) {
            return msHome;
        }
        return new Path(msHome).append("profiles").append(profile).toOSString();
    }

    private Properties getCDKProperties(IServer server) {
        String profileHome = this.getMinishiftProfileHome(server);
        Properties dotCDK = CDKServerUtility.getDotCDK(profileHome, "cdk");
        return dotCDK;
    }

    private File findOCLocation(IServer server) {
        Object[] names;
        File cache;
        File oc;
        String profileHome = this.getMinishiftProfileHome(server);
        File root = new File(profileHome);
        if (root.exists() && (oc = new File(cache = new File(root, "cache"), "oc")).exists() && (names = oc.list()) != null && names.length > 0) {
            Arrays.sort(names);
            Object latest = names[names.length - 1];
            File latestF = new File(oc, (String)latest);
            String platformDep = Platform.getOS().equals("win32") ? "oc.exe" : "oc";
            File ocBin = new File(latestF, platformDep);
            if (ocBin.exists()) {
                return ocBin;
            }
        }
        return null;
    }

    protected String getOpenshiftRegistry(IServer server, boolean suppressErrors) {
        block6: {
            Map<String, String> env = CDKLaunchEnvironmentUtil.createEnvironment(server);
            String cmdLoc = MinishiftBinaryUtility.getMinishiftLocation(server);
            String[] args = new String[]{"openshift", "registry"};
            args = CDK32Server.getArgsWithProfile(server, args);
            File wd = JBossServerCorePlugin.getServerStateLocation((IServer)server).toFile();
            try {
                String[] lines = this.callAndGetLines(env, args, cmdLoc, wd);
                String invalidMsg = null;
                if (lines != null && lines.length > 0 && lines[0] != null) {
                    String l = lines[0];
                    if (this.validateHostPort(l)) {
                        return l;
                    }
                    invalidMsg = "Call to '" + cmdLoc + " openshift registry' returned an invalid url: " + l;
                } else {
                    invalidMsg = "Call to '" + cmdLoc + " openshift registry' was unable to locate an image registry for server " + server.getName();
                }
                if (invalidMsg != null && !suppressErrors) {
                    CDKCoreActivator.pluginLog().logWarning(invalidMsg);
                }
            }
            catch (IOException ioe) {
                if (suppressErrors) break block6;
                String errMsg = "Unable to successfully complete a call to minishift openshift registry.";
                CDKCoreActivator.pluginLog().logError(errMsg, (Throwable)ioe);
            }
        }
        return null;
    }

    private boolean validateHostPort(String string) {
        try {
            URI uri = new URI("my://" + string);
            return uri.getHost() != null && uri.getPort() != -1;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    protected Map<String, String> loadDockerEnv(IServer server) {
        Map<String, String> env = CDKLaunchEnvironmentUtil.createEnvironment(server);
        String cmdLoc = MinishiftBinaryUtility.getMinishiftLocation(server);
        String[] args = new String[]{"docker-env"};
        args = CDK32Server.getArgsWithProfile(server, args);
        File wd = JBossServerCorePlugin.getServerStateLocation((IServer)server).toFile();
        try {
            HashMap<String, String> adbEnv = this.callAndParseEnvVar(env, args, cmdLoc, wd);
            return adbEnv;
        }
        catch (IOException ioe) {
            CDKCoreActivator.pluginLog().logError("Unable to successfully complete a call to minishift docker-env ", (Throwable)ioe);
            return new HashMap<String, String>();
        }
    }

    protected Properties loadOpenshiftConsoleDetails(IServer server, boolean suppressError) {
        Map<String, String> env = CDKLaunchEnvironmentUtil.createEnvironment(server);
        String[] args = new String[]{"console", "--machine-readable"};
        args = CDK32Server.getArgsWithProfile(server, args);
        File wd = JBossServerCorePlugin.getServerStateLocation((IServer)server).toFile();
        String cmdLoc = MinishiftBinaryUtility.getMinishiftLocation(server);
        try {
            Properties ret = this.callAndParseProperties(env, args, cmdLoc, wd);
            return ret;
        }
        catch (IOException ce) {
            if (!suppressError) {
                CDKCoreActivator.pluginLog().logError("Unable to successfully complete a call to minishift console --machine-readable. ", (Throwable)ce);
            }
            return new Properties();
        }
    }
}

