/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CommandTimeoutException;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.MinishiftServiceManagerEnvironmentLoader;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.VagrantServiceManagerEnvironmentLoader;

public abstract class ServiceManagerEnvironmentLoader {
    public static final String SHARED_INFO_KEY = "cdk.sharedinfo.serviceManagerEnvironment";
    public static final String OC_LOCATION_KEY = "cdk.oc.location.jbt.prop";
    public static final int TYPE_NULL = 0;
    public static final int TYPE_VAGRANT = 1;
    public static final int TYPE_MINISHIFT = 2;
    private int type;

    public static ServiceManagerEnvironmentLoader getVagrantLoader() {
        return new VagrantServiceManagerEnvironmentLoader();
    }

    public static ServiceManagerEnvironmentLoader getMinishiftLoader() {
        return new MinishiftServiceManagerEnvironmentLoader();
    }

    public static ServiceManagerEnvironmentLoader type(IServer s) {
        String typeId = s.getServerType().getId();
        if (typeId.equals("org.jboss.tools.openshift.cdk.server.type")) {
            return ServiceManagerEnvironmentLoader.getVagrantLoader();
        }
        if (typeId.equals("org.jboss.tools.openshift.cdk.server.type.v3") || typeId.equals("org.jboss.tools.openshift.cdk.server.type.v32")) {
            return ServiceManagerEnvironmentLoader.getMinishiftLoader();
        }
        return new NullEnvironmentLoader();
    }

    public ServiceManagerEnvironmentLoader(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public ServiceManagerEnvironment getOrLoadServiceManagerEnvironment(IServer server, boolean save) {
        return this.getOrLoadServiceManagerEnvironment(server, save, false);
    }

    public ServiceManagerEnvironment getOrLoadServiceManagerEnvironment(IServer server, boolean save, boolean suppressErrors) {
        return this.getOrLoadServiceManagerEnvironment(server, save, 1, suppressErrors);
    }

    public ServiceManagerEnvironment getOrLoadServiceManagerEnvironment(IServer server, boolean save, int maxTries, boolean suppressErrors) {
        IControllableServerBehavior behavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        Object o = behavior.getSharedData(SHARED_INFO_KEY);
        ServiceManagerEnvironment ret = null;
        ret = !(o instanceof ServiceManagerEnvironment) ? this.loadServiceManagerEnvironment(server, maxTries, suppressErrors) : (ServiceManagerEnvironment)o;
        if (save) {
            behavior.putSharedData(SHARED_INFO_KEY, (Object)ret);
        }
        return ret;
    }

    public void clearServiceManagerEnvironment(IServer server) {
        IControllableServerBehavior behavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        behavior.putSharedData(SHARED_INFO_KEY, null);
    }

    public ServiceManagerEnvironment loadServiceManagerEnvironment(IServer server, int maxTries, boolean suppressErrors) {
        int i = 0;
        while (i < maxTries) {
            ServiceManagerEnvironment env = this.loadServiceManagerEnvironment(server, suppressErrors);
            if (env != null) {
                return env;
            }
            ++i;
        }
        return null;
    }

    protected String[] callAndGetLines(Map<String, String> env, String[] args, String cmdLoc, File wd) throws IOException {
        String[] lines = null;
        try {
            lines = CDKLaunchUtility.call(cmdLoc, args, wd, env, 30000, false);
        }
        catch (IOException ce) {
            throw ce;
        }
        catch (CommandTimeoutException ce) {
            if (ce.getInLines() == null) {
                throw new IOException(ce);
            }
            lines = ce.getInLines() == null ? null : ce.getInLines().toArray(new String[ce.getInLines().size()]);
        }
        return lines;
    }

    protected HashMap<String, String> callAndParseEnvVar(Map<String, String> env, String[] args, String cmdLoc, File wd) throws IOException {
        String[] lines = this.callAndGetLines(env, args, cmdLoc, wd);
        HashMap<String, String> adbEnv = ServiceManagerUtility.parseLines(lines);
        if (adbEnv == null) {
            throw new IOException("Error calling " + cmdLoc + " with args " + String.join((CharSequence)", ", args));
        }
        return adbEnv;
    }

    protected Properties callAndParseProperties(Map<String, String> env, String[] args, String cmdLoc, File wd) throws IOException {
        String[] lines = null;
        try {
            lines = CDKLaunchUtility.call(cmdLoc, args, wd, env, 30000, false);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (CommandTimeoutException ce) {
            if (ce.getInLines() == null) {
                throw new IOException(ce);
            }
            lines = ce.getInLines() == null ? null : ce.getInLines().toArray(new String[ce.getInLines().size()]);
        }
        String imploded = String.join((CharSequence)"\n", Arrays.asList(lines));
        Properties ret = new Properties();
        ret.load(new ByteArrayInputStream(imploded.getBytes()));
        return ret;
    }

    protected Map<String, String> merge(Map<String, String> env, Properties props) {
        Set<String> propNames = props.stringPropertyNames();
        for (String k : propNames) {
            env.put(k, props.getProperty(k));
        }
        return env;
    }

    public abstract ServiceManagerEnvironment loadServiceManagerEnvironment(IServer var1, boolean var2);

    public static class NullEnvironmentLoader
    extends ServiceManagerEnvironmentLoader {
        public NullEnvironmentLoader() {
            super(0);
        }

        @Override
        public ServiceManagerEnvironment loadServiceManagerEnvironment(IServer server, boolean suppressErrors) {
            try {
                return new ServiceManagerEnvironment(new HashMap<String, String>());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }
}

