/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Server;
import org.jboss.tools.openshift.cdk.server.core.internal.detection.MinishiftVersionLoader;
import org.jboss.tools.openshift.cdk.server.ui.internal.CDK3ServerWizardFragment;

public class CDK32ServerWizardFragment
extends CDK3ServerWizardFragment {
    protected String profileName;
    protected Text profileText;

    @Override
    public Composite createComposite(Composite parent, IWizardHandle handle) {
        String title = "Red Hat Container Development Environment";
        String desc = "A server adapter representing Red Hat Container Development Kit Version 3.2+";
        String label = "Minishift Binary: ";
        return this.createComposite(parent, handle, title, desc, label);
    }

    @Override
    protected Composite createComposite(Composite parent, IWizardHandle handle, String title, String desc, String homeLabel) {
        Composite main = this.setupComposite(parent, handle, title, desc);
        this.createCredentialWidgets(main);
        this.createHypervisorWidgets(main);
        this.createLocationWidgets(main, homeLabel);
        this.createProfileWidgets(main);
        this.validateAndPack(main);
        return main;
    }

    protected void createProfileWidgets(Composite main) {
        Label l = new Label(main, 0);
        l.setText("Minishift Profile:");
        GridData profileData = new GridData();
        profileData.grabExcessHorizontalSpace = true;
        profileData.horizontalAlignment = 4;
        profileData.horizontalSpan = 2;
        this.profileText = new Text(main, 2052);
        this.profileText.setLayoutData((Object)profileData);
        this.profileText.setText("minishift");
        this.profileName = "minishift";
        this.profileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDK32ServerWizardFragment.this.profileName = CDK32ServerWizardFragment.this.profileText.getText();
                CDK32ServerWizardFragment.this.validate();
            }
        });
    }

    @Override
    protected String isVersionCompatible(MinishiftVersionLoader.MinishiftVersions versions) {
        String cdkVers = versions.getCDKVersion();
        if (cdkVers == null) {
            return "Cannot determine CDK version.";
        }
        if (CDK32Server.matchesCDK32(cdkVers)) {
            return null;
        }
        return "CDK version " + cdkVers + " is not compatible with this server adapter.";
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        IServer s = this.getServerFromTaskModel();
        if (s instanceof IServerWorkingCopy) {
            IServerWorkingCopy swc = (IServerWorkingCopy)s;
            if (this.profileName != null && !this.profileName.isEmpty()) {
                swc.setAttribute("minishift.profile", this.profileName);
            }
        }
    }
}

