/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyButtonCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyComboCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyCommand;
import org.jboss.tools.foundation.ui.credentials.ChooseCredentialComponent;
import org.jboss.tools.foundation.ui.credentials.ICredentialCompositeListener;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;

public class CDKCredentialSection
extends ServerEditorSection {
    private Button passCredentialsButton;
    private SelectionListener passCredentialsListener;
    private ChooseCredentialComponent credentialComposite;
    private Text envUserText;
    private Text envPassText;
    private ModifyListener envUserListener;
    private ModifyListener envPassListener;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        CDKServer cdkServer = (CDKServer)((Object)this.server.getOriginal().loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText("Credentials");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.passCredentialsButton = toolkit.createButton(composite, "Pass credentials to environment", 32);
        this.passCredentialsButton.setSelection(cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false));
        this.passCredentialsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDKCredentialSection.this.execute((IUndoableOperation)new SetPassCredentialsCommand(CDKCredentialSection.this.server));
            }
        };
        this.passCredentialsButton.addSelectionListener(this.passCredentialsListener);
        this.credentialComposite = this.createChooseCredentialComponent(composite);
        this.credentialComposite.addCredentialListener(new ICredentialCompositeListener(){

            public void credentialsChanged() {
                CDKCredentialSection.this.execute((IUndoableOperation)new SetUsernameCommand(CDKCredentialSection.this.server));
            }
        });
        Label environmentVars = toolkit.createLabel(composite, "Environment Variables: ");
        toolkit.createLabel(composite, "Username: ");
        this.envUserText = toolkit.createText(composite, cdkServer.getUserEnvironmentKey());
        toolkit.createLabel(composite, "Password: ");
        this.envPassText = toolkit.createText(composite, cdkServer.getPasswordEnvironmentKey());
        this.envUserListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDKCredentialSection.this.execute((IUndoableOperation)new SetUsernameVariableCommand(CDKCredentialSection.this.server));
            }
        };
        this.envUserText.addModifyListener(this.envUserListener);
        this.envPassListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDKCredentialSection.this.execute((IUndoableOperation)new SetPasswordVariableCommand(CDKCredentialSection.this.server));
            }
        };
        this.envPassText.addModifyListener(this.envPassListener);
        GridDataFactory.generate((Control)this.passCredentialsButton, (Point)new Point(3, 1));
        this.credentialComposite.gridLayout(3);
        GridDataFactory.generate((Control)environmentVars, (Point)new Point(3, 1));
        GridDataFactory.generate((Control)this.envUserText, (Point)new Point(2, 1));
        GridDataFactory.generate((Control)this.envPassText, (Point)new Point(2, 1));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private ChooseCredentialComponent createChooseCredentialComponent(Composite parent) {
        String initialUsername = this.server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", null);
        ChooseCredentialComponent comp = new ChooseCredentialComponent(new String[]{"access.redhat.com"}, initialUsername);
        comp.create(parent);
        return comp;
    }

    public class SetPassCredentialsCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetPassCredentialsCommand(IServerWorkingCopy server) {
            super(server, "Pass credentials to server", CDKCredentialSection.this.passCredentialsButton, CDKCredentialSection.this.passCredentialsButton.getSelection(), "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", CDKCredentialSection.this.passCredentialsListener);
        }

        protected void postOp(int type) {
            boolean pass = this.wc.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", true);
            CDKCredentialSection.this.envUserText.setEnabled(pass);
            CDKCredentialSection.this.envPassText.setEnabled(pass);
            CDKCredentialSection.this.credentialComposite.setEnabled(pass);
        }
    }

    public class SetPasswordVariableCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetPasswordVariableCommand(IServerWorkingCopy server) {
            super(server, "Change Password Variable", CDKCredentialSection.this.envPassText, CDKCredentialSection.this.envPassText.getText(), "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", CDKCredentialSection.this.envPassListener);
        }
    }

    public class SetUsernameCommand
    extends ServerWorkingCopyPropertyComboCommand {
        public SetUsernameCommand(IServerWorkingCopy server) {
            super(server, "Change Username", CDKCredentialSection.this.credentialComposite.getUserCombo(), CDKCredentialSection.this.credentialComposite.getUser(), "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", CDKCredentialSection.this.credentialComposite.getUserListener());
        }
    }

    public class SetUsernameVariableCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetUsernameVariableCommand(IServerWorkingCopy server) {
            super(server, "Change Username Variable", CDKCredentialSection.this.envUserText, CDKCredentialSection.this.envUserText.getText(), "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", CDKCredentialSection.this.envUserListener);
        }
    }
}

