/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.foundation.ui.credentials.ChooseCredentialComponent;
import org.jboss.tools.foundation.ui.credentials.ICredentialCompositeListener;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;

public class CDKServerWizardFragment
extends WizardFragment {
    protected IWizardHandle handle;
    protected String homeDir;
    protected Text homeText;
    protected ControlDecoration homeDecorator;
    protected Button browseButton;
    protected String selectedUser = null;
    protected ChooseCredentialComponent credentials;

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        boolean b = this.browseButton != null && !this.browseButton.isDisposed() && this.findError() == null && super.isComplete();
        return b;
    }

    public ImageDescriptor getImageDescriptor() {
        return CDKCoreActivator.getDefault().getSharedImages().descriptor("icons/cdk_box_130x65.png");
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        String title = "Red Hat Container Development Environment";
        String desc = "A server adapter representing a Red Hat Container Development Kit installation folder containing a Vagrantfile.";
        String label = "Folder: ";
        return this.createComposite(parent, handle, title, desc, label);
    }

    protected Composite setupComposite(Composite parent, IWizardHandle handle, String title, String desc) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        handle.setTitle(title);
        handle.setDescription(desc);
        handle.setImageDescriptor(this.getImageDescriptor());
        main.setLayout((Layout)new GridLayout(3, false));
        return main;
    }

    protected void createCredentialWidgets(Composite main) {
        this.selectedUser = null;
        this.credentials = new ChooseCredentialComponent(new String[]{"access.redhat.com"});
        this.credentials.addCredentialListener(new ICredentialCompositeListener(){

            public void credentialsChanged() {
                CDKServerWizardFragment.this.selectedUser = CDKServerWizardFragment.this.credentials.getUser();
                CDKServerWizardFragment.this.validate();
            }
        });
        this.credentials.create(main);
        this.credentials.gridLayout(3);
        this.selectedUser = this.credentials.getUser();
    }

    protected void createLocationWidgets(Composite main, String homeLabel) {
        Label l = new Label(main, 0);
        l.setText(homeLabel);
        GridData homeData = new GridData();
        homeData.grabExcessHorizontalSpace = true;
        homeData.horizontalAlignment = 4;
        this.homeText = new Text(main, 2048);
        this.homeText.setLayoutData((Object)homeData);
        this.browseButton = new Button(main, 8);
        this.browseButton.setText("Browse...");
        this.homeText.addModifyListener(this.createHomeModifyListener());
        this.browseButton.addSelectionListener(this.createBrowseListener());
        this.homeDecorator = new ControlDecoration((Control)this.homeText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        this.homeDecorator.setImage(img);
        this.homeDecorator.hide();
        this.fillTextField();
    }

    protected SelectionListener createBrowseListener() {
        return new BrowseListener();
    }

    protected ModifyListener createHomeModifyListener() {
        return new HomeModifyListener();
    }

    protected void validateAndPack(Composite main) {
        String err = this.findError();
        this.setComplete(err == null);
        this.handle.update();
        main.pack(true);
        this.homeDecorator.hide();
    }

    protected Composite createComposite(Composite parent, IWizardHandle handle, String title, String desc, String homeLabel) {
        Composite main = this.setupComposite(parent, handle, title, desc);
        this.createCredentialWidgets(main);
        this.createLocationWidgets(main, homeLabel);
        this.validateAndPack(main);
        return main;
    }

    protected void fillTextField() {
        if (this.homeDir != null) {
            this.homeText.setText(this.homeDir);
        }
    }

    protected void validate() {
        String err = this.findError();
        if (err != null) {
            this.handle.setMessage(err, 3);
            this.setComplete(false);
        } else {
            this.setComplete(true);
            String warn = this.findWarning();
            if (warn != null) {
                this.handle.setMessage(warn, 2);
            } else {
                this.handle.setMessage(null, 0);
            }
        }
        this.handle.update();
    }

    protected String findWarning() {
        return null;
    }

    protected void toggleHomeDecorator(String message) {
        if (message == null) {
            this.homeDecorator.hide();
        } else {
            this.homeDecorator.setDescriptionText(message);
            this.homeDecorator.show();
        }
    }

    protected String findError() {
        if (this.credentials.getDomain() == null || this.credentials.getUser() == null) {
            return "The Container Development Environment Server Adapter requires Red Hat Access credentials.";
        }
        String retString = this.validateHomeDirectory();
        if (retString != null) {
            return retString;
        }
        return retString;
    }

    protected String validateHomeDirectory() {
        String retString = null;
        if (this.homeDir == null || !new File(this.homeDir).exists()) {
            retString = "The selected folder does not exist.";
        } else if (!new File(this.homeDir, "Vagrantfile").exists()) {
            retString = "The selected folder does not have a Vagrantfile";
        }
        this.toggleHomeDecorator(retString);
        return retString;
    }

    protected void browseHomeDirClicked() {
        this.browseHomeDirClicked(true);
    }

    protected void browseHomeDirClicked(boolean folder) {
        File file;
        File file2 = file = this.homeDir == null ? null : new File(this.homeDir);
        if (file != null && !file.exists()) {
            file = null;
        }
        File f = null;
        f = folder ? CDKServerWizardFragment.getDirectory(file, this.homeText.getShell()) : CDKServerWizardFragment.getFile(file, this.homeText.getShell());
        if (f != null) {
            this.homeDir = f.getAbsolutePath();
            this.homeText.setText(this.homeDir);
        }
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    protected static File getFile(File startingDirectory, Shell shell) {
        String dir;
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    protected IServer getServerFromTaskModel() {
        IServer wc = (IServer)this.getTaskModel().getObject("server");
        return wc;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.exit();
        IServer s = this.getServerFromTaskModel();
        if (s instanceof IServerWorkingCopy) {
            IServerWorkingCopy swc = (IServerWorkingCopy)s;
            swc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", this.homeDir);
            swc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", this.selectedUser);
        }
    }

    protected class BrowseListener
    implements SelectionListener {
        protected BrowseListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            CDKServerWizardFragment.this.browseHomeDirClicked();
            CDKServerWizardFragment.this.validate();
        }
    }

    protected class HomeModifyListener
    implements ModifyListener {
        protected HomeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CDKServerWizardFragment.this.homeDir = CDKServerWizardFragment.this.homeText.getText();
            CDKServerWizardFragment.this.validate();
        }
    }
}

