/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.command;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class RemoveConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IConnection[] connections = UIUtils.getElements(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IConnection.class);
        if (connections.length == 0) {
            return null;
        }
        ArrayList<IConnection> safeConnections = new ArrayList<IConnection>(connections.length);
        IConnection[] iConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnection connection = iConnectionArray[n2];
            if (connection != null) {
                safeConnections.add(connection);
            }
            ++n2;
        }
        if (safeConnections.isEmpty()) {
            return null;
        }
        if (MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Remove connection", (String)NLS.bind((String)"You are about to remove the connection(s):\n{0}\n\nDo you want to continue?\n\n", (Object)StringUtils.toString(safeConnections, (StringUtils.ToStringConverter)new StringUtils.ToStringConverter<IConnection>(){

            public String toString(IConnection connection) {
                return "\n" + connection.toString();
            }
        })))) {
            for (IConnection connection : safeConnections) {
                ConnectionsRegistrySingleton.getInstance().remove(connection);
            }
        }
        return null;
    }
}

