/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.connection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.databinding.IObservablePojo;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.connection.ConnectionsFactoryTracker;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.common.core.connection.IConnectionsFactory;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.core.security.SecureStoreException;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;

public class ConnectionWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_CONNECTION = "selectedConnection";
    public static final String PROPERTY_CONNECTION_FACTORY = "connectionFactory";
    public static final String PROPERTY_CONNECTION_FACTORY_ERROR = "connectionFactoryError";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_USE_DEFAULT_HOST = "useDefaultHost";
    public static final String PROPERTY_ALL_HOSTS = "allHosts";
    public static final String PROPERTY_CONNECTED_STATUS = "connectedStatus";
    public static final String PROPERTY_SIGNUPURL = "signupUrl";
    public static final String PROPERTY_USERDOCURL = "userdocUrl";
    public static final String PROPERTY_HAS_DEFAULT_HOST = "hasDefaultHost";
    private static final IStatus NOT_CONNECTED_STATUS = null;
    private IConnection selectedConnection;
    private IConnection connection;
    private IStatus connectionFactoryError;
    private String host;
    private IConnectionFactory connectionFactory;
    private boolean useDefaultHost;
    private boolean hasDefaultHost;
    private Collection<String> allHosts;
    private ConnectionsFactoryTracker connectionsFactory;
    private String userdocUrl;
    private IStatus connectedStatus;
    private IConnectionAuthenticationProvider connectionAuthenticationProvider;
    private IConnectionAdvancedPropertiesProvider connectionAdvancedPropertiesProvider;
    private Collection<IConnection> allConnections;
    private Class<? extends IConnection> connectionType;
    private IConnectionAware<IConnection> wizardModel;
    private boolean enablePromptCredentialsBackup = false;
    private boolean allowConnectionChange = true;
    StorageAccessListener listener = new StorageAccessListener();

    protected ConnectionWizardPageModel(IConnection editedConnection, Collection<IConnection> allConnections, Class<? extends IConnection> connectionType, boolean allowConnectionChange, IConnectionAware<IConnection> wizardModel) {
        this.allConnections = this.filterAllConnections(editedConnection, allConnections, connectionType, allowConnectionChange);
        this.connectionType = connectionType;
        this.wizardModel = wizardModel;
        this.allHosts = this.createAllHosts(allConnections);
        this.connectionsFactory = this.createConnectionsFactory();
        this.allowConnectionChange = allowConnectionChange;
        this.init(editedConnection, connectionType, this.connectionFactory);
    }

    private Collection<IConnection> filterAllConnections(IConnection editedConnection, Collection<IConnection> allConnections, Class<? extends IConnection> connectionType, boolean allowConnectionChange) {
        if (!allowConnectionChange) {
            if (editedConnection != null) {
                return Collections.singletonList(editedConnection);
            }
            return Collections.emptyList();
        }
        if (connectionType == null) {
            return allConnections;
        }
        return allConnections.stream().filter(connection -> connection.getClass().equals(connectionType)).collect(Collectors.toList());
    }

    private Collection<String> createAllHosts(Collection<IConnection> allConnections) {
        if (allConnections == null) {
            return Collections.emptyList();
        }
        return allConnections.stream().map(connection -> connection.getHost()).filter(host -> !StringUtils.isEmpty((String)host)).distinct().collect(Collectors.toList());
    }

    protected ConnectionsFactoryTracker createConnectionsFactory() {
        ConnectionsFactoryTracker connectionsFactory = new ConnectionsFactoryTracker();
        connectionsFactory.open();
        return connectionsFactory;
    }

    private void init(IConnection editedConnection, Class<? extends IConnection> connectionType, IConnectionFactory connectionFactory) {
        this.connectedStatus = Status.OK_STATUS;
        this.connectionFactoryError = Status.OK_STATUS;
        this.initConnection(editedConnection, connectionType);
        this.userdocUrl = this.getUserdocUrl(this.connectionFactory);
    }

    private void initConnection(IConnection editedConnection, Class<? extends IConnection> connectionType) {
        if (editedConnection == null || connectionType != null && !editedConnection.getClass().equals(connectionType)) {
            this.initNewConnection(connectionType);
        } else {
            this.initEditConnection(editedConnection);
        }
    }

    private void initEditConnection(IConnection connection) {
        this.selectedConnection = connection;
        this.enablePromptCredentialsBackup = this.selectedConnection.isEnablePromptCredentials();
        this.selectedConnection.enablePromptCredentials(false);
        this.connectionFactory = this.connectionsFactory.getByConnection(connection.getClass());
        this.host = connection.getHost();
        this.hasDefaultHost = this.connectionFactory != null && this.connectionFactory.hasDefaultHost();
        this.useDefaultHost = connection.isDefaultHost();
    }

    private void initNewConnection(Class<? extends IConnection> connectionType) {
        this.selectedConnection = NewConnectionMarker.getInstance();
        this.connectionFactory = this.getConnectionFactory(connectionType, (IConnectionsFactory)this.connectionsFactory);
        if (this.connectionFactory != null) {
            this.host = this.connectionFactory.getDefaultHost();
            this.useDefaultHost = this.hasDefaultHost = this.connectionFactory.hasDefaultHost();
        }
    }

    private IConnectionFactory getConnectionFactory(Class<? extends IConnection> connectionType, IConnectionsFactory connectionsFactory) {
        IConnectionFactory factory = null;
        factory = connectionType == null ? this.getDefaultConnectionFactory(connectionsFactory) : connectionsFactory.getByConnection(connectionType);
        return factory;
    }

    private IConnectionFactory getDefaultConnectionFactory(IConnectionsFactory connectionsFactory) {
        IConnectionFactory factory = connectionsFactory.getById("org.jboss.tools.openshift.core.ConnectionFactory");
        if (factory == null) {
            factory = connectionsFactory.getById("org.jboss.tools.openshift.express.core.ConnectionFactory");
        }
        return factory;
    }

    private void update(IConnection selectedConnection, IConnectionFactory factory, String host, boolean useDefaultHost, IStatus connectionFactoryError, IStatus connectError) {
        factory = this.updateFactory(factory, selectedConnection);
        useDefaultHost = this.updateUseDefaultHost(useDefaultHost, selectedConnection, factory);
        host = this.updateHost(host, useDefaultHost, selectedConnection, factory);
        String userdocUrl = this.getUserdocUrl(factory);
        this.selectedConnection = selectedConnection;
        this.firePropertyChange(PROPERTY_SELECTED_CONNECTION, this.selectedConnection, this.selectedConnection);
        this.connectionFactory = factory;
        this.firePropertyChange(PROPERTY_CONNECTION_FACTORY, this.connectionFactory, this.connectionFactory);
        this.host = host;
        this.firePropertyChange(PROPERTY_HOST, this.host, this.host);
        this.useDefaultHost = useDefaultHost;
        this.firePropertyChange(PROPERTY_USE_DEFAULT_HOST, this.useDefaultHost, this.useDefaultHost);
        this.hasDefaultHost = factory != null && factory.hasDefaultHost();
        this.firePropertyChange(PROPERTY_HAS_DEFAULT_HOST, this.hasDefaultHost, this.hasDefaultHost);
        this.userdocUrl = userdocUrl;
        this.firePropertyChange(PROPERTY_USERDOCURL, this.userdocUrl, this.userdocUrl);
        this.setConnectionFactoryError(connectionFactoryError);
        this.setConnectedStatus(connectError);
    }

    private IConnectionFactory updateFactory(IConnectionFactory factory, IConnection selectedConnection) {
        if (selectedConnection instanceof NewConnectionMarker) {
            return factory;
        }
        if (!selectedConnection.equals(this.selectedConnection) && !(selectedConnection instanceof NewConnectionMarker)) {
            factory = this.connectionsFactory.getByConnection(selectedConnection.getClass());
        }
        return factory;
    }

    private String updateHost(String host, boolean useDefaultHost, IConnection selectedConnection, IConnectionFactory factory) {
        if (!selectedConnection.equals(this.selectedConnection)) {
            host = selectedConnection instanceof NewConnectionMarker ? factory.getDefaultHost() : selectedConnection.getHost();
        } else if (!factory.equals(this.connectionFactory) && useDefaultHost) {
            host = factory.getDefaultHost();
        } else if (useDefaultHost != this.useDefaultHost) {
            host = factory.getDefaultHost();
        }
        return host;
    }

    private boolean updateUseDefaultHost(boolean useDefaultHost, IConnection selectedConnection, IConnectionFactory factory) {
        if (selectedConnection != null && !selectedConnection.equals(this.selectedConnection)) {
            useDefaultHost = selectedConnection instanceof NewConnectionMarker ? factory.hasDefaultHost() : selectedConnection.isDefaultHost();
        } else if (factory != null && !factory.equals(this.connectionFactory)) {
            if (useDefaultHost || StringUtils.isEmpty((String)this.host)) {
                useDefaultHost = factory.hasDefaultHost();
            }
        } else if (useDefaultHost && !factory.hasDefaultHost()) {
            useDefaultHost = false;
        }
        return useDefaultHost;
    }

    private String getUserdocUrl(IConnectionFactory factory) {
        if (factory == null) {
            return null;
        }
        return factory.getUserDocUrl();
    }

    protected boolean isNewConnection() {
        return this.selectedConnection instanceof NewConnectionMarker;
    }

    public void setSelectedConnection(IConnection selectedConnection) {
        this.update(selectedConnection, this.connectionFactory, this.host, this.useDefaultHost, Status.OK_STATUS, NOT_CONNECTED_STATUS);
    }

    public IConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnectionFactory(IConnectionFactory factory) {
        this.update((IConnection)NewConnectionMarker.getInstance(), factory, this.host, this.useDefaultHost, Status.OK_STATUS, NOT_CONNECTED_STATUS);
    }

    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public boolean isHasDefaultHost() {
        return this.hasDefaultHost;
    }

    public Collection<IConnection> getAllConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        connections.add((IConnection)NewConnectionMarker.getInstance());
        if (this.allConnections != null) {
            connections.addAll(this.allConnections);
        }
        return connections;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserdocUrl() {
        return this.userdocUrl;
    }

    public void setHost(String host) {
        this.update(this.selectedConnection, this.connectionFactory, host, this.useDefaultHost, Status.OK_STATUS, NOT_CONNECTED_STATUS);
    }

    private void setConnectionFactoryError(IStatus status) {
        this.connectionFactoryError = status;
        this.firePropertyChange(PROPERTY_CONNECTION_FACTORY_ERROR, this.connectionFactoryError, this.connectionFactoryError);
    }

    public IStatus getConnectionFactoryError() {
        return this.connectionFactoryError;
    }

    public void setUseDefaultHost(boolean useDefaultHost) {
        this.update(this.selectedConnection, this.connectionFactory, this.host, useDefaultHost, Status.OK_STATUS, NOT_CONNECTED_STATUS);
    }

    public boolean isUseDefaultHost() {
        return this.useDefaultHost;
    }

    public void setAllHosts(Collection<String> allHosts) {
        this.allHosts = allHosts;
        this.firePropertyChange(PROPERTY_ALL_HOSTS, this.allHosts, this.allHosts);
    }

    public Collection<String> getAllHosts() {
        return this.allHosts;
    }

    public void refreshWizardModel() {
        this.wizardModel.setConnection(this.connection);
    }

    public IStatus connect() {
        IStatus status;
        block9: {
            if (this.isConnected() && this.listener.secureStoreException == null) {
                return Status.OK_STATUS;
            }
            status = Status.OK_STATUS;
            this.listener.secureStoreException = null;
            try {
                try {
                    IConnection connection = this.createConnection();
                    if (connection != null) {
                        this.addConnectionListener(connection);
                        if (connection.connect()) {
                            connection.enablePromptCredentials(true);
                            this.connection = connection;
                            this.wizardModel.setConnection(connection);
                            ConnectionsRegistrySingleton.getInstance().setRecent(connection);
                            connection.notifyUsage();
                        } else {
                            String message = NLS.bind((String)"Unable to connect to {0}", (Object)connection.getHost());
                            OpenShiftCommonUIActivator.log(message, null);
                            status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)message);
                        }
                    }
                }
                catch (Exception e) {
                    status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)e.getMessage());
                    OpenShiftCommonUIActivator.log(e);
                    this.removeConnectionListener(this.connection);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.removeConnectionListener(this.connection);
                throw throwable;
            }
            this.removeConnectionListener(this.connection);
        }
        this.update(this.selectedConnection, this.connectionFactory, this.host, this.useDefaultHost, Status.OK_STATUS, status);
        return status;
    }

    public IConnection createConnection() {
        IConnection connection = this.createConnection(this.connectionFactory, this.connectionAuthenticationProvider, this.connectionAdvancedPropertiesProvider);
        return connection;
    }

    private void removeConnectionListener(IConnection connection) {
        if (connection instanceof IObservablePojo) {
            ((IObservablePojo)connection).removePropertyChangeListener((PropertyChangeListener)this.listener);
        }
    }

    private void addConnectionListener(IConnection connection) {
        if (connection instanceof IObservablePojo) {
            ((IObservablePojo)connection).addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
    }

    SecureStoreException getRecentSecureStoreException() {
        return this.listener.secureStoreException;
    }

    private IConnection createConnection(IConnectionFactory factory, IConnectionAuthenticationProvider authProvider, IConnectionAdvancedPropertiesProvider advPropsProvider) {
        if (factory == null) {
            return null;
        }
        IConnection connection = factory.create(this.getHost());
        if (connection == null) {
            return null;
        }
        if (authProvider != null) {
            authProvider.update(connection);
        }
        if (advPropsProvider != null) {
            advPropsProvider.update(connection);
        }
        connection.enablePromptCredentials(false);
        return connection;
    }

    public void setNotConnected() {
        this.setConnectedStatus(NOT_CONNECTED_STATUS);
    }

    private void setConnectedStatus(IStatus status) {
        this.connectedStatus = status;
        this.firePropertyChange(PROPERTY_CONNECTED_STATUS, this.connectedStatus, this.connectedStatus);
        if (this.isConnected()) {
            this.connection.enablePromptCredentials(true);
        }
    }

    public IStatus getConnectedStatus() {
        return this.connectedStatus;
    }

    public boolean isConnected() {
        return this.connectedStatus != null && this.connectedStatus != NOT_CONNECTED_STATUS && this.connectedStatus.isOK();
    }

    public void saveRecentConnection() {
    }

    public Collection<IConnectionFactory> getAllConnectionFactories() {
        return this.connectionsFactory.getAll(this.connectionType);
    }

    public void dispose() {
        this.connectionsFactory.close();
        if (this.selectedConnection != null) {
            this.selectedConnection.enablePromptCredentials(this.enablePromptCredentialsBackup);
        }
    }

    public boolean saveConnection() {
        if (this.connection == null || !this.connectedStatus.isOK()) {
            return false;
        }
        this.connection.enablePromptCredentials(true);
        if (this.isNewConnection()) {
            ConnectionsRegistrySingleton.getInstance().add(this.connection);
        } else {
            ConnectionsRegistrySingleton.getInstance().update(this.getSelectedConnection(), this.connection);
        }
        return true;
    }

    public void cancel() {
        this.connection.enablePromptCredentials(true);
    }

    public void setConnectionAuthenticationProvider(IConnectionAuthenticationProvider authenticationProvider) {
        this.connectionAuthenticationProvider = authenticationProvider;
    }

    public void setConnectionAdvancedPropertiesProvider(IConnectionAdvancedPropertiesProvider connectionAdvancedPropertiesProvider) {
        this.connectionAdvancedPropertiesProvider = connectionAdvancedPropertiesProvider;
    }

    public IConnectionAdvancedPropertiesProvider getConnectionAdvancedPropertiesProvider() {
        return this.connectionAdvancedPropertiesProvider;
    }

    public Object getContext() {
        return this.wizardModel.getContext();
    }

    public boolean isAllowConnectionChange() {
        return this.allowConnectionChange;
    }

    public static interface IConnectionAdvancedPropertiesProvider {
        public IConnection update(IConnection var1);
    }

    public static interface IConnectionAuthenticationProvider {
        public IConnection update(IConnection var1);
    }

    public static interface IConnectionFilter {
        public boolean accept(IConnection var1);
    }

    class StorageAccessListener
    implements PropertyChangeListener {
        SecureStoreException secureStoreException = null;

        StorageAccessListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("secureStoreException".equals(evt.getPropertyName()) && evt.getNewValue() instanceof SecureStoreException) {
                this.secureStoreException = (SecureStoreException)evt.getNewValue();
            }
        }
    }
}

