/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class RequiredStringMultiValidator
extends MultiValidator {
    private IObservableValue<String> observableValue;
    private String name;
    private String errorMessage;

    public RequiredStringMultiValidator(IObservableValue<String> value, String name) {
        this(value, name, null);
    }

    public RequiredStringMultiValidator(String errorMessage, IObservableValue<String> value) {
        this(value, null, errorMessage);
    }

    protected RequiredStringMultiValidator(IObservableValue<String> value, String name, String errorMessage) {
        this.observableValue = value;
        this.name = name;
        this.errorMessage = errorMessage;
    }

    protected IStatus validate() {
        String value = (String)this.observableValue.getValue();
        if (!this.isValueProvided(value)) {
            return ValidationStatus.cancel((String)this.getErrorMessage());
        }
        return this.validateValue(value);
    }

    protected boolean isValueProvided(String value) {
        return !StringUtils.isEmpty((String)value);
    }

    protected IStatus validateValue(String value) {
        return ValidationStatus.ok();
    }

    protected String getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return "Please provide a value for " + this.name;
    }
}

