/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.explorer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizard;
import org.jboss.tools.openshift.internal.common.ui.explorer.ILink;

public class OpenShiftExplorerView
extends CommonNavigator
implements IConnectionsRegistryListener {
    private Control connectionsPane;
    private Control explanationsPane;
    private PageBook pageBook;

    protected Object getInitialInput() {
        return ConnectionsRegistrySingleton.getInstance();
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = super.createCommonViewer(parent);
        new OpenShiftExplorerContextsHandler(viewer);
        return viewer;
    }

    public void dispose() {
        ConnectionsRegistrySingleton.getInstance().removeListener((IConnectionsRegistryListener)this);
        super.dispose();
    }

    public void connectionAdded(IConnection connection) {
        this.showConnectionsOrExplanations();
    }

    private void showConnectionsOrExplanations() {
        this.asyncShowConnectionsOrExplanations();
    }

    private void asyncShowConnectionsOrExplanations() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!OpenShiftExplorerView.this.pageBook.isDisposed()) {
                    OpenShiftExplorerView.this.showConnectionsOrExplanations(OpenShiftExplorerView.this.connectionsPane, OpenShiftExplorerView.this.explanationsPane);
                }
            }
        });
    }

    public void connectionRemoved(IConnection connection) {
        this.asyncShowConnectionsOrExplanations();
    }

    public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.pageBook = new PageBook(parent, 0);
        super.createPartControl((Composite)this.pageBook);
        this.connectionsPane = this.getCommonViewer().getControl();
        this.explanationsPane = this.createExplanationPane(this.connectionsPane, this.pageBook, toolkit);
        this.showConnectionsOrExplanations(this.connectionsPane, this.explanationsPane);
        ConnectionsRegistrySingleton.getInstance().addListener((IConnectionsRegistryListener)this);
        this.getCommonViewer().refresh();
    }

    private Control createExplanationPane(Control connectionsPane, PageBook pageBook, FormToolkit kit) {
        Form form = kit.createForm((Composite)pageBook);
        Composite composite = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Link link = new Link(composite, 0);
        link.setText("No connections are available. Create a new connection with the <a>New Connection Wizard...</a>");
        link.setBackground(pageBook.getDisplay().getSystemColor(25));
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)this.onExplanationClicked(connectionsPane, (Control)link));
        return form;
    }

    private SelectionAdapter onExplanationClicked(final Control connectionsPane, final Control explanationPane) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizard wizard = new ConnectionWizard();
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    OpenShiftExplorerView.this.showConnectionsOrExplanations(connectionsPane, explanationPane);
                }
            }
        };
    }

    private void showConnectionsOrExplanations(Control connectionsPane, Control explanationsPane) {
        if (ConnectionsRegistrySingleton.getInstance().getAll().size() < 1) {
            this.showPage(explanationsPane);
        } else {
            this.showPage(connectionsPane);
        }
    }

    private void showPage(Control page) {
        this.pageBook.showPage(page);
    }

    public void initListeners(TreeViewer viewer) {
        super.initListeners(viewer);
        Tree tree = viewer.getTree();
        if (tree != null && !tree.isDisposed()) {
            new LinkMouseListener(tree);
        }
    }

    private static class Contexts {
        private IContextActivation contextActivation;

        private Contexts() {
        }

        public void activate(String contextId) {
            this.deactivateCurrent();
            IContextService service = this.getService();
            this.contextActivation = service.activateContext(contextId);
        }

        public void deactivateCurrent() {
            if (this.contextActivation != null) {
                IContextService service = this.getService();
                service.deactivateContext(this.contextActivation);
            }
        }

        private IContextService getService() {
            return (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        }
    }

    static class LinkMouseListener
    extends MouseAdapter
    implements MouseMoveListener {
        Tree tree;
        boolean isLink = false;

        LinkMouseListener(Tree tree) {
            this.tree = tree;
            tree.addMouseListener((MouseListener)this);
            tree.addMouseMoveListener((MouseMoveListener)this);
        }

        public void mouseMove(MouseEvent e) {
            if (this.tree.isDisposed()) {
                return;
            }
            ILink link = this.getLink(e);
            if (this.isLink != (link != null)) {
                this.isLink = link != null;
                Cursor cursor = this.isLink ? Display.getDefault().getSystemCursor(21) : null;
                this.tree.setCursor(cursor);
            }
        }

        public void mouseUp(MouseEvent e) {
            final ILink link = this.getLink(e);
            if (link != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (tree.isDisposed()) {
                            return;
                        }
                        tree.setCursor(null);
                        isLink = false;
                        link.execute();
                    }
                });
            }
        }

        ILink getLink(MouseEvent e) {
            if (e.getSource() instanceof Tree) {
                Tree tree = (Tree)e.getSource();
                TreeItem t = tree.getItem(new Point(e.x, e.y));
                Object o = t == null ? null : t.getData();
                return o instanceof ILink ? (ILink)o : null;
            }
            return null;
        }
    }

    private static class OpenShiftExplorerContextsHandler
    extends Contexts {
        private static final String CONNECTION_CONTEXT = "org.jboss.tools.openshift.explorer.context.connection";

        OpenShiftExplorerContextsHandler(CommonViewer viewer) {
            viewer.getControl().addFocusListener((FocusListener)this.onFocusLost());
            viewer.addSelectionChangedListener(this.onSelectionChanged());
        }

        private FocusAdapter onFocusLost() {
            return new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    this.deactivateCurrent();
                }
            };
        }

        private ISelectionChangedListener onSelectionChanged() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    event.getSelection();
                    this.activate(OpenShiftExplorerContextsHandler.CONNECTION_CONTEXT);
                }
            };
        }
    }
}

