/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.js.listeners;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.internal.js.storage.SessionStorage;

public class NodeDebugTerminateListener
implements IDebugEventSetListener {
    ILaunchConfiguration nodeDebugLaunch;
    IServer server;

    public NodeDebugTerminateListener(ILaunchConfiguration nodeDebugLaunch, IServer server) {
        this.nodeDebugLaunch = nodeDebugLaunch;
        this.server = server;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration lc;
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && (lc = this.getLaunchConfiguration(event)) != null && lc.equals(this.nodeDebugLaunch)) {
                try {
                    SessionStorage.get().remove(this.server);
                    if (this.server.getServerState() == 2) {
                        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                finally {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
            ++n2;
        }
    }

    private ILaunchConfiguration getLaunchConfiguration(DebugEvent event) {
        ILaunch launch;
        ILaunchConfiguration lc = null;
        Object source = event.getSource();
        if (source instanceof IProcess && (launch = ((IProcess)source).getLaunch()) != null) {
            lc = launch.getLaunchConfiguration();
        }
        return lc;
    }
}

