/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.explorer;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerContentProvider;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.explorer.NewProjectLinkNode;
import org.jboss.tools.openshift.internal.ui.models.IConnectionWrapper;
import org.jboss.tools.openshift.internal.ui.models.IElementListener;
import org.jboss.tools.openshift.internal.ui.models.IOpenshiftUIElement;
import org.jboss.tools.openshift.internal.ui.models.IProjectWrapper;
import org.jboss.tools.openshift.internal.ui.models.IReplicationControllerWrapper;
import org.jboss.tools.openshift.internal.ui.models.IResourceContainer;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;
import org.jboss.tools.openshift.internal.ui.models.OpenshiftUIModel;

public class OpenShiftExplorerContentProvider
implements ITreeContentProvider {
    private static final List<String> TERMINATED_STATUS = Arrays.asList("Complete", "Failed", "Error", "Cancelled");
    private OpenshiftUIModel model;
    private IElementListener listener;
    private StructuredViewer viewer;
    private Map<Object, BaseExplorerContentProvider.LoadingStub> stubs = new HashMap<Object, BaseExplorerContentProvider.LoadingStub>();

    public OpenShiftExplorerContentProvider() {
        this(OpenshiftUIModel.getInstance());
    }

    protected OpenShiftExplorerContentProvider(OpenshiftUIModel model) {
        this.model = model;
        this.listener = new IElementListener(){

            @Override
            public void elementChanged(IOpenshiftUIElement<?, ?> element) {
                if (element instanceof OpenshiftUIModel) {
                    OpenShiftExplorerContentProvider.this.refreshViewer(ConnectionsRegistrySingleton.getInstance());
                } else {
                    OpenShiftExplorerContentProvider.this.refreshViewer(element);
                }
                if (element.getWrapped() instanceof IRoute) {
                    OpenShiftExplorerContentProvider.this.viewer.update(element.getParent(), null);
                }
            }
        };
        model.addListener(this.listener);
    }

    protected void refreshViewer(Object element) {
        if (this.viewer != null) {
            this.viewer.refresh(element);
        }
    }

    protected void asyncExec(Runnable r) {
        Control control;
        if (this.viewer != null && (control = this.viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(r);
        }
    }

    public void dispose() {
        this.model.removeListener(this.listener);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ConnectionsRegistry) {
            return this.model.getConnections().toArray();
        }
        return new Object[0];
    }

    private void handleLoadingException(Object parentElement, Throwable e) {
        BaseExplorerContentProvider.LoadingStub stub = this.makeStub(parentElement);
        stub.add(e);
        this.asyncExec(() -> this.refreshViewer(parentElement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseExplorerContentProvider.LoadingStub makeStub(Object parentElement) {
        Map<Object, BaseExplorerContentProvider.LoadingStub> map = this.stubs;
        synchronized (map) {
            BaseExplorerContentProvider.LoadingStub stub = this.stubs.get(parentElement);
            if (stub == null) {
                stub = new BaseExplorerContentProvider.LoadingStub();
                this.stubs.put(parentElement, stub);
            }
            return stub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseExplorerContentProvider.LoadingStub removeStub(Object parentElement) {
        Map<Object, BaseExplorerContentProvider.LoadingStub> map = this.stubs;
        synchronized (map) {
            return this.stubs.remove(parentElement);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConnectionWrapper) {
            return this.getConnectionChildren((IConnectionWrapper)parentElement);
        }
        if (parentElement instanceof IProjectWrapper) {
            return this.getProjectChildren((IProjectWrapper)parentElement);
        }
        if (parentElement instanceof IServiceWrapper) {
            return this.getContainerChildren((IResourceContainer)parentElement);
        }
        if (parentElement instanceof IReplicationControllerWrapper) {
            return this.getContainerChildren((IResourceContainer)parentElement);
        }
        if (parentElement instanceof BaseExplorerContentProvider.LoadingStub) {
            return ((BaseExplorerContentProvider.LoadingStub)parentElement).getChildren();
        }
        return new Object[0];
    }

    protected Object[] getConnectionChildren(IConnectionWrapper connection) {
        switch (connection.getState()) {
            case LOADED: {
                this.removeStub(connection);
                Object[] result = connection.getResources().toArray();
                if (result == null || result.length == 0) {
                    result = new Object[]{new NewProjectLinkNode((Connection)connection.getWrapped())};
                }
                return result;
            }
            case LOAD_STOPPED: {
                BaseExplorerContentProvider.LoadingStub stub = this.removeStub(connection);
                if (stub == null) break;
                return stub.getChildren();
            }
        }
        connection.load(e -> this.handleLoadingException(connection, e));
        return new Object[]{this.makeStub(connection)};
    }

    protected Object[] getProjectChildren(IProjectWrapper project) {
        switch (project.getState()) {
            case LOADED: {
                this.removeStub(project);
                Collection services = project.getResourcesOfKind("Service");
                Collection dcs = project.getResourcesOfType(IReplicationControllerWrapper.class);
                services.addAll(dcs);
                return services.toArray();
            }
            case LOAD_STOPPED: {
                BaseExplorerContentProvider.LoadingStub stub = this.removeStub(project);
                if (stub == null) break;
                return stub.getChildren();
            }
        }
        project.load(e -> this.handleLoadingException(project, e));
        return new Object[]{this.makeStub(project)};
    }

    protected Object[] getContainerChildren(IResourceContainer<?, IOpenshiftUIElement<?, ?>> service) {
        ArrayList result = new ArrayList();
        service.getResourcesOfKind("Build").stream().filter(b -> !this.isTerminatedBuild((IBuild)b.getWrapped())).forEach(r -> {
            boolean bl = result.add(r);
        });
        service.getResourcesOfKind("Pod").stream().filter(p -> !ResourceUtils.isBuildPod((IPod)((IPod)p.getWrapped()))).forEach(r -> {
            boolean bl = result.add(r);
        });
        return result.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)viewer;
    }

    private boolean isTerminatedBuild(IBuild build) {
        String phase = build.getStatus();
        return TERMINATED_STATUS.contains(phase);
    }

    public Object getParent(Object element) {
        if (element instanceof IConnectionWrapper) {
            return ConnectionsRegistrySingleton.getInstance();
        }
        if (element instanceof IOpenshiftUIElement) {
            return ((IOpenshiftUIElement)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof BaseExplorerContentProvider.LoadingStub) {
            return ((BaseExplorerContentProvider.LoadingStub)element).hasChildren();
        }
        return element instanceof ConnectionsRegistry || element instanceof OpenshiftUIModel || element instanceof IConnectionWrapper || element instanceof IProjectWrapper || element instanceof IServiceWrapper || element instanceof IReplicationControllerWrapper;
    }
}

