/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.explorer;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerLabelProvider;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.internal.ui.explorer.NewProjectLinkNode;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.ImageStreamApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateApplicationSource;

public class OpenShiftExplorerLabelProvider
extends BaseExplorerLabelProvider
implements IDescriptionProvider {
    private static final int DEFAULT_LABEL_LIMIT = 60;
    private int labelLimit;
    private static final int STATUS_LINE_LABEL_LIMIT = 512;
    private static final OpenShiftExplorerLabelProvider instanceForDescription = new OpenShiftExplorerLabelProvider();

    static {
        instanceForDescription.setLabelLimit(512);
    }

    public OpenShiftExplorerLabelProvider() {
        this.setLabelLimit(60);
    }

    public void setLabelLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Label limit cannot be less than 1: " + limit);
        }
        this.labelLimit = limit;
    }

    public String getText(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            String name = project.getName();
            if (StringUtils.isNotEmpty((String)project.getDisplayName())) {
                String[] parts = new String[]{project.getDisplayName(), name};
                this.applyEllipses(parts);
                name = String.valueOf(parts[0]) + " (" + parts[1] + ")";
            }
            return name;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        block33: {
            if ((element = this.getAdaptedElement(element)) instanceof NewProjectLinkNode) {
                return OpenShiftImages.PROJECT_NEW_IMG;
            }
            if (!(element instanceof IResource)) break block33;
            IResource resource = (IResource)element;
            switch (resource.getKind()) {
                case "Build": {
                    return OpenShiftImages.BUILD_IMG;
                }
                case "BuildConfig": {
                    return OpenShiftImages.BUILDCONFIG_IMG;
                }
                case "ImageStream": {
                    return OpenShiftImages.IMAGE_IMG;
                }
                case "Pod": {
                    return OpenShiftImages.BLOCKS_IMG;
                }
                case "Project": {
                    return OpenShiftImages.PROJECT_IMG;
                }
                case "Route": {
                    return OpenShiftImages.ROUTE_IMG;
                }
                case "Service": {
                    return OpenShiftImages.SERVICE_IMG;
                }
                case "ReplicationController": 
                case "DeploymentConfig": {
                    return OpenShiftImages.REPLICATION_CONTROLLER_IMG;
                }
            }
            return OpenShiftCommonImages.FILE;
        }
        if (element instanceof ImageStreamApplicationSource) {
            return OpenShiftImages.IMAGE_IMG;
        }
        if (element instanceof TemplateApplicationSource) {
            return OpenShiftImages.TEMPLATE_IMG;
        }
        return super.getImage(element);
    }

    private Object getAdaptedElement(Object element) {
        if (element instanceof IAdaptable) {
            Connection connection;
            IAdaptable adaptable = (IAdaptable)element;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                element = resource;
            }
            if ((connection = (Connection)adaptable.getAdapter(Connection.class)) != null) {
                element = connection;
            }
        }
        return element;
    }

    public StyledString getStyledText(Object element) {
        block35: {
            if (element instanceof IServiceWrapper) {
                IServiceWrapper d = (IServiceWrapper)element;
                return this.style(((IService)d.getWrapped()).getName(), this.formatRoute(d.getResourcesOfKind("Route")));
            }
            if ((element = this.getAdaptedElement(element)) instanceof NewProjectLinkNode) {
                return this.getStyledText((NewProjectLinkNode)element);
            }
            if (element instanceof IApplicationSource) {
                return this.getStyledText((IApplicationSource)element);
            }
            if (!(element instanceof IResource)) break block35;
            IResource resource = (IResource)element;
            switch (resource.getKind()) {
                case "Build": {
                    return this.getStyledText((IBuild)resource);
                }
                case "BuildConfig": {
                    return this.getStyledText((IBuildConfig)resource);
                }
                case "DeploymentConfig": {
                    return this.getStyledText((IDeploymentConfig)resource);
                }
                case "ImageStream": {
                    return this.getStyledText((IImageStream)resource);
                }
                case "Pod": {
                    return this.getStyledText((IPod)resource);
                }
                case "Project": {
                    return this.getStyledText((IProject)resource);
                }
                case "Route": {
                    return this.getStyledText((IRoute)resource);
                }
                case "ReplicationController": {
                    return this.getStyledText((IReplicationController)resource);
                }
                case "Service": {
                    IService service = (IService)resource;
                    return this.getStyledText(service);
                }
            }
        }
        if (element instanceof Connection) {
            return this.getStyledText((Connection)element);
        }
        return super.getStyledText(element);
    }

    private String formatRoute(Collection<IResourceWrapper<?, ?>> routes) {
        if (routes.size() > 0) {
            IRoute route = (IRoute)routes.iterator().next().getWrapped();
            return route.getURL();
        }
        return "";
    }

    private StyledString getStyledText(IService service) {
        String serviceQualifiedText = String.format("selector: %s", org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)service.getSelector()));
        return this.style(service.getName(), serviceQualifiedText);
    }

    private StyledString getStyledText(IReplicationController replicationController) {
        return this.style(replicationController.getName(), String.format("selector: %s", org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)replicationController.getReplicaSelector())));
    }

    private StyledString getStyledText(IRoute route) {
        return this.style(route.getName(), String.format("%s%s", route.getHost(), route.getPath()));
    }

    private StyledString getStyledText(IBuild build) {
        return this.style(build.getName(), build.getStatus() == null ? "Build" : String.format("%s %s", "Build", build.getStatus()));
    }

    private StyledString getStyledText(IBuildConfig config) {
        return this.style(config.getName(), config.getSourceURI());
    }

    private StyledString getStyledText(IDeploymentConfig config) {
        return this.style(config.getName(), String.format("selector: %s", org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)config.getReplicaSelector())));
    }

    private StyledString getStyledText(IPod pod) {
        return this.style(pod.getName(), pod.getStatus() == null ? "Pod" : String.format("%s %s", "Pod", pod.getStatus()));
    }

    private StyledString getStyledText(IImageStream repo) {
        return this.style(repo.getName(), repo.getDockerImageRepository().toString());
    }

    private StyledString getStyledText(Connection conn) {
        String prefix = StringUtils.defaultIfBlank((String)conn.getUsername(), (String)"<unknown user>");
        if (prefix == null) {
            prefix = "<unknown user>";
        }
        return this.style(prefix, conn.toString());
    }

    private StyledString getStyledText(IApplicationSource source) {
        String tags = NLS.bind((String)"({0})", (Object)StringUtils.join(source.getTags(), (String)", "));
        StringBuilder qualifier = new StringBuilder();
        if (!org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)tags)) {
            qualifier.append(tags);
        }
        if (!org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)source.getNamespace())) {
            qualifier.append(" - ").append(source.getNamespace());
        }
        return this.style(source.getName(), qualifier.toString());
    }

    private StyledString getStyledText(IProject project) {
        if (StringUtils.isNotBlank((String)project.getDisplayName())) {
            return this.style(project.getDisplayName(), project.getName());
        }
        return this.style(project.getName(), "");
    }

    private StyledString style(String baseText, String qualifiedText) {
        String[] parts = new String[]{baseText, qualifiedText};
        this.applyEllipses(parts);
        baseText = parts[0];
        qualifiedText = parts[1];
        StyledString value = new StyledString(baseText);
        if (StringUtils.isNotBlank((String)qualifiedText)) {
            value.append(" ").append(qualifiedText, StyledString.QUALIFIER_STYLER);
        }
        return value;
    }

    private void applyEllipses(String[] parts) {
        org.jboss.tools.openshift.common.core.utils.StringUtils.shorten((String[])parts, (int)this.labelLimit);
    }

    private StyledString getStyledText(NewProjectLinkNode node) {
        StyledString value = new StyledString();
        value.append(node.toString(), new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.underline = true;
                textStyle.foreground = Display.getDefault().getSystemColor(9);
            }
        });
        return value;
    }

    public String getDescription(Object anElement) {
        return instanceForDescription.getStyledText(anElement).getString();
    }
}

