/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;

public abstract class AbstractOpenShiftCliHandler
extends AbstractHandler {
    protected abstract void handleEvent(ExecutionEvent var1);

    protected abstract IConnection getConnection(ExecutionEvent var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String location = OCBinary.getInstance().getLocation(this.getConnection(event));
        if (StringUtils.isBlank((String)location)) {
            MessageDialog dialog = new MessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Unknown executable location", null, "The OpenShift Client '" + OCBinary.getInstance().getName() + "' executable can not be found.", 1, new String[]{IDialogConstants.OK_LABEL}, 0){

                protected Control createCustomArea(Composite parent) {
                    Composite container = new Composite(parent, 0);
                    GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
                    GridLayoutFactory.fillDefaults().applyTo(container);
                    Link link = new Link(container, 64);
                    link.setText("You must set the executable location in the <a>OpenShift 3 preferences</a>.");
                    link.addSelectionListener((SelectionListener)new OpenPreferencesListener(this));
                    container.setFocus();
                    return container;
                }
            };
            dialog.open();
            return null;
        }
        this.handleEvent(event);
        return null;
    }

    private static class OpenPreferencesListener
    extends SelectionAdapter {
        private Dialog dialog;

        public OpenPreferencesListener(MessageDialog messageDialog) {
            this.dialog = messageDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            this.dialog.close();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"org.jboss.tools.openshift.ui.preferences.OpenShiftPreferencePage", (String[])new String[]{"org.jboss.tools.openshift.ui.preferences.OpenShiftPreferencePage"}, null).open();
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

