/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IResource;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;
import org.jboss.tools.openshift.internal.ui.job.OpenShiftJobs;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.wizard.resource.DeleteResourcesWizard;

public class DeleteResourcesHandler
extends AbstractHandler {
    private static final Point DIALOG_SIZE = new Point(800, 600);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] wrappers = (IResourceWrapper[])UIUtils.getElements((ISelection)UIUtils.getCurrentSelection((ExecutionEvent)event), IResourceWrapper.class);
        if (ArrayUtils.isEmpty((Object[])wrappers) || wrappers[0].getWrapped() == null) {
            return OpenShiftUIActivator.statusFactory().cancelStatus("Could not delete resources: No resource selected that we can get the connection and namespace from.");
        }
        IResource selectedResource = (IResource)wrappers[0].getWrapped();
        Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)selectedResource);
        if (connection == null) {
            return OpenShiftUIActivator.statusFactory().cancelStatus(NLS.bind((String)"Could not delete resources: No connection found for selected resource {0}", (Object)selectedResource.getName()));
        }
        String namespace = selectedResource.getNamespace();
        this.openDialog(connection, namespace, HandlerUtil.getActiveShell((ExecutionEvent)event));
        return null;
    }

    private void openDialog(Connection connection, String namespace, Shell shell) {
        OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog("Delete", shell, (IWizard)new DeleteResourcesWizard(connection, namespace));
        dialog.setPageSize(DIALOG_SIZE);
        dialog.open();
    }

    protected void deleteResources(IResourceWrapper<?, ?>[] uiResources) {
        JobGroup group = new JobGroup("Delete Openshift resources", 1, uiResources.length){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return false;
            }
        };
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<IResourceWrapper<?, ?>> stream = Arrays.stream(uiResources);){
            stream.forEach(uiResource -> {
                DeleteResourceJob job = OpenShiftJobs.createDeleteResourceJob((IResource)uiResource.getWrapped());
                job.setJobGroup(group);
                job.schedule();
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

